/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.mobilelist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.mobile.AbstractBaseDataMobileExtendHandler;
import kd.bos.base.mobile.AbstractUserMobileExtendHandler;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.mobilelist.MobileListPluginUtils;
import kd.bos.entity.mobilelist.OrgMobileTree;
import kd.bos.entity.pojo.MobEventType;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.events.BackPressedEvent;
import kd.bos.list.events.EndSelectEvent;
import kd.bos.list.events.ItemSelectEvent;
import kd.bos.list.events.ListSelectedListener;
import kd.bos.list.events.QueryListEvent;
import kd.bos.list.events.SelectEvent;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public abstract class AbstractBaseMobListPlugin
extends AbstractMobListPlugin
implements ListSelectedListener {
    protected static final Log log = LogFactory.getLog(AbstractBaseMobListPlugin.class);
    private static final String CACHE_ID_RANGE = "mobileListIdRange";
    private static final String CACHE_ORG_ID_RANGE = "mobileListOrgIdRange";
    private static final String CACHE_CONFIG = "mobileListConfig";
    private static final String SEARCH_TYPE_START_WITH = "2";
    private List<AbstractBaseDataMobileExtendHandler> extendHandlers;
    private List<QFilter> filters = new ArrayList<QFilter>();
    private String nameProperty;
    private String orgNameProperty;
    private String orderBy;
    private String orgOrderBy;
    private List<Long> rangeIds;
    private List<Long> rangeOrgIds;
    private OrgMobileTree orgTree;

    protected abstract String getBizExtCaseNumber();

    protected abstract String getEntityNumber();

    public final void afterCreateNewData(EventObject e) {
        log.info("\u3010\u79fb\u52a8\u7aefF7\u3011\u6ce8\u518c\u81ea\u5b9a\u4e49\u63d2\u4ef6\u6570\u91cf\uff1a" + this.getExtendHandlers().size());
        this.initFilter();
        this.afterCreateNewMobData(e);
    }

    protected void afterCreateNewMobData(EventObject e) {
    }

    private void initFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        log.info("\u3010\u79fb\u52a8\u7aefF7\u3011\u81ea\u5b9a\u4e49\u53c2\u6570\uff1a" + formShowParameter.getCustomParams());
        Object otherFiltersParam = formShowParameter.getCustomParam("_otherFilters_");
        QFilter otherFilters = MobileListPluginUtils.analysisCustomParam(otherFiltersParam);
        this.addFilter(otherFilters);
        log.info("\u3010\u79fb\u52a8\u7aefF7\u3011\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u6761\u4ef6\uff1a" + otherFilters);
        List paramIds = (List)formShowParameter.getCustomParam("range");
        if (paramIds == null) {
            paramIds = (List)formShowParameter.getCustomParam("rang");
        }
        List<Long> excludeIds = this.getExcludeIds();
        if (paramIds != null) {
            ArrayList<Long> ids = new ArrayList<Long>(paramIds.size());
            for (Object id : paramIds) {
                ids.add(Long.valueOf(id.toString()));
            }
            if (excludeIds != null) {
                ids.removeAll(excludeIds);
            }
            this.addFilter(new QFilter("id", "in", ids));
        } else if (excludeIds != null) {
            this.addFilter(new QFilter("id", "not in", excludeIds));
        }
        for (AbstractBaseDataMobileExtendHandler customMobListPlugin : this.getExtendHandlers()) {
            customMobListPlugin.addFilter(this.filters);
        }
        this.cacheInitFilter();
    }

    protected Set<Long> cacheInitFilter() {
        return new HashSet<Long>(0);
    }

    protected List<Long> getExcludeIds() {
        return null;
    }

    protected abstract String getDataListKey();

    protected OrgMobileTree getOrgTree() {
        if (this.orgTree == null) {
            this.orgTree = new OrgMobileTree(this.getView(), this.getOrgViewId(), this.getOrgNameProperty(), this.getOrgOrderBy());
        }
        return this.orgTree;
    }

    protected abstract void bindData(Object var1);

    public void select(SelectEvent event) {
        this.bindData(event.getData());
    }

    public void backPressed(BackPressedEvent event) {
        Object param = this.backPressedData(event.getData());
        if (param == null) {
            this.getView().close();
        } else {
            this.bindData(param);
        }
    }

    protected Object backPressedData(Object param) {
        return param;
    }

    public void itemSelect(ItemSelectEvent event) {
        this.bindData(event.getData());
    }

    public void endSelect(EndSelectEvent event) {
        Object data = event.getData();
        if (!(data instanceof ListSelectedRowCollection)) {
            data = new ListSelectedRowCollection();
            ((ListSelectedRowCollection)data).setClearFlag(true);
        }
        ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)data;
        List<AbstractBaseDataMobileExtendHandler> extendHandlers = this.getExtendHandlers();
        if (!extendHandlers.isEmpty()) {
            BeforeDoOperationEventArgs eventArgs = new BeforeDoOperationEventArgs((Object)this.getView().getFormShowParameter());
            eventArgs.setListSelectedData(selectedRows);
            for (AbstractBaseDataMobileExtendHandler plugin : extendHandlers) {
                plugin.beforeClosed((Object)eventArgs);
            }
            if (eventArgs.isCancel()) {
                this.getView().showTipNotification(eventArgs.getCancelMessage());
                return;
            }
        }
        this.beforeDndSelectClosed(selectedRows);
        this.getView().returnDataToParent((Object)selectedRows);
        this.getView().close();
    }

    protected void beforeDndSelectClosed(ListSelectedRowCollection selectedRows) {
    }

    public void query(QueryListEvent queryEvent) {
        Object selectObj = queryEvent.getData();
        if (StringUtils.isBlank((Object)selectObj)) {
            return;
        }
        this.setLookUpListValue(this.getDataListKey(), this.query(this.getSearchFilter(selectObj.toString())), MobEventType.SEARCH);
    }

    protected abstract Object query(QFilter var1);

    private QFilter getSearchFilter(String searchText) {
        QFilter filter = this.getSearchKeyFilter(searchText);
        List<Long> cacheIdRange = this.getCacheIdRange();
        if (cacheIdRange != null) {
            QFilter rangeFilter = new QFilter("id", "in", cacheIdRange);
            filter = filter == null ? rangeFilter : filter.and(rangeFilter);
        }
        return filter;
    }

    private QFilter getSearchKeyFilter(String searchText) {
        HashSet<String> customSearchProperties = new HashSet<String>(8);
        customSearchProperties.add("number");
        customSearchProperties.add(this.getNameProperty());
        for (AbstractBaseDataMobileExtendHandler customMobListPlugin : this.getExtendHandlers()) {
            customMobListPlugin.addSearchProperties(customSearchProperties);
        }
        if (customSearchProperties.isEmpty()) {
            return null;
        }
        Object queryType = SystemParamServiceHelper.getBillParameter((String)this.getEntityNumber(), (String)"searchtype");
        String queryKey = SEARCH_TYPE_START_WITH.equals(queryType) ? searchText + "%" : "%" + searchText + "%";
        QFilter filter = null;
        for (String property : customSearchProperties) {
            QFilter proFilter = QFilter.like((String)property, (String)queryKey);
            if (filter == null) {
                filter = proFilter;
                continue;
            }
            filter = filter.or(proFilter);
        }
        return filter;
    }

    protected long getOrgViewId() {
        return 1L;
    }

    protected String getDefaultNameProperty() {
        return "name";
    }

    protected String getNameProperty() {
        if (this.nameProperty != null) {
            return this.nameProperty;
        }
        for (AbstractBaseDataMobileExtendHandler customMobListPlugin : this.getExtendHandlers()) {
            if (!StringUtils.isNotBlank((CharSequence)customMobListPlugin.getNameProperty())) continue;
            this.nameProperty = customMobListPlugin.getNameProperty();
        }
        if (StringUtils.isBlank((CharSequence)this.nameProperty)) {
            this.nameProperty = this.getDefaultNameProperty();
        }
        return this.nameProperty;
    }

    protected String getOrderBy() {
        if (this.orderBy != null) {
            return this.orderBy;
        }
        for (AbstractBaseDataMobileExtendHandler customMobListPlugin : this.getExtendHandlers()) {
            if (!StringUtils.isNotBlank((CharSequence)customMobListPlugin.getOrderBy())) continue;
            this.orderBy = customMobListPlugin.getOrderBy();
        }
        return this.orderBy;
    }

    private String getOrgNameProperty() {
        if (this.orgNameProperty != null) {
            return this.orgNameProperty;
        }
        for (AbstractBaseDataMobileExtendHandler customMobListPlugin : this.getExtendHandlers()) {
            if (customMobListPlugin instanceof AbstractUserMobileExtendHandler) {
                AbstractUserMobileExtendHandler userMobilePlugin = (AbstractUserMobileExtendHandler)customMobListPlugin;
                if (!StringUtils.isNotBlank((CharSequence)userMobilePlugin.getDptNameProperty())) continue;
                this.orgNameProperty = userMobilePlugin.getDptNameProperty();
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)customMobListPlugin.getNameProperty())) continue;
            this.orgNameProperty = customMobListPlugin.getNameProperty();
        }
        if (StringUtils.isBlank((CharSequence)this.orgNameProperty)) {
            this.orgNameProperty = MobileListPluginUtils.getOrgNameDisplayPro(this.getView(), "bos_org");
        }
        return this.orgNameProperty;
    }

    private String getOrgOrderBy() {
        if (this.orgOrderBy != null) {
            return this.orgOrderBy;
        }
        for (AbstractBaseDataMobileExtendHandler customMobListPlugin : this.getExtendHandlers()) {
            if (customMobListPlugin instanceof AbstractUserMobileExtendHandler) {
                AbstractUserMobileExtendHandler userMobilePlugin = (AbstractUserMobileExtendHandler)customMobListPlugin;
                if (!StringUtils.isNotBlank((CharSequence)userMobilePlugin.getDptOrderBy())) continue;
                this.orgOrderBy = userMobilePlugin.getDptOrderBy();
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)customMobListPlugin.getOrderBy())) continue;
            this.orgOrderBy = customMobListPlugin.getOrderBy();
        }
        return this.orgOrderBy;
    }

    protected void addFilter(QFilter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    protected List<QFilter> getFilters() {
        return new ArrayList<QFilter>(this.filters);
    }

    protected Set<Long> cacheIdRange(boolean cacheId, String orgField) {
        HashSet<Long> ids = null;
        HashSet<Object> orgIds = null;
        StringJoiner selectFields = new StringJoiner(",");
        if (cacheId) {
            selectFields.add("id");
            ids = new HashSet<Long>();
        }
        if (StringUtils.isNotBlank((CharSequence)orgField)) {
            selectFields.add(orgField + " " + "org");
            orgIds = new HashSet<Object>();
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.entity.mobilelist.AbstractBaseMobListPlugin.cacheIdRange", (String)this.getEntityNumber(), (String)selectFields.toString(), (QFilter[])this.getFilters().toArray(new QFilter[0]), (String)"");){
            for (Row row : dataSet) {
                if (ids != null) {
                    ids.add(row.getLong("id"));
                }
                if (orgIds == null) continue;
                orgIds.add(row.get("org"));
            }
        }
        if (ids != null) {
            this.getPageCache().put(CACHE_ID_RANGE, SerializationUtils.toJsonString(ids));
        }
        if (orgIds != null) {
            this.getPageCache().put(CACHE_ORG_ID_RANGE, SerializationUtils.toJsonString(orgIds));
        }
        return ids;
    }

    protected List<Long> getCacheIdRange() {
        this.rangeIds = this.getCacheIdRange(this.rangeIds, CACHE_ID_RANGE);
        return this.rangeIds;
    }

    protected List<Long> getCacheOrgIdRange() {
        this.rangeOrgIds = this.getCacheIdRange(this.rangeOrgIds, CACHE_ORG_ID_RANGE);
        return this.rangeOrgIds;
    }

    private List<Long> getCacheIdRange(List<Long> ids, String cacheKey) {
        if (ids != null) {
            return ids;
        }
        String cacheIdRange = this.getPageCache().get(cacheKey);
        if (cacheIdRange == null) {
            return new ArrayList<Long>();
        }
        List cacheIds = (List)SerializationUtils.fromJsonString((String)cacheIdRange, List.class);
        ids = new ArrayList<Long>(cacheIds.size());
        for (Object id : cacheIds) {
            ids.add(Long.valueOf(id.toString()));
        }
        return ids;
    }

    protected Map<String, Object> getConfig() {
        String configCache = this.getPageCache().get(CACHE_CONFIG);
        if (StringUtils.isNotBlank((CharSequence)configCache)) {
            return (Map)SerializationUtils.fromJsonString((String)configCache, Map.class);
        }
        HashMap<String, Object> config = new HashMap<String, Object>(4);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean isMulti = customParams.getOrDefault("isMulti", false);
        config.put("isMulti", Boolean.parseBoolean(((Object)isMulti).toString()));
        Boolean mustInput = customParams.getOrDefault("mustInput", false);
        config.put("mustInput", Boolean.parseBoolean(((Object)mustInput).toString()));
        config.put("selected", this.convertSelected(this.convertType((List)this.getView().getFormShowParameter().getCustomParam("selected"))));
        this.getPageCache().put(CACHE_CONFIG, SerializationUtils.toJsonString(config));
        return config;
    }

    protected List<Long> convertType(List<Object> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return Collections.emptyList();
        }
        ArrayList<Long> result = new ArrayList<Long>(paramList.size());
        for (Object id : paramList) {
            if (StringUtils.isBlank((Object)id)) continue;
            result.add(Long.parseLong(id.toString()));
        }
        return result;
    }

    protected Object convertSelected(List<Long> selectedIds) {
        return selectedIds;
    }

    protected void updateControlStates(Object data, MobEventType type) {
        this.getClientViewProxy().addAction("u", this.modifyData(data, type));
    }

    protected void setLookUpListValue(String key, Object data, MobEventType type) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(1);
        dataMap.put("data", data);
        this.getClientViewProxy().invokeControlMethod(key, "setLookUpListValue", new Object[]{this.modifyData(dataMap, type)});
    }

    private IClientViewProxy getClientViewProxy() {
        return (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
    }

    private Object modifyData(Object data, MobEventType type) {
        if (data == null || type == MobEventType.NONE || this.getExtendHandlers().isEmpty()) {
            return data;
        }
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)data), Map.class);
        for (AbstractBaseDataMobileExtendHandler plugin : this.getExtendHandlers()) {
            switch (type) {
                case HOME: {
                    plugin.modifyHomeData(dataMap);
                    break;
                }
                case PAGE: {
                    plugin.modifyPageData(dataMap);
                    break;
                }
                case SEARCH: {
                    plugin.modifySearchData(dataMap);
                    break;
                }
            }
        }
        return dataMap;
    }

    private List<AbstractBaseDataMobileExtendHandler> getExtendHandlers() {
        if (this.extendHandlers != null) {
            return this.extendHandlers;
        }
        this.extendHandlers = new ArrayList<AbstractBaseDataMobileExtendHandler>();
        PluginProxy pluginProxy = PluginProxy.create(AbstractBaseDataMobileExtendHandler.class, (String)this.getBizExtCaseNumber());
        List proxyPlugins = pluginProxy.getPlugins();
        if (proxyPlugins == null || proxyPlugins.isEmpty()) {
            return this.extendHandlers;
        }
        proxyPlugins.forEach(plugin -> {
            plugin.setFormShowParameter((Object)this.getView().getFormShowParameter());
            this.extendHandlers.add((AbstractBaseDataMobileExtendHandler)plugin);
        });
        return this.extendHandlers;
    }
}

