/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.mobilelist;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.LayoutControlInfo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.plugin.Plugin;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ORMUtil;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.MobileList;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.events.EndSelectEvent;
import kd.bos.list.events.ListSelectedListener;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.parameter.MobileListParam;

public class MobileListF7Plugin
extends AbstractMobListPlugin
implements ListSelectedListener {
    private static final String CONTROL_MOBILELISTAP = "mobilelistap";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void initialize() {
        MobileListParam mobileListParam;
        MobileList mobileList = (MobileList)this.getControl(CONTROL_MOBILELISTAP);
        String mobileListParamStr = (String)this.getView().getFormShowParameter().getCustomParam("mobileListParam");
        if (mobileListParamStr != null && (mobileListParam = this.getMobileListParam(mobileListParamStr)) != null) {
            ListShowParameter listShowParameter = mobileListParam.getListShowParameter();
            if (listShowParameter != null) {
                mobileList.setListShowParameter(listShowParameter);
                mobileList.setMulti(listShowParameter.isMultiSelect());
                mobileList.setBillFormId(listShowParameter.getBillFormId());
            }
            mobileList.setPrimaryField(mobileListParam.getPrimaryField());
            mobileList.setSecondField(mobileListParam.getSecondField());
            mobileList.setIconField(mobileListParam.getIconField());
            mobileList.setShowModal(mobileListParam.isShowModal());
            mobileList.setShowSearch(mobileListParam.isShowSearch());
            mobileList.setPageRow(mobileListParam.getPageRow());
            mobileList.setShowFrequent(mobileListParam.isShowFrequent());
        }
        super.initialize();
    }

    public void registerListener(EventObject e) {
        MobileList mobileList = (MobileList)this.getControl(CONTROL_MOBILELISTAP);
        mobileList.addListSelectedListener((ListSelectedListener)this);
        super.registerListener(e);
    }

    private MobileListParam getMobileListParam(String serializeString) {
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(MobileListShowParameter.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRowCollection.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(ListSelectedRow.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(MobileListParam.class));
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        return (MobileListParam)dcJsonSerializer.deserializeFromString(serializeString, null);
    }

    public void endSelect(EndSelectEvent event) {
        if (this.switchBilltype(event)) {
            return;
        }
        this.getView().returnDataToParent(event.getData());
        this.getView().close();
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("switchbilltype".equals(event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                Map customVauleMap = (Map)SerializationUtils.fromJsonString((String)event.getCustomVaule(), Map.class);
                if (customVauleMap != null && StringUtils.isNotBlank(customVauleMap.get("formId"))) {
                    Object billTypeId = customVauleMap.get("billTypeId");
                    String formId = (String)customVauleMap.get("formId");
                    this.showLayoutForm(formId, billTypeId);
                }
                this.getView().returnDataToParent(SerializationUtils.fromJsonString((String)this.getPageCache().get("billTypeClientArgs"), ListSelectedRowCollection.class));
                this.getView().close();
            } else if (event.getResult() == MessageBoxResult.Cancel) {
                this.getView().close();
            }
        }
    }

    private boolean switchBilltype(EndSelectEvent event) {
        Map resultMap;
        String formId;
        String originFieldKey;
        if (!this.isBosBilltype(event)) {
            return false;
        }
        if (!(event.getData() instanceof ListSelectedRowCollection)) {
            return false;
        }
        ListSelectedRowCollection rows = (ListSelectedRowCollection)event.getData();
        if (rows == null || rows.isEmpty() && !rows.isClearFlag()) {
            return false;
        }
        ListSelectedRow newValue = rows.get(0);
        String newId = newValue.getPrimaryKeyValue().toString();
        if (StringUtils.isBlank((CharSequence)newId)) {
            return false;
        }
        String oldId = "";
        MobileList mobileList = (MobileList)this.getControl(CONTROL_MOBILELISTAP);
        ListShowParameter listShowParameter = mobileList.getListShowParameter();
        String string = originFieldKey = listShowParameter.getCustomParam("originFieldKey") == null ? "" : (String)listShowParameter.getCustomParam("originFieldKey");
        if (StringUtils.isNotBlank((CharSequence)originFieldKey)) {
            DynamicObject oldValue = (DynamicObject)this.getView().getParentView().getModel().getValue(originFieldKey);
            String string2 = oldId = oldValue != null ? oldValue.getPkValue().toString() : null;
        }
        if (!newId.equalsIgnoreCase(oldId) && LayoutControlInfo.isBillTypeLayout() && StringUtils.isNotBlank((CharSequence)(formId = (String)(resultMap = ORMUtil.getFormIdByBillTypeId((long)Long.parseLong(newId), (boolean)true)).get("formId"))) && !StringUtils.equals((CharSequence)formId, (CharSequence)this.getView().getParentView().getFormShowParameter().getFormId())) {
            if (Boolean.parseBoolean((String)resultMap.get("isMobFormId"))) {
                this.prompt(formId, newId, rows);
                return true;
            }
            if (StringUtils.isNotBlank((CharSequence)oldId) && Boolean.parseBoolean((String)(resultMap = ORMUtil.getFormIdByBillTypeId((long)Long.parseLong(oldId), (boolean)true)).get("isMobFormId"))) {
                this.prompt(formId, newId, rows);
                return true;
            }
        }
        return false;
    }

    private boolean isBosBilltype(EndSelectEvent event) {
        return event.getSource() instanceof MobileList && "bos_billtype".equals(((MobileList)event.getSource()).getBillFormId());
    }

    private void prompt(String formId, String billTypeId, ListSelectedRowCollection rows) {
        this.getPageCache().put("billTypeClientArgs", SerializationUtils.toJsonString((Object)rows));
        HashMap<String, String> callbackValue = new HashMap<String, String>();
        callbackValue.put("formId", formId);
        callbackValue.put("billTypeId", billTypeId);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u5207\u6362\uff0c\u5c06\u6e05\u9664\u5355\u636e\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"MobileListF7Plugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("switchbilltype", (IFormPlugin)this), null, SerializationUtils.toJsonString(callbackValue));
    }

    private void showLayoutForm(String formId, Object billTypePkId) {
        IFormView parentView = this.getView().getParentView();
        MobileBillShowParameter billShowParameter = (MobileBillShowParameter)parentView.getFormShowParameter();
        List plugins = billShowParameter.getFormConfig().getPlugins();
        billShowParameter.setFormId(formId);
        billShowParameter.setBillTypeId(String.valueOf(billTypePkId));
        billShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        billShowParameter.setCustomParam("mainOrgId", (Object)this.getMainOrgId());
        billShowParameter.setFormConfig(FormMetadataCache.getFormConfig((String)formId));
        for (Plugin plugin : plugins) {
            if (!plugin.isDynamicPlugin()) continue;
            billShowParameter.addCustPlugin(plugin.getClassName());
        }
        billShowParameter.getCustomParams().put("bos_call_source_type", "billType_showLayoutForm");
        parentView.showForm((FormShowParameter)billShowParameter);
    }

    private Long getMainOrgId() {
        IDataModel parentModel = this.getView().getParentView().getModel();
        MainOrgProp mainOrgProperty = ((BillEntityType)parentModel.getDataEntityType()).getMainOrgProperty();
        if (mainOrgProperty == null) {
            return null;
        }
        DynamicObject mainOrg = (DynamicObject)parentModel.getValue(mainOrgProperty.getName());
        return mainOrg == null ? null : (Long)mainOrg.getPkValue();
    }
}

