/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.mobilelist;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class MobileListPluginUtils {
    public static final String ORG_NAME_DISPLAY_PRO = "orgNameDisplayPro";

    private MobileListPluginUtils() {
    }

    public static String getOrgDisplayName(IFormView view, String entityName, DynamicObject orgObj) {
        return MobileListPluginUtils.getOrgDisplayName(MobileListPluginUtils.getOrgNameDisplayPro(view, entityName), orgObj);
    }

    public static String getOrgDisplayName(String orgNameDisplayPro, DynamicObject orgObj) {
        return orgObj.getString(orgNameDisplayPro);
    }

    public static String getOrgNameDisplayPro(IFormView view, String entityName) {
        String cacheKey = ORG_NAME_DISPLAY_PRO + entityName;
        String orgNameDisplayPro = view.getPageCache().get(cacheKey);
        if (StringUtils.isNotBlank((CharSequence)orgNameDisplayPro)) {
            return orgNameDisplayPro;
        }
        Object customParam = view.getFormShowParameter().getCustomParam(ORG_NAME_DISPLAY_PRO);
        if (StringUtils.isNotBlank((Object)customParam)) {
            orgNameDisplayPro = customParam.toString();
        } else {
            try {
                Object billParameter = SystemParamServiceHelper.getBillParameter((String)entityName, (String)ORG_NAME_DISPLAY_PRO);
                orgNameDisplayPro = StringUtils.isBlank((Object)billParameter) ? "name" : billParameter.toString();
            }
            catch (Exception e) {
                orgNameDisplayPro = "name";
            }
        }
        view.getPageCache().put(cacheKey, orgNameDisplayPro);
        return orgNameDisplayPro;
    }

    public static QFilter analysisCustomParam(Object paramObject) {
        if (paramObject == null || StringUtils.isBlank((Object)paramObject)) {
            return null;
        }
        QFilter otherQFilters = null;
        if (paramObject instanceof String) {
            otherQFilters = QFilter.fromSerializedString((String)((String)paramObject));
        } else if (paramObject instanceof List) {
            List filterList = (List)paramObject;
            for (Object otherFilterJson : filterList) {
                if (StringUtils.isBlank(otherFilterJson)) continue;
                QFilter otherFilter = (QFilter)SerializationUtils.fromJsonString((String)otherFilterJson.toString(), QFilter.class);
                if (otherQFilters == null) {
                    otherQFilters = otherFilter;
                    continue;
                }
                otherQFilters = otherQFilters.and(otherFilter);
            }
        }
        return otherQFilters;
    }
}

