/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.mobilelist;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.mobilelist.AbstractBaseMobListPlugin;
import kd.bos.entity.mobilelist.MobileListPluginUtils;
import kd.bos.entity.mobilelist.OrgMobileTree;
import kd.bos.entity.pojo.MobEventType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.list.OrgList;
import kd.bos.list.events.ListSelectedListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OrgListPlugin
extends AbstractBaseMobListPlugin {
    private static final String ORG_FUNC_ID = "orgFuncId";
    private static final String ORG_VIEW_SCHEME_ID = "orgViewSchemeId";
    private static final String ORG_VIEW_SCHEME_NUMBER = "orgViewSchemeNumber";
    public static final String ORG_LIST = "orglist";
    private static final String SUB_ORG = "orgs";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        OrgList orgList = (OrgList)this.getView().getControl(ORG_LIST);
        if (orgList != null) {
            orgList.addListSelectedListener((ListSelectedListener)this);
            this.addClickListeners(new String[]{ORG_LIST});
        }
    }

    @Override
    protected String getEntityNumber() {
        return "bos_org";
    }

    @Override
    public void afterCreateNewMobData(EventObject e) {
        long initOrgId = 0L;
        Object initOrgIdParam = this.getView().getFormShowParameter().getCustomParam("initOrgId");
        if (StringUtils.isNotBlank((Object)initOrgIdParam)) {
            initOrgId = Long.parseLong(initOrgIdParam.toString());
        }
        OrgMobileTree orgTree = this.getOrgTree();
        TreeNode rootNode = orgTree.initialize(initOrgId, this.getCacheOrgIdRange());
        HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
        if (StringUtils.isBlank((CharSequence)rootNode.getId())) {
            ArrayList<Map<String, Object>> dataMapList = new ArrayList<Map<String, Object>>(1);
            dataMapList.add(this.convertToDataMap(rootNode));
            dataMap.put(SUB_ORG, dataMapList);
            this.bindData(dataMap, MobEventType.NONE);
        } else {
            dataMap.put("k", ORG_LIST);
            dataMap.put("initOrgId", rootNode.getId());
            dataMap.put("initOrgHistory", this.convertToDataMapList(orgTree.queryParentNodeByNumber(rootNode.getLongNumber())));
            this.updateControlStates(dataMap, MobEventType.NONE);
        }
    }

    @Override
    protected Object backPressedData(Object param) {
        TreeNode treeNode;
        if (StringUtils.isBlank((Object)param)) {
            return null;
        }
        String parentId = null;
        TreeNode rootNode = this.getOrgTree().getRootNode();
        if (rootNode != null && (treeNode = rootNode.getTreeNode(param.toString())) != null && StringUtils.isNotBlank((CharSequence)treeNode.getParentid())) {
            parentId = treeNode.getParentid();
        }
        return parentId;
    }

    @Override
    protected Object query(QFilter filter) {
        List<TreeNode> treeNodes = this.getOrgTree().query(0L, filter);
        ArrayList dataList = new ArrayList(treeNodes.size());
        for (TreeNode treeNode : treeNodes) {
            HashMap<String, String> dataMap = new HashMap<String, String>(2);
            dataMap.put("id", treeNode.getId());
            dataMap.put("name", treeNode.getText());
            dataList.add(dataMap);
        }
        return dataList;
    }

    @Override
    protected Set<Long> cacheInitFilter() {
        this.addFilter(new QFilter("structure.view", "=", (Object)this.getOrgViewId()));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object customeQfilterParams = customParams.get("OrgEditCustomFilter");
        this.addFilter(MobileListPluginUtils.analysisCustomParam(customeQfilterParams));
        if (Boolean.parseBoolean(((Object)customParams.getOrDefault("isOnlyDisplayOrgLeaves", Boolean.FALSE)).toString())) {
            this.addFilter(new QFilter("structure.isleaf", "=", (Object)Boolean.TRUE));
        }
        if (!Boolean.parseBoolean(((Object)customParams.getOrDefault("isshowdisabled", Boolean.FALSE)).toString())) {
            this.addFilter(new QFilter("structure.isfreeze", "=", (Object)Boolean.FALSE));
        }
        return this.cacheIdRange(false, "id");
    }

    @Override
    protected void bindData(Object param) {
        TreeNode rootTreeNode = this.getOrgTree().getRootNode();
        this.bindData(this.getPageOrgData(param, rootTreeNode), Objects.equals(rootTreeNode.getId(), param) ? MobEventType.HOME : MobEventType.PAGE);
    }

    private void bindData(Map<String, Object> dataMap, MobEventType type) {
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>(2);
        returnDataMap.put("k", ORG_LIST);
        returnDataMap.put("data", dataMap);
        this.updateControlStates(returnDataMap, type);
    }

    private Map<String, Object> getPageOrgData(Object selectKey, TreeNode rootTreeNode) {
        if (StringUtils.isBlank((Object)selectKey)) {
            selectKey = rootTreeNode.getId();
        }
        long orgId = Long.parseLong(selectKey.toString());
        TreeNode treeNode = rootTreeNode.getTreeNode(selectKey.toString());
        Map<String, Object> currentDataMap = this.convertToDataMap(treeNode);
        boolean isRootOrg = Objects.equals(rootTreeNode.getId(), selectKey);
        if (isRootOrg) {
            currentDataMap.put("hc", Boolean.FALSE);
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
        dataMap.put("config", this.getConfig());
        dataMap.putAll(currentDataMap);
        List<TreeNode> children = this.getOrgTree().query(orgId, this.getCacheOrgIdRange());
        List<Map<String, Object>> dataMapList = this.convertToDataMapList(children, isRootOrg ? currentDataMap : null);
        dataMap.put(SUB_ORG, dataMapList);
        return dataMap;
    }

    private List<Map<String, Object>> convertToDataMapList(List<TreeNode> children) {
        return this.convertToDataMapList(children, null);
    }

    private List<Map<String, Object>> convertToDataMapList(List<TreeNode> children, Map<String, Object> rootDataMap) {
        if (CollectionUtils.isEmpty(children)) {
            children = new ArrayList<TreeNode>(0);
        }
        ArrayList<Map<String, Object>> dataMapList = new ArrayList<Map<String, Object>>(children.size());
        if (rootDataMap != null) {
            dataMapList.add(rootDataMap);
        }
        for (TreeNode childNode : children) {
            Map<String, Object> orgDataMap = this.convertToDataMap(childNode);
            dataMapList.add(orgDataMap);
        }
        return dataMapList;
    }

    private Map<String, Object> convertToDataMap(TreeNode treeNode) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        if (treeNode == null) {
            return dataMap;
        }
        dataMap.put("id", treeNode.getId());
        dataMap.put("name", treeNode.getText());
        dataMap.put("hp", StringUtils.isNotBlank((CharSequence)treeNode.getParentid()));
        dataMap.put("hc", treeNode.getChildren() != null);
        if (!treeNode.isCheckable()) {
            dataMap.put("ca", Boolean.FALSE);
        }
        return dataMap;
    }

    @Override
    protected Object convertSelected(List<Long> selectedIds) {
        return this.convertToDataMapList(this.getOrgTree().query(0L, selectedIds));
    }

    @Override
    protected long getOrgViewId() {
        String orgViewSchemeId = this.getPageCache().get(ORG_VIEW_SCHEME_ID);
        if (orgViewSchemeId == null) {
            return this.initializeOrgView();
        }
        return Long.parseLong(orgViewSchemeId);
    }

    private long initializeOrgView() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String orgFuncId = (String)formShowParameter.getCustomParam(ORG_FUNC_ID);
        String orgViewSchemeNumber = (String)formShowParameter.getCustomParam(ORG_VIEW_SCHEME_NUMBER);
        String orgFuncPropName = "fisadministrative";
        long orgViewSchemeId = 1L;
        if (StringUtils.isBlank((CharSequence)orgFuncId) && StringUtils.isBlank((CharSequence)orgViewSchemeNumber)) {
            orgFuncId = "01";
            orgViewSchemeNumber = "01";
        } else {
            QFilter[] filters;
            if (StringUtils.isBlank((CharSequence)orgViewSchemeNumber)) {
                QFilter treeTypeFilter = new QFilter("treetype", "=", (Object)orgFuncId);
                QFilter defaultFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
                filters = new QFilter[]{treeTypeFilter, defaultFilter};
            } else {
                QFilter numberFilter = new QFilter("number", "=", (Object)orgViewSchemeNumber);
                filters = new QFilter[]{numberFilter};
            }
            DynamicObject viewObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_viewschema", (String)"number,treetypeid.fnumber,treetypeid.propertyname", (QFilter[])filters);
            if (viewObject == null) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u7ec4\u7ec7\u804c\u80fd\u7c7b\u578b\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"OrgListPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
            orgViewSchemeId = viewObject.getLong("id");
            orgFuncId = viewObject.getString("treetypeid.fnumber");
            orgViewSchemeNumber = viewObject.getString("number");
            orgFuncPropName = viewObject.getString("treetypeid.propertyname");
        }
        this.getPageCache().put(ORG_VIEW_SCHEME_ID, Long.toString(orgViewSchemeId));
        this.getPageCache().put(ORG_FUNC_ID, orgFuncId);
        this.getPageCache().put(ORG_VIEW_SCHEME_NUMBER, orgViewSchemeNumber);
        this.getPageCache().put("orgFuncPropName", orgFuncPropName);
        return orgViewSchemeId;
    }

    @Override
    protected String getDataListKey() {
        return ORG_LIST;
    }

    @Override
    protected String getDefaultNameProperty() {
        return MobileListPluginUtils.getOrgNameDisplayPro(this.getView(), "bos_org");
    }

    @Override
    protected List<Long> getCacheIdRange() {
        return this.getCacheOrgIdRange();
    }

    @Override
    protected String getBizExtCaseNumber() {
        return "kd.bos.base.mobile.AbstractOrgMobileExtendHandler";
    }
}

