/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.mobilelist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.org.model.OrgTreeBuildType;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgMobileTree {
    private IFormView formView;
    private long viewId;
    private String nameProperty;
    private String orderBy;
    private static final String CACHE_ROOT_TREENODE = "orgMobileRootTreeNode";
    private TreeNode rootNode;

    public OrgMobileTree(IFormView formView, long viewId, String nameProperty, String orderBy) {
        this.formView = formView;
        this.viewId = viewId;
        this.nameProperty = nameProperty;
        this.orderBy = orderBy;
    }

    public TreeNode initialize(long orgId, List<Long> rangeOrgIds) {
        return this.initialize(orgId, rangeOrgIds, true);
    }

    public TreeNode initialize(long orgId, List<Long> rangeOrgIds, boolean cacheRootNode) {
        if (rangeOrgIds == null || !rangeOrgIds.isEmpty()) {
            OrgTreeParam orgTreeParam = this.getOrgTreeParam(orgId, rangeOrgIds, null);
            this.rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)orgTreeParam);
            if (this.rootNode == null && orgId != 0L) {
                orgTreeParam.setId(0L);
                this.rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)orgTreeParam);
            }
        }
        if (this.rootNode == null) {
            this.emptyRootNode();
        } else {
            this.rootNode.setIsOpened(false);
            if (!this.rootNode.isLeaf()) {
                this.rootNode.setChildren(new ArrayList());
            }
        }
        if (cacheRootNode) {
            this.cacheRootNode();
        }
        return this.rootNode;
    }

    private void emptyRootNode() {
        this.rootNode = new TreeNode("", "", ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u9009\u7ec4\u7ec7", (String)"OrgMobileTree_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        this.rootNode.setCheckable(false);
    }

    public void cacheRootNode() {
        if (this.rootNode == null) {
            this.formView.getPageCache().remove(CACHE_ROOT_TREENODE);
        } else {
            this.formView.getPageCache().put(CACHE_ROOT_TREENODE, SerializationUtils.toJsonString((Object)this.rootNode));
        }
    }

    public TreeNode getRootNode() {
        if (this.rootNode == null) {
            String rootNodeCache = this.formView.getPageCache().get(CACHE_ROOT_TREENODE);
            if (StringUtils.isBlank((CharSequence)rootNodeCache)) {
                this.emptyRootNode();
            } else {
                this.rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeCache, TreeNode.class);
            }
        }
        return this.rootNode;
    }

    public List<TreeNode> queryParentNodeById(String nodeId) {
        List<TreeNode> treeNodeList;
        this.getRootNode();
        if (Objects.equals(this.rootNode.getId(), nodeId)) {
            treeNodeList = new ArrayList<TreeNode>(1);
            treeNodeList.add(this.rootNode);
        } else {
            TreeNode treeNode = this.rootNode.getTreeNode(nodeId);
            if (treeNode == null) {
                treeNode = this.queryOne(Long.parseLong(nodeId));
            }
            if (treeNode == null) {
                return Collections.emptyList();
            }
            treeNodeList = this.queryParentNodeByNumber(treeNode.getLongNumber());
        }
        return treeNodeList;
    }

    public List<TreeNode> queryParentNodeByNumber(String longNumber) {
        if (longNumber.indexOf("!") == -1) {
            ArrayList<TreeNode> parentNodes = new ArrayList<TreeNode>(1);
            parentNodes.add(this.getRootNode());
            return parentNodes;
        }
        String[] numbers = StringUtils.split((String)longNumber, (String)"!");
        QFilter numberFilter = new QFilter("number", "in", (Object)numbers);
        OrgTreeParam orgTreeParam = this.getOrgTreeParam(0L, null, numberFilter);
        orgTreeParam.setOrderBy("level");
        return this.query(orgTreeParam);
    }

    public TreeNode queryOne(long id) {
        OrgTreeParam orgTreeParam = this.getOrgTreeParam(id);
        return OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)orgTreeParam);
    }

    public List<TreeNode> query(long orgId, List<Long> rangeOrgIds) {
        return this.query(orgId, rangeOrgIds, null);
    }

    public List<TreeNode> query(long orgId, QFilter customFilter) {
        return this.query(orgId, null, customFilter);
    }

    private List<TreeNode> query(long orgId, List<Long> rangeOrgIds, QFilter customFilter) {
        if (rangeOrgIds != null && rangeOrgIds.isEmpty()) {
            return new ArrayList<TreeNode>(0);
        }
        TreeNode rootTreeNode = this.getRootNode();
        TreeNode treeNode = null;
        if (orgId != 0L) {
            treeNode = rootTreeNode.getTreeNode(Long.toString(orgId));
        }
        return this.query(this.getOrgTreeParam(orgId, rangeOrgIds, customFilter), treeNode);
    }

    private List<TreeNode> query(OrgTreeParam orgTreeParam) {
        TreeNode rootTreeNode = this.getRootNode();
        TreeNode treeNode = null;
        if (orgTreeParam.getId() != 0L) {
            treeNode = rootTreeNode.getTreeNode(Long.toString(orgTreeParam.getId()));
        }
        return this.query(orgTreeParam, treeNode);
    }

    private List<TreeNode> query(OrgTreeParam orgTreeParam, TreeNode treeNode) {
        if (treeNode != null && treeNode.getIsOpened()) {
            return treeNode.getChildren() == null ? new ArrayList(0) : treeNode.getChildren();
        }
        List children = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)orgTreeParam);
        if (treeNode != null) {
            treeNode.setIsOpened(true);
            treeNode.setChildren(children.isEmpty() ? null : children);
            this.cacheRootNode();
        }
        return children;
    }

    private OrgTreeParam getOrgTreeParam(long orgId, List<Long> rangeOrgIds, QFilter customFilter) {
        OrgTreeParam orgTreeParam = this.getOrgTreeParam(orgId);
        orgTreeParam.setOrgRangeList(rangeOrgIds);
        if (customFilter != null) {
            orgTreeParam.getCustomFilterList().add(customFilter);
        }
        return orgTreeParam;
    }

    private OrgTreeParam getOrgTreeParam(long orgId) {
        OrgTreeParam orgTreeParam = new OrgTreeParam();
        orgTreeParam.setId(orgId);
        orgTreeParam.setOrgViewId(this.viewId);
        orgTreeParam.setTreeBuildType((OrgTreeBuildType)(orgId == 0L ? OrgTreeBuildType.QUERY_ALL_AS_LIST : null));
        orgTreeParam.setNameProperty(this.nameProperty);
        orgTreeParam.setOrderBy(this.orderBy);
        orgTreeParam.setBuildRootNodeInRange(true);
        orgTreeParam.setReturnTreeNodeOrMap(true);
        orgTreeParam.setCheckAbleInRange(true);
        orgTreeParam.setIncludeDisable(true);
        orgTreeParam.setIncludeFreeze(true);
        return orgTreeParam;
    }
}

