/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.mobilelist;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.mobilelist.AbstractBaseMobListPlugin;
import kd.bos.entity.mobilelist.MobileListPluginUtils;
import kd.bos.entity.mobilelist.OrgMobileTree;
import kd.bos.entity.pojo.EntityBaseInfo;
import kd.bos.entity.pojo.MobEventType;
import kd.bos.entity.pojo.MobileUserF7PageTypeEnum;
import kd.bos.entity.pojo.OrganizationDTO;
import kd.bos.entity.pojo.UserDTO;
import kd.bos.entity.pojo.UserF7InitDTO;
import kd.bos.entity.pojo.UserF7PageConfig;
import kd.bos.entity.pojo.UserF7PageDTO;
import kd.bos.entity.pojo.UserF7PageEntity;
import kd.bos.entity.pojo.UserF7StartPageOrg;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.list.UserList;
import kd.bos.list.events.ListSelectedListener;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.BasedataFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class UserListPlugin
extends AbstractBaseMobListPlugin {
    private static final String USER_LIST = "userlist";
    private static final String KEY_F7_INDEX_PAGE_DATA = "mobile_user_f7_index_data";
    private static final String KEY_SETTING_STATE = "__useruistate__";
    private static final String KEY_SETTING_USER = "userList";
    private static final String KEY_SETTING_COMMONLY = "frequentContacts";
    private static final String KEY_COMMONLY_USER_FREQUENCY = "frequency";
    private static final String USER_SELECT_FIELDS = "id,picturefield,entryentity.position position,entryentity.ispartjob ispartjob";
    private static final String CACHE_ORDER_BY = "orderBy";
    private static final String ENTRYENTITY_DPT = "entryentity.dpt";
    private static final long NO_ORG_ID = 0L;
    private final String NO_ORG_NAME = ResManager.loadKDString((String)"\u672a\u5206\u914d\u90e8\u95e8", (String)"UserListPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        UserList userList = (UserList)this.getView().getControl(USER_LIST);
        if (userList != null) {
            userList.addListSelectedListener((ListSelectedListener)this);
        }
    }

    @Override
    protected String getEntityNumber() {
        return "bos_user";
    }

    @Override
    public void afterCreateNewMobData(EventObject e) {
        Object initOrgId = this.getView().getFormShowParameter().getCustomParam("initOrgId");
        UserF7InitDTO userF7InitDTO = new UserF7InitDTO();
        if (StringUtils.isBlank((Object)initOrgId)) {
            userF7InitDTO.setInitOrgId("");
        } else {
            userF7InitDTO.setInitOrgId(String.valueOf(initOrgId));
        }
        this.updateControlStates(userF7InitDTO, MobEventType.NONE);
    }

    @Override
    protected Set<Long> cacheInitFilter() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object customFilterParam = formShowParameter.getCustomParam("UserEditCustomFilter");
        this.addFilter(MobileListPluginUtils.analysisCustomParam(customFilterParam));
        List paramOrgList = (List)this.getView().getFormShowParameter().getCustomParam("orgList");
        if (paramOrgList != null) {
            this.addFilter(new QFilter(ENTRYENTITY_DPT, "in", this.convertType(paramOrgList)));
        }
        Set<Long> userIds = this.cacheIdRange(true, ENTRYENTITY_DPT);
        OrgMobileTree orgTree = this.getOrgTree();
        TreeNode rootNode = orgTree.initialize(0L, this.getCacheOrgIdRange(), false);
        if (StringUtils.isBlank((CharSequence)rootNode.getId()) && !userIds.isEmpty()) {
            rootNode.setId(Long.toString(0L));
            rootNode.setText(this.NO_ORG_NAME);
        }
        orgTree.cacheRootNode();
        return userIds;
    }

    @Override
    protected List<Long> getExcludeIds() {
        ArrayList<Long> ids = new ArrayList<Long>(4);
        ids.add(1L);
        ids.add(2L);
        ids.add(3L);
        ids.add(10L);
        return ids;
    }

    @Override
    protected void bindData(Object param) {
        UserF7PageDTO userF7PageDTO;
        if (StringUtils.isBlank((Object)param)) {
            userF7PageDTO = this.getHomeData();
        } else {
            long orgId = Long.parseLong(param.toString());
            userF7PageDTO = this.getPageData(orgId);
        }
        if (Objects.equals(MobileUserF7PageTypeEnum.START_PAGE.getType(), userF7PageDTO.getValue().getPageType())) {
            this.updateControlStates(userF7PageDTO, MobEventType.HOME);
        } else {
            this.updateControlStates(userF7PageDTO, MobEventType.PAGE);
        }
    }

    private UserF7PageDTO getHomeData() {
        String cache = this.getPageCache().get(KEY_F7_INDEX_PAGE_DATA);
        if (StringUtils.isNotBlank((CharSequence)cache)) {
            return (UserF7PageDTO)SerializationUtils.fromJsonString((String)cache, UserF7PageDTO.class);
        }
        UserF7PageDTO userF7PageDTO = new UserF7PageDTO();
        UserF7PageEntity userF7PageEntity = new UserF7PageEntity();
        userF7PageEntity.setConfig(this.getUserF7Config());
        List<Long> rangeIds = this.getCacheIdRange();
        userF7PageEntity.setPageType(MobileUserF7PageTypeEnum.START_PAGE.getType());
        userF7PageEntity.setStartPageOrg(this.getHomeOrgData(rangeIds));
        userF7PageEntity.setUsers(this.getHomeUserData(rangeIds));
        userF7PageDTO.setValue(userF7PageEntity);
        this.getPageCache().put(KEY_F7_INDEX_PAGE_DATA, SerializationUtils.toJsonString((Object)userF7PageDTO));
        return userF7PageDTO;
    }

    private UserF7PageDTO getPageData(long orgId) {
        String cache = this.getPageCache().get(Long.toString(orgId));
        if (StringUtils.isNotBlank((CharSequence)cache)) {
            return (UserF7PageDTO)SerializationUtils.fromJsonString((String)cache, UserF7PageDTO.class);
        }
        UserF7PageDTO userF7PageDTO = new UserF7PageDTO();
        UserF7PageEntity userF7PageEntity = new UserF7PageEntity();
        userF7PageEntity.setConfig(this.getUserF7Config());
        userF7PageEntity.setPageType(MobileUserF7PageTypeEnum.ORG_PAGE.getType());
        userF7PageEntity.setOrgs(this.getPageOrgData(orgId));
        userF7PageEntity.setUsers(this.getPageUserData(orgId));
        userF7PageEntity.setOrgHierarchy(this.getOrgNavigation(orgId));
        userF7PageDTO.setValue(userF7PageEntity);
        this.getPageCache().put(Long.toString(orgId), SerializationUtils.toJsonString((Object)userF7PageDTO));
        return userF7PageDTO;
    }

    private List<OrganizationDTO> getOrgNavigation(long orgId) {
        List<Object> treeNodeList;
        OrgMobileTree orgTree = this.getOrgTree();
        if (orgId == 0L) {
            TreeNode treeNode;
            treeNodeList = new ArrayList(2);
            TreeNode rootNode = orgTree.getRootNode();
            if (StringUtils.isNotBlank((CharSequence)rootNode.getId())) {
                treeNodeList.add(rootNode);
            }
            String noOrgId = Long.toString(0L);
            if (!Objects.equals(rootNode.getId(), noOrgId) && (treeNode = rootNode.getTreeNode(noOrgId)) != null) {
                treeNodeList.add(treeNode);
            }
        } else {
            treeNodeList = orgTree.queryParentNodeById(String.valueOf(orgId));
        }
        ArrayList<OrganizationDTO> orderOrgList = new ArrayList<OrganizationDTO>(treeNodeList.size());
        for (TreeNode treeNode : treeNodeList) {
            OrganizationDTO organizationDTO = new OrganizationDTO();
            organizationDTO.setId(treeNode.getId());
            organizationDTO.setName(treeNode.getText());
            organizationDTO.setHc(treeNode.getChildren() != null);
            organizationDTO.setHp(StringUtils.isNotBlank((CharSequence)treeNode.getParentid()));
            orderOrgList.add(organizationDTO);
        }
        return orderOrgList;
    }

    private UserF7StartPageOrg getHomeOrgData(List<Long> rangeIds) {
        EntityBaseInfo rootOrgInfo = new EntityBaseInfo();
        EntityBaseInfo dptInfo = null;
        OrgMobileTree orgTree = this.getOrgTree();
        TreeNode rootNode = orgTree.getRootNode();
        rootOrgInfo.setId(rootNode.getId());
        if (rangeIds.isEmpty()) {
            rootOrgInfo.setName(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u9009\u4eba\u5458", (String)"UserListPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
        } else {
            rootOrgInfo.setName(rootNode.getText());
            long mainOrgId = UserServiceHelper.getUserMainOrgId((long)RequestContext.get().getCurrUserId());
            if (mainOrgId != 0L && this.getCacheOrgIdRange().contains(mainOrgId)) {
                TreeNode dptTreeNode = rootNode.getTreeNode(Long.toString(mainOrgId));
                if (dptTreeNode == null) {
                    dptTreeNode = orgTree.queryOne(mainOrgId);
                }
                if (dptTreeNode != null) {
                    dptInfo = new EntityBaseInfo();
                    dptInfo.setId(dptTreeNode.getId());
                    dptInfo.setName(dptTreeNode.getText());
                }
            }
        }
        UserF7StartPageOrg userF7StartPageOrg = new UserF7StartPageOrg();
        userF7StartPageOrg.setOrg(rootOrgInfo);
        userF7StartPageOrg.setDpt(dptInfo);
        return userF7StartPageOrg;
    }

    private Collection<UserDTO> getHomeUserData(List<Long> rangeIds) {
        if (rangeIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<UserDTO> userDTOList = this.getAndSetFavoriteSetting(null);
        if (CollectionUtils.isEmpty(userDTOList)) {
            return Collections.emptyList();
        }
        ArrayList<Long> userIds = new ArrayList<Long>(userDTOList.size());
        for (UserDTO dto : userDTOList) {
            Long id;
            String idStr = dto.getId();
            if (StringUtils.isBlank((CharSequence)idStr) || !rangeIds.contains(id = Long.valueOf(idStr))) continue;
            userIds.add(id);
        }
        if (userIds.isEmpty()) {
            return Collections.emptyList();
        }
        QFilter filter = new QFilter("id", "in", userIds);
        return this.query(filter, false);
    }

    private List<OrganizationDTO> getPageOrgData(long orgId) {
        if (orgId == 0L) {
            return new ArrayList<OrganizationDTO>(0);
        }
        OrgMobileTree orgTree = this.getOrgTree();
        List treeNodeList = orgTree.query(orgId, this.getCacheOrgIdRange());
        TreeNode rootNode = orgTree.getRootNode();
        String rootOrgId = rootNode.getId();
        if (Objects.equals(rootOrgId, Long.toString(orgId))) {
            String noOrgId = Long.toString(0L);
            TreeNode noOrgNode = rootNode.getTreeNode(noOrgId);
            if (noOrgNode == null) {
                noOrgNode = new TreeNode(rootOrgId, noOrgId, this.NO_ORG_NAME);
                rootNode.addChild(noOrgNode);
                orgTree.cacheRootNode();
            }
            treeNodeList = rootNode.getChildren();
        }
        ArrayList<OrganizationDTO> result = new ArrayList<OrganizationDTO>(treeNodeList.size());
        for (TreeNode treeNode : treeNodeList) {
            OrganizationDTO orgDTO = new OrganizationDTO();
            orgDTO.setId(treeNode.getId());
            orgDTO.setName(treeNode.getText());
            orgDTO.setLongNumber(treeNode.getLongNumber());
            orgDTO.setHc(treeNode.getChildren() != null);
            orgDTO.setHp(StringUtils.isNotBlank((CharSequence)treeNode.getParentid()));
            result.add(orgDTO);
        }
        return result;
    }

    private Collection<UserDTO> getPageUserData(long orgId) {
        QFilter filter;
        if (orgId == 0L) {
            filter = QFilter.isNull((String)"entryentity");
        } else {
            if (!this.getCacheOrgIdRange().contains(orgId)) {
                return Collections.emptyList();
            }
            filter = new QFilter(ENTRYENTITY_DPT, "=", (Object)orgId);
        }
        filter = filter.and(new QFilter("id", "in", this.getCacheIdRange()));
        return this.query(filter, false);
    }

    @Override
    protected Object query(QFilter filter) {
        return this.query(filter, true);
    }

    private Collection<UserDTO> query(QFilter filter, boolean isSearchEvent) {
        StringJoiner selectFields = new StringJoiner(",");
        String nameProperty = this.getNameProperty();
        selectFields.add(nameProperty);
        selectFields.add(USER_SELECT_FIELDS);
        QFilter otherFilter = null;
        Boolean isSubFullName = null;
        if (isSearchEvent) {
            isSubFullName = Boolean.FALSE;
            String orgNameDisplayPro = MobileListPluginUtils.getOrgNameDisplayPro(this.getView(), "bos_user");
            boolean joinStructureTable = false;
            switch (orgNameDisplayPro) {
                case "simplename": {
                    selectFields.add("entryentity.dpt.simplename orgName");
                    break;
                }
                case "subfullname": {
                    isSubFullName = Boolean.TRUE;
                }
                case "fullname": {
                    selectFields.add("entryentity.dpt.structure.fullname orgName");
                    joinStructureTable = true;
                    break;
                }
                default: {
                    selectFields.add("entryentity.dpt.name orgName");
                }
            }
            otherFilter = new QFilter(ENTRYENTITY_DPT, "in", this.getCacheOrgIdRange());
            if (joinStructureTable) {
                QFilter viewFilter = new QFilter("entryentity.dpt.structure.view", "=", (Object)1L);
                otherFilter = otherFilter.and(viewFilter);
            }
            otherFilter = otherFilter.or(QFilter.isNull((String)"entryentity"));
        }
        return this.query(new QFilter[]{filter, otherFilter}, selectFields.toString(), nameProperty, isSubFullName);
    }

    private Collection<UserDTO> query(QFilter[] filters, String selectFields, String nameProperty, Boolean isSubFullName) {
        DynamicObjectCollection userObjCol = QueryServiceHelper.query((String)"bos_user", (String)selectFields, (QFilter[])filters, (String)this.getOrderBy());
        if (CollectionUtils.isEmpty((Collection)userObjCol)) {
            return new ArrayList<UserDTO>(0);
        }
        LinkedHashMap<String, UserDTO> userDTOMap = new LinkedHashMap<String, UserDTO>(userObjCol.size());
        for (DynamicObject userObj : userObjCol) {
            String userId = userObj.getString("id");
            if (userObj.getBoolean("ispartjob") && userDTOMap.containsKey(userId)) continue;
            UserDTO userDTO = new UserDTO();
            userDTO.setId(userObj.getString("id"));
            userDTO.setName(userObj.getString(nameProperty));
            userDTO.setHeadUrl(userObj.getString("picturefield"));
            if (isSubFullName != null) {
                userDTO.setDpt(this.getSubFullName(userObj.getString("orgName"), isSubFullName));
            }
            userDTO.setPosition(userObj.getString("position"));
            userDTO.setShow(true);
            userDTOMap.put(userId, userDTO);
        }
        return userDTOMap.values();
    }

    @Override
    protected String getOrderBy() {
        String orderBy = super.getOrderBy();
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            orderBy = this.getListFormOrderBy();
        }
        return orderBy;
    }

    private String getListFormOrderBy() {
        String orderBy = this.getPageCache().get(CACHE_ORDER_BY);
        if (StringUtils.isNotBlank((CharSequence)orderBy)) {
            return orderBy;
        }
        try {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"bos_user");
            List items = ((BasedataFormAp)((FormMetadata)MetadataDao.readRuntimeMeta((String)"68bde9ca00000eac", (MetaCategory)MetaCategory.Form)).getRootAp()).getListMeta().getItems();
            StringJoiner orderByFields = new StringJoiner(",");
            for (ControlAp item : items) {
                if (!(item instanceof ListColumnAp)) continue;
                ListColumnAp listColumnAp = (ListColumnAp)item;
                String sortType = listColumnAp.getOrder();
                if (Objects.equals(SortType.NotOrder.name(), sortType)) continue;
                orderByFields.add(this.getFullFieldName(dataEntityType, listColumnAp.getListFieldId()) + " " + sortType);
            }
            orderBy = orderByFields.toString();
        }
        catch (Exception e) {
            orderBy = "sortnumber,number";
            log.error("\u83b7\u53d6\u4eba\u5458\u5217\u8868\u6392\u5e8f\u5b57\u6bb5\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
        this.getPageCache().put(CACHE_ORDER_BY, orderBy);
        return orderBy;
    }

    private String getFullFieldName(MainEntityType dataEntityType, String listFieldId) {
        FilterField filterField = FilterField.create((MainEntityType)dataEntityType, (String)listFieldId);
        return filterField.getFullFieldName();
    }

    private String getSubFullName(String fullName, Boolean isSubFullName) {
        if (!isSubFullName.booleanValue() || fullName == null) {
            return fullName;
        }
        String[] names = fullName.split("_");
        if (names.length < 3) {
            return fullName;
        }
        return names[names.length - 2] + "_" + names[names.length - 1];
    }

    private UserF7PageConfig getUserF7Config() {
        Map<String, Object> config = this.getConfig();
        UserF7PageConfig userF7PageConfig = new UserF7PageConfig();
        userF7PageConfig.setIsMulti((Boolean)config.get("isMulti"));
        userF7PageConfig.setMustInput((Boolean)config.get("mustInput"));
        userF7PageConfig.setSelected((Collection)config.get("selected"));
        return userF7PageConfig;
    }

    @Override
    protected Object convertSelected(List<Long> selectedIds) {
        QFilter filter = new QFilter("id", "in", selectedIds);
        return this.query(filter, false);
    }

    @Override
    protected void beforeDndSelectClosed(ListSelectedRowCollection selectedRows) {
        this.updateFavoriteSetting(selectedRows);
    }

    private void updateFavoriteSetting(ListSelectedRowCollection selectedRows) {
        if (selectedRows.isEmpty()) {
            return;
        }
        ArrayList<String> selectedUserIds = new ArrayList<String>();
        for (ListSelectedRow selectedRow : selectedRows) {
            selectedUserIds.add(selectedRow.getPrimaryKeyValue().toString());
        }
        this.getAndSetFavoriteSetting(selectedUserIds);
    }

    private List<UserDTO> getAndSetFavoriteSetting(List<String> selectedUserIds) {
        JSONObject userListJson;
        String key;
        long userId = RequestContext.get().getCurrUserId();
        String commonlyUserCache = UserConfigServiceHelper.getSetting((long)userId, (String)(key = this.getSettingKey()));
        JSONObject settingJson = StringUtils.isEmpty((CharSequence)commonlyUserCache) ? new JSONObject() : JSON.parseObject((String)commonlyUserCache);
        JSONObject userUIStateJson = settingJson.getJSONObject(KEY_SETTING_STATE);
        if (null == userUIStateJson) {
            userUIStateJson = new JSONObject();
            settingJson.put(KEY_SETTING_STATE, (Object)userUIStateJson);
        }
        if (null == (userListJson = userUIStateJson.getJSONObject(KEY_SETTING_USER))) {
            userListJson = new JSONObject();
            userUIStateJson.put(KEY_SETTING_USER, (Object)userListJson);
        }
        String contacts = userListJson.getString(KEY_SETTING_COMMONLY);
        List<UserDTO> userDTOList = new ArrayList<UserDTO>();
        if (StringUtils.isNotBlank((CharSequence)contacts)) {
            userDTOList = JSON.parseArray((String)contacts, UserDTO.class);
        }
        if (selectedUserIds != null && !selectedUserIds.isEmpty()) {
            HashMap<String, Object> commonlyMap;
            ArrayList newSettingUsers = new ArrayList(userDTOList.size());
            for (UserDTO userDTO : userDTOList) {
                if (selectedUserIds.remove(userDTO.getId())) {
                    userDTO.setFrequency(userDTO.getFrequency() + 1);
                }
                commonlyMap = new HashMap<String, Object>(2);
                commonlyMap.put("id", userDTO.getId());
                commonlyMap.put(KEY_COMMONLY_USER_FREQUENCY, userDTO.getFrequency());
                newSettingUsers.add(commonlyMap);
            }
            for (String addUserId : selectedUserIds) {
                commonlyMap = new HashMap(2);
                commonlyMap.put("id", addUserId);
                commonlyMap.put(KEY_COMMONLY_USER_FREQUENCY, 1);
                newSettingUsers.add(commonlyMap);
            }
            userListJson.put(KEY_SETTING_COMMONLY, newSettingUsers);
            UserConfigServiceHelper.setSetting((long)userId, (String)key, (String)settingJson.toJSONString());
        }
        return userDTOList;
    }

    private String getSettingKey() {
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (StringUtils.isNotBlank((CharSequence)parentFormId)) {
            return parentFormId + ".FormSetting";
        }
        return this.getView().getFormShowParameter().getSettingKey();
    }

    @Override
    protected String getDataListKey() {
        return USER_LIST;
    }

    @Override
    protected String getBizExtCaseNumber() {
        return "kd.bos.base.mobile.AbstractUserMobileExtendHandler";
    }
}

