/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.upgrade;

import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.service.upgrade.PatchService;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class PatchPlugin
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnupgrade"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase(Locale.ENGLISH);
        if ("btnupgrade".equals(key)) {
            this.setupPatch();
        }
    }

    private boolean setupPatch() {
        IDataModel model = this.getModel();
        String ptno = String.valueOf(model.getValue("ptnum"));
        if (!StringUtils.isEmpty((String)ptno)) {
            String msg = "";
            try {
                PatchService ptMS = (PatchService)ServiceFactory.getService(PatchService.class);
                String ptResult = ptMS.setupPatch(ptno);
                Map result = (Map)JSONUtils.cast((String)ptResult, HashMap.class);
                msg = String.valueOf(result.get("desc"));
            }
            catch (IOException e) {
                msg = e.toString();
            }
            this.getView().showMessage(msg);
        }
        return true;
    }
}

