/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.common;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;

public class DevportalCache {
    private static final String DEVPORTAL_PER_LOCK = "devportal_per_lock";
    private static final String DEVPORTAL_PERMISSION = "devportal_permission";
    private static final String DEVPORTAL_LOCK = "devportal_lock";
    private static final String DEVPORTAL_LOCK_ALL = "devportal_lock_all";
    private static final String DEVPORTAL_ENV_REGION = "devportal_envRegion";
    private static final String PERMISSION = "permission";
    private static final String LOCK = "lock";
    private static final String LOCK_ALL = "lock_all";
    private static final String ENV_REGION = "envRegion";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("devportal_per_lock", new DistributeCacheHAPolicy());

    private DevportalCache() {
    }

    public static void putPermission(String value, Long userId, String mode) {
        String permissionCacheKey = DevportalCache.getPermissionCacheKey(mode);
        String cacheKey = DevportalCache.getCacheKey(userId);
        cache.put(permissionCacheKey, cacheKey, value, 18000);
    }

    public static void putPermissionByUser(String value, Long userId) {
        String permissionUserKey = DevportalCache.getPermissionUserKey();
        String cacheKey = DevportalCache.getCacheKey(userId);
        cache.put(permissionUserKey, cacheKey, value, 18000);
    }

    public static void putLock(String number, String userName) {
        DevportalCache.putLock(number, userName, null, false);
    }

    public static void putLock(String value) {
        DevportalCache.putLock(null, null, value, true);
    }

    public static void putLock(String number, String userName, String value, boolean isQueryAll) {
        String lockCacheKey = DevportalCache.getLockCacheKey();
        if (isQueryAll) {
            String cacheKey = DevportalCache.getCacheKey();
            cache.put(lockCacheKey, cacheKey, value, 18000);
        } else {
            String cacheKey = DevportalCache.getCacheKey(number);
            cache.put(lockCacheKey, cacheKey, userName, 18000);
        }
    }

    public static String getPermission(Long userId, String mode) {
        String permissionCacheKey = DevportalCache.getPermissionCacheKey(mode);
        String cacheKey = DevportalCache.getCacheKey(userId);
        return (String)cache.get(permissionCacheKey, cacheKey);
    }

    public static String getPermissionUser(Long userId) {
        String permissionUserKey = DevportalCache.getPermissionUserKey();
        String cacheKey = DevportalCache.getCacheKey(userId);
        return (String)cache.get(permissionUserKey, cacheKey);
    }

    public static String getLock(boolean isQueryAll) {
        return DevportalCache.getLock(null, isQueryAll);
    }

    public static String getLock(String number, boolean isQueryAll) {
        String lockCacheKey = DevportalCache.getLockCacheKey();
        String cacheKey = null;
        cacheKey = isQueryAll ? DevportalCache.getCacheKey() : DevportalCache.getCacheKey(number);
        return (String)cache.get(lockCacheKey, cacheKey);
    }

    public static void clearPermission(Long userId, String mode) {
        String permissionCacheKey = DevportalCache.getPermissionCacheKey(mode);
        String cacheKey = DevportalCache.getCacheKey(userId);
        cache.remove(permissionCacheKey, cacheKey);
    }

    public static void clearPermissionUser(Long userId) {
        String permissionUserKey = DevportalCache.getPermissionUserKey();
        String cacheKey = DevportalCache.getCacheKey(userId);
        cache.remove(permissionUserKey, cacheKey);
    }

    public static void clearLock(boolean isQueryAll) {
        DevportalCache.clearLock(null, isQueryAll);
    }

    public static void clearLock(String number, boolean isQueryAll) {
        String lockCacheKey = DevportalCache.getLockCacheKey();
        String cacheKey = null;
        cacheKey = isQueryAll ? DevportalCache.getCacheKey() : DevportalCache.getCacheKey(number);
        cache.remove(lockCacheKey, cacheKey);
    }

    public static String getEnvRegion() {
        String cacheKey = DevportalCache.getCacheKey(ENV_REGION, null, null);
        String envRegion = (String)DevportalCache.getLocalCache().get(cacheKey);
        if (StringUtils.isBlank((CharSequence)envRegion) && (envRegion = (String)cache.get(cacheKey)) != null) {
            DevportalCache.getLocalCache().put(cacheKey, (Object)envRegion);
        }
        return envRegion;
    }

    private static LocalMemoryCache getLocalCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(86400);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), DEVPORTAL_ENV_REGION, info);
    }

    public static void cacheEnvRegion(String envRegion) {
        String cacheKey = DevportalCache.getCacheKey(ENV_REGION, null, null);
        cache.put(cacheKey, (Object)envRegion, 3600);
        DevportalCache.getLocalCache().put(cacheKey, (Object)envRegion);
    }

    public static void clearEnvRegion() {
        String cacheKey = DevportalCache.getCacheKey(ENV_REGION, null, null);
        cache.remove(cacheKey);
        DevportalCache.getLocalCache().remove(new String[]{cacheKey});
    }

    private static String getPermissionUserKey() {
        String acctId = CacheKeyUtil.getAcctId();
        return String.format("%s_%s", acctId, DEVPORTAL_PERMISSION);
    }

    private static String getPermissionCacheKey(String mode) {
        String acctId = CacheKeyUtil.getAcctId();
        return String.format("%s_%s_%s", acctId, DEVPORTAL_PERMISSION, mode);
    }

    private static String getCacheKey() {
        return DevportalCache.getCacheKey(LOCK_ALL, null, null);
    }

    private static String getCacheKey(Long userId) {
        return DevportalCache.getCacheKey(PERMISSION, userId, null);
    }

    private static String getCacheKey(String number) {
        return DevportalCache.getCacheKey(LOCK, null, number);
    }

    private static String getCacheKey(String type, Long userId, String number) {
        String key = null;
        switch (type) {
            case "permission": {
                key = String.format("%s_%s", DEVPORTAL_PERMISSION, userId);
                break;
            }
            case "lock": {
                key = String.format("%s_%s", DEVPORTAL_LOCK, number);
                break;
            }
            case "lock_all": {
                key = String.format("%s", DEVPORTAL_LOCK_ALL);
                break;
            }
            case "envRegion": {
                String accountId = RequestContext.get().getAccountId();
                key = String.format("%s_%s", DEVPORTAL_ENV_REGION, accountId);
                break;
            }
        }
        return key;
    }

    private static String getLockCacheKey() {
        String acctId = CacheKeyUtil.getAcctId();
        return String.format("%s_%s", acctId, DEVPORTAL_LOCK);
    }
}

