/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.common.hosting;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.hosting.SVNFileInfo;
import kd.bos.exception.KDBizException;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnCat;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNCommonUtil {
    public static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    public static SVNClientManager authSvn(String svnRoot, String username, String password) {
        SVNCommonUtil.setupLibrary();
        SVNRepository repository = null;
        SVNClientManager clientManager = null;
        try {
            repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)svnRoot));
            char[] pwd = password.toCharArray();
            ISVNAuthenticationManager authenticationManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (char[])pwd);
            repository.setAuthenticationManager(authenticationManager);
            DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
            clientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authenticationManager);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
        return clientManager;
    }

    public static SVNCommitInfo makeDirectory(SVNClientManager clientManager, SVNURL url, String commitMessage) throws SVNException {
        return clientManager.getCommitClient().doMkDir(new SVNURL[]{url}, commitMessage);
    }

    public static SVNCommitInfo importDirectory(SVNClientManager clientManager, File localPath, SVNURL dstURL, String commitMessage, boolean isRecursive) throws SVNException {
        return clientManager.getCommitClient().doImport(localPath, dstURL, commitMessage, null, true, true, SVNDepth.fromRecurse((boolean)isRecursive));
    }

    public static void addEntry(SVNClientManager clientManager, File wcPath) {
        try {
            clientManager.getWCClient().doAdd(new File[]{wcPath}, true, false, false, SVNDepth.INFINITY, false, false, true);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void addEntry(SVNClientManager clientManager, File[] files) {
        try {
            clientManager.getWCClient().doAdd(files, true, false, false, SVNDepth.INFINITY, false, false, true);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static SVNStatus showStatus(SVNClientManager clientManager, File wcPath, boolean remote) {
        SVNStatus status = null;
        try {
            status = clientManager.getStatusClient().doStatus(wcPath, remote);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
        return status;
    }

    public static SVNCommitInfo commit(SVNClientManager clientManager, File wcPath, boolean keepLocks, String commitMessage) {
        try {
            if (StringUtils.isBlank((CharSequence)commitMessage)) {
                commitMessage = null;
            }
            return clientManager.getCommitClient().doCommit(new File[]{wcPath}, keepLocks, commitMessage, null, null, false, false, SVNDepth.INFINITY);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static SVNCommitInfo commitSelectedMetadata(SVNClientManager clientManager, File[] files, String commitMessage) throws SVNException {
        clientManager.getWCClient().doAdd(files, true, false, false, SVNDepth.INFINITY, false, true, true);
        return clientManager.getCommitClient().doCommit(files, true, commitMessage, null, null, false, false, SVNDepth.INFINITY);
    }

    public static long update(SVNClientManager clientManager, File wcPath, SVNRevision updateToRevision, SVNDepth depth) {
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        try {
            return updateClient.doUpdate(wcPath, updateToRevision, depth, false, false);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static long[] update(SVNClientManager clientManager, File[] files, SVNRevision updateToRevision, SVNDepth depth, boolean allowUnversionedObstructions) {
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        try {
            return updateClient.doUpdate(files, updateToRevision, depth, allowUnversionedObstructions, false);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static long checkout(SVNClientManager clientManager, SVNURL url, SVNRevision revision, File destPath, SVNDepth depth) {
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        try {
            return updateClient.doCheckout(url, destPath, revision, revision, depth, false);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static long checkout(SVNClientManager clientManager, SVNURL url, SVNRevision revision, File destPath, SVNDepth depth, boolean allowUnversionedObstructions) {
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        try {
            return updateClient.doCheckout(url, destPath, revision, revision, depth, allowUnversionedObstructions);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static boolean isWorkingCopy(File path) {
        if (!path.exists()) {
            return false;
        }
        try {
            if (null == SVNWCUtil.getWorkingCopyRoot((File)path, (boolean)false)) {
                return false;
            }
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
        return true;
    }

    public static boolean isURLExist(SVNURL url, String username, String password) {
        SVNCommonUtil.setupLibrary();
        try {
            SVNRepository svnRepository = SVNRepositoryFactory.create((SVNURL)url);
            char[] pwd = password.toCharArray();
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (char[])pwd);
            svnRepository.setAuthenticationManager(authManager);
            SVNNodeKind nodeKind = svnRepository.checkPath("", -1L);
            return nodeKind != SVNNodeKind.NONE;
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void checkSVNAuthentication(String url, String username, String password) {
        SVNCommonUtil.setupLibrary();
        try {
            SVNURL srcURL = SVNURL.parseURIEncoded((String)url);
            SVNRepository svnRepository = SVNRepositoryFactory.create((SVNURL)srcURL);
            char[] pwd = password.toCharArray();
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (char[])pwd);
            svnRepository.setAuthenticationManager(authManager);
            SVNNodeKind sVNNodeKind = svnRepository.checkPath("", -1L);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void doUnLock(SVNClientManager clientManager, File ... workingCopy) {
        SVNWCClient client = clientManager.getWCClient();
        try {
            client.doUnlock(workingCopy, false);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void doUnLock(SVNClientManager clientManager, SVNURL[] urls, boolean stealLock) {
        SVNWCClient client = clientManager.getWCClient();
        try {
            client.doUnlock(urls, stealLock);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void lockWk(SVNClientManager clientManager, String lockMessage, File ... workingCopy) {
        SVNWCClient client = clientManager.getWCClient();
        try {
            client.doLock(workingCopy, true, lockMessage);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void lockSvn(SVNClientManager clientManager, SVNURL[] urls, boolean stealLock, String lockMessage) {
        SVNWCClient client = clientManager.getWCClient();
        try {
            client.doLock(urls, stealLock, lockMessage);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void deleteWK(SVNClientManager clientManager, File workingCopy, boolean deleteFiles) {
        SVNWCClient client = clientManager.getWCClient();
        try {
            client.doDelete(workingCopy, true, deleteFiles, false);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static SVNCommitInfo deleteSVN(SVNClientManager clientManager, SVNURL[] deleteUrls, String deleteMessage) {
        SVNCommitClient commitClient = clientManager.getCommitClient();
        try {
            return commitClient.doDelete(deleteUrls, deleteMessage);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void revert(SVNClientManager clientManager, File ... workingCopy) {
        SVNWCClient client = clientManager.getWCClient();
        try {
            client.doRevert(workingCopy, SVNDepth.INFINITY, null);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void cleanUp(SVNClientManager clientManager, File workingCopy) {
        SVNWCClient client = clientManager.getWCClient();
        try {
            client.doCleanup(workingCopy);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static SVNCommitInfo doMove(SVNClientManager clientManager, SVNCopySource[] copySources, SVNURL dirUrl) {
        SVNCopyClient copyClient = clientManager.getCopyClient();
        try {
            return copyClient.doCopy(copySources, dirUrl, true, false, false, "move", null);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static SVNInfo doInfo(SVNClientManager clientManager, File file) {
        SVNWCClient client = clientManager.getWCClient();
        try {
            return client.doInfo(file, SVNRevision.HEAD);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static SVNInfo doInfo(SVNClientManager clientManager, SVNURL url) {
        SVNWCClient client = clientManager.getWCClient();
        try {
            return client.doInfo(url, SVNRevision.HEAD, SVNRevision.HEAD);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static long doLog(SVNClientManager clientManager, String userName, String passWord, String url, String[] paths, ISVNLogEntryHandler handler) {
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        try {
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)url));
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)userName, (String)passWord);
            repository.setAuthenticationManager(authManager);
            return repository.log(paths, 0L, -1L, true, true, handler);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void doGetFileContent(SVNClientManager clientManager, SVNRevision revision, String svnuri, OutputStream output) {
        SVNWCClient client = clientManager.getWCClient();
        try {
            SvnCat cat = client.getOperationsFactory().createCat();
            if (revision == null) {
                revision = SVNRevision.HEAD;
            }
            SVNURL uri = SVNURL.parseURIEncoded((String)svnuri);
            cat.setSingleTarget(SvnTarget.fromURL((SVNURL)uri));
            cat.setRevision(revision);
            cat.setOutput(output);
            cat.run();
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void doDiff(SVNClientManager clientManager, File compFile, BufferedOutputStream result) {
        SVNWCClient client = clientManager.getWCClient();
        try {
            SVNDiffClient diff = clientManager.getDiffClient();
            diff.doDiff(compFile, SVNRevision.HEAD, SVNRevision.WORKING, SVNRevision.HEAD, SVNDepth.INFINITY, true, (OutputStream)result, null);
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static List<SVNFileInfo> listSvnFile(SVNURL SVNUrl, String userName, String passWord) {
        SVNCommonUtil.setupLibrary();
        List<SVNFileInfo> listDir = null;
        try {
            SVNRepository svnRepository = SVNRepositoryFactory.create((SVNURL)SVNUrl);
            char[] pwd = passWord.toCharArray();
            ISVNAuthenticationManager authenticationManager = SVNWCUtil.createDefaultAuthenticationManager((String)userName, (char[])pwd);
            svnRepository.setAuthenticationManager(authenticationManager);
            String checkUrl = "";
            long revisionNum = -1L;
            SVNNodeKind svnNodeKind = svnRepository.checkPath(checkUrl, revisionNum);
            if (svnNodeKind == SVNNodeKind.DIR) {
                listDir = SVNCommonUtil.listEntries(svnRepository, checkUrl);
            }
        }
        catch (SVNException e) {
            throw new KDBizException(e.getMessage());
        }
        return listDir;
    }

    private static List<SVNFileInfo> listEntries(SVNRepository svnRepository, String path) throws SVNException {
        Collection entry = svnRepository.getDir(path, -1L, null, (Collection)null);
        Iterator iterator = entry.iterator();
        ArrayList<SVNFileInfo> listSVNfileInfo = new ArrayList<SVNFileInfo>(entry.size());
        while (iterator.hasNext()) {
            SVNFileInfo svnFileInfo = new SVNFileInfo();
            SVNDirEntry svnDirEntry = (SVNDirEntry)iterator.next();
            svnFileInfo.setFileName(svnDirEntry.getName());
            svnFileInfo.setAuthor(svnDirEntry.getAuthor());
            svnFileInfo.setVersion(svnDirEntry.getRevision());
            svnFileInfo.setVersionDate(svnDirEntry.getDate());
            listSVNfileInfo.add(svnFileInfo);
        }
        return listSVNfileInfo;
    }
}

