/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.common.hosting;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNUtil {
    private static final String SVNPATH = "svnpath";
    private static final String LOCALPATH = "localpath";
    private static final String P = "password";
    private static final String N = "username";
    private static final String REPOSITORY_KEY = "repository";
    private static final String ERROR = "ERROR";
    private static final String BOS_DEVPORTAL_COMMON = "bos-devportal-common";
    private static SVNClientManager clientManager;
    private static SVNUpdateClient updateClient;
    private static SVNCommitClient commitClient;
    private static SVNURL repositoryURL;
    private static SVNRepository repository;
    private static ISVNAuthenticationManager authManager;
    public static final String PROPERTY;

    public static SVNClientManager getClientManager() {
        return clientManager;
    }

    public static void setClientManager(SVNClientManager clientManager) {
        SVNUtil.clientManager = clientManager;
    }

    public static SVNCommitClient getCommitClient() {
        return commitClient;
    }

    public static void setCommitClient(SVNCommitClient commitClient) {
        SVNUtil.commitClient = commitClient;
    }

    public static SVNURL getRepositoryURL() {
        return repositoryURL;
    }

    public static void setRepositoryURL(SVNURL repositoryURL) {
        SVNUtil.repositoryURL = repositoryURL;
    }

    public static SVNRepository getRepository() {
        return repository;
    }

    public static void setRepository(SVNRepository repository) {
        SVNUtil.repository = repository;
    }

    public static JSONObject getSVNMsgByAppId(String bizAppId) {
        JSONObject svnMsg = new JSONObject();
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String svnpath = AppUtils.getSVNPathByAppId(bizAppId);
        if (StringUtils.isBlank((CharSequence)svnpath)) {
            svnMsg.put(ERROR, (Object)ResManager.loadKDString((String)"\u7b7e\u5165SVN\u5730\u5740\u4e3a\u7a7a\uff01\u8bf7\u5728svn\u7ba1\u7406\u4e2d\u4fdd\u5b58SVN\u8def\u5f84", (String)"622135553852178432", (SubSystemType)SubSystemType.SL, (Object[])new Object[0]));
            return svnMsg;
        }
        String number = appMeta.getNumber();
        svnMsg.put(SVNPATH, (Object)svnpath);
        String localPath = PROPERTY + File.separator + "metadata" + File.separator + number;
        svnMsg.put(LOCALPATH, (Object)localPath);
        return svnMsg;
    }

    public static JSONObject getSVNMsgByAppId(String bizAppId, String metadataId) {
        JSONObject svnMsg = new JSONObject();
        AppMetadata appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        String svnpath = AppUtils.getSVNPathByAppId(bizAppId, metadataId);
        if (StringUtils.isBlank((CharSequence)svnpath)) {
            svnMsg.put(ERROR, (Object)ResManager.loadKDString((String)"\u7b7e\u5165SVN\u5730\u5740\u4e3a\u7a7a\uff01\u8bf7\u5728svn\u7ba1\u7406\u4e2d\u4fdd\u5b58SVN\u8def\u5f84", (String)"622135553852178432", (SubSystemType)SubSystemType.SL, (Object[])new Object[0]));
            return svnMsg;
        }
        String number = appMeta.getNumber();
        svnMsg.put(SVNPATH, (Object)svnpath);
        String localPath = PROPERTY + File.separator + "metadata" + File.separator + number;
        svnMsg.put(LOCALPATH, (Object)localPath);
        return svnMsg;
    }

    public static JSONObject checkOutFiles(JSONObject svnMsg) {
        String svnPath = svnMsg.getString(SVNPATH);
        String localPath = svnMsg.getString(LOCALPATH);
        Map<String, String> folderMap = SVNUtil.getFolderMap(svnPath, localPath);
        for (Map.Entry<String, String> entry : folderMap.entrySet()) {
            String fileName = entry.getKey();
            svnMsg = SVNUtil.getClientManager(folderMap.get(fileName), svnMsg);
            if (StringUtils.isNotBlank((Object)svnMsg.get((Object)ERROR)) || StringUtils.isNotBlank((Object)svnMsg.get((Object)"NOPATH"))) {
                return svnMsg;
            }
            svnMsg = SVNUtil.checkRootFolder(fileName, folderMap.get(fileName), clientManager, svnMsg);
            if (!StringUtils.isNotBlank((Object)svnMsg.get((Object)ERROR))) continue;
            return svnMsg;
        }
        return svnMsg;
    }

    public static Map<String, String> getFolderMap(String svnPath, String localPath) {
        HashMap<String, String> folderMap = new HashMap<String, String>();
        folderMap.put(localPath + "/dbschema", svnPath + "/dbschema");
        folderMap.put(localPath + "/metadata", svnPath + "/metadata");
        folderMap.put(localPath + "/preinsdata", svnPath + "/preinsdata");
        return folderMap;
    }

    public static JSONObject getClientManager(String svnPath, JSONObject svnMsg) {
        SVNUtil.setupLibrary();
        try {
            String password = svnMsg.get((Object)P).toString();
            password = Encrypters.decode((String)password);
            SVNURL url = SVNURL.parseURIEncoded((String)svnPath);
            repository = SVNRepositoryFactory.create((SVNURL)url);
            authManager = new BasicAuthenticationManager(new SVNAuthentication[]{new SVNPasswordAuthentication(svnMsg.get((Object)N).toString(), password, false, url, false)});
            repository.setAuthenticationManager(authManager);
            SVNNodeKind nodeKind = repository.checkPath("", -1L);
            if (nodeKind == SVNNodeKind.NONE) {
                svnMsg.put("NOPATH", (Object)ResManager.loadKDString((String)"SVN\u8def\u5f84\u4e0d\u5b58\u5728\uff01", (String)"622135555689284608", (SubSystemType)SubSystemType.SL, (Object[])new Object[0]));
                return svnMsg;
            }
        }
        catch (Exception e) {
            svnMsg.put(ERROR, (Object)e.getMessage());
            return svnMsg;
        }
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        clientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
        commitClient = clientManager.getCommitClient();
        svnMsg.put("clientManager", (Object)clientManager);
        svnMsg.put("commitClient", (Object)commitClient);
        svnMsg.put(REPOSITORY_KEY, (Object)repository);
        return svnMsg;
    }

    public static void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    public static JSONObject checkRootFolder(String filePath, String svnPath, SVNClientManager clientManager, JSONObject svnMsg) {
        String checkFilePath = AppUtils.checkFilePath(filePath);
        File checkOutFile = new File(checkFilePath);
        try {
            Boolean flag = SVNWCUtil.isWorkingCopyRoot((File)checkOutFile);
            if (!flag.booleanValue()) {
                if (StringUtils.isNotBlank((Object)(svnMsg = SVNUtil.checkedOut(checkOutFile, svnPath, clientManager, svnMsg)).get((Object)ERROR))) {
                    return svnMsg;
                }
                flag = SVNWCUtil.isWorkingCopyRoot((File)checkOutFile);
                if (!flag.booleanValue()) {
                    svnMsg.put(ERROR, (Object)String.format(ResManager.loadKDString((String)"\u76ee\u5f55\u4e0d\u662fsvn\u7ba1\u7406\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5:%s", (String)"622135557518000128", (SubSystemType)SubSystemType.SL, (Object[])new Object[0]), checkOutFile));
                    return svnMsg;
                }
            }
            clientManager.getUpdateClient().doUpdate(checkOutFile, SVNRevision.HEAD, false);
        }
        catch (SVNException e) {
            try {
                clientManager.getWCClient().doCleanup(checkOutFile);
                clientManager.getUpdateClient().doUpdate(checkOutFile, SVNRevision.HEAD, false);
                clientManager.getWCClient().doRevert(checkOutFile, false);
                clientManager.getWCClient().doResolve(checkOutFile, false);
            }
            catch (SVNException svnException) {
                svnMsg.put(ERROR, (Object)String.format(ResManager.loadKDString((String)"\u66f4\u65b0svn\u51fa\u9519\uff01\u5230\u672c\u5730%s\u8def\u5f84\u5220\u9664\u8be5\u6587\u4ef6\u5939\u540e\u518d\u7b7e\u5165", (String)"622135559329940480", (SubSystemType)SubSystemType.SL, (Object[])new Object[0]), checkOutFile));
                return svnMsg;
            }
        }
        return svnMsg;
    }

    public static JSONObject checkedOut(File checkOutFile, String svnPath, SVNClientManager clientManager, JSONObject checkoutMsg) {
        try {
            SVNUpdateClient updateClient = clientManager.getUpdateClient();
            updateClient.setIgnoreExternals(false);
            SVNURL url = SVNURL.parseURIEncoded((String)svnPath);
            updateClient.doCheckout(url, checkOutFile, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, false);
        }
        catch (SVNException e) {
            checkoutMsg.put(ERROR, (Object)e.getMessage());
            return checkoutMsg;
        }
        return checkoutMsg;
    }

    public static JSONObject commitToSVN(List<String> fileList, JSONObject svnMsg) {
        ArrayList<File> files = new ArrayList<File>(fileList.size());
        for (String url : fileList) {
            String checkUrl = AppUtils.checkFilePath(url);
            File file = new File(checkUrl);
            files.add(file);
        }
        String localPath = svnMsg.getString(LOCALPATH);
        String svnMessage = svnMsg.getString("annotation");
        File[] filetocommit = files.toArray(new File[0]);
        SVNUtil.commit(clientManager, filetocommit, svnMsg, localPath, svnMessage);
        return svnMsg;
    }

    public static JSONObject commit(SVNClientManager clientManager, File[] files, JSONObject commitSVNMsg, String localPath, String svnMessage) {
        try {
            clientManager.getWCClient().doAdd(files, true, false, false, SVNDepth.INFINITY, false, true, true);
            SVNCommitInfo info = clientManager.getCommitClient().doCommit(files, true, svnMessage, null, null, false, false, SVNDepth.INFINITY);
            if (info.equals(SVNCommitInfo.NULL)) {
                commitSVNMsg.put("CONFLICT", (Object)ResManager.loadKDString((String)"\u5143\u6570\u636e\u65e0\u53d8\u5316,\u4e0d\u9700\u8981\u63d0\u4ea4\uff01", (String)"622135561208987648", (SubSystemType)SubSystemType.SL, (Object[])new Object[0]));
                return commitSVNMsg;
            }
        }
        catch (SVNException e) {
            String errMessage = e.getMessage();
            commitSVNMsg.put(ERROR, (Object)String.format(ResManager.loadKDString((String)"\u7b7e\u5165\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0\uff1a%s", (String)"SVNUtil_2", (String)BOS_DEVPORTAL_COMMON, (Object[])new Object[0]), errMessage));
            return commitSVNMsg;
        }
        catch (Exception e) {
            commitSVNMsg.put(ERROR, (Object)"commit fail");
        }
        return commitSVNMsg;
    }

    public static JSONObject authorize(JSONObject svnMsg) {
        String svnUsername = svnMsg.getString(N);
        String svnPassword = svnMsg.getString(P);
        String svnPath = svnMsg.getString(SVNPATH);
        try {
            svnPassword = Encrypters.decode((String)svnPassword);
            SVNUtil.setupLibrary();
            SVNURL url = SVNURL.parseURIEncoded((String)svnPath);
            repository = SVNRepositoryFactory.create((SVNURL)url);
            authManager = SVNWCUtil.createDefaultAuthenticationManager((String)svnUsername, (String)svnPassword);
            repository.setAuthenticationManager(authManager);
            SVNNodeKind nodeKind = repository.checkPath("", -1L);
            if (nodeKind == SVNNodeKind.NONE) {
                svnMsg.put(ERROR, (Object)ResManager.loadKDString((String)"SVN\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u521b\u5efaSVN\u8def\u5f84\uff01", (String)"622135564950306816", (SubSystemType)SubSystemType.SL, (Object[])new Object[0]));
                return svnMsg;
            }
            svnMsg.put(REPOSITORY_KEY, (Object)repository);
        }
        catch (Exception e) {
            svnMsg.put(ERROR, (Object)e.getMessage());
        }
        return svnMsg;
    }

    public static JSONObject doExport(String svnPath, String FileName, File filePath) {
        JSONObject msg = new JSONObject();
        try {
            DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
            clientManager = SVNClientManager.newInstance((DefaultSVNOptions)options, (String)"yifeng_liu", (String)"bk@2182674");
            updateClient = clientManager.getUpdateClient();
            updateClient.setIgnoreExternals(false);
            repositoryURL = SVNURL.parseURIEncoded((String)(svnPath + "/" + FileName));
            long l = updateClient.doExport(repositoryURL, filePath, SVNRevision.HEAD, SVNRevision.HEAD, "", true, SVNDepth.INFINITY);
        }
        catch (Exception e) {
            msg.put(ERROR, (Object)e.getMessage());
            return msg;
        }
        return msg;
    }

    public static JSONObject doExport(String svnPath, String fileName, File filePath, JSONObject msg) {
        try {
            boolean flag;
            if (fileName.endsWith("app") && StringUtils.isNotBlank((CharSequence)(msg = SVNUtil.authorize(msg)).getString(ERROR))) {
                return msg;
            }
            repository = (SVNRepository)msg.get((Object)REPOSITORY_KEY);
            DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
            clientManager = SVNClientManager.newInstance((DefaultSVNOptions)options, (String)msg.getString(N), (String)Encrypters.decode((String)msg.getString(P)));
            String exportFile = svnPath + "/" + fileName;
            if (fileName.endsWith("app") && !(flag = SVNUtil.checkSvnPath(exportFile, repository, msg))) {
                msg.put(ERROR, (Object)String.format(ResManager.loadKDString((String)"SVN\u7f3a\u5c11\u5f53\u524d%s\u5e94\u7528\u5143\u6570\u636e\uff01", (String)"SVNUtil_1", (String)BOS_DEVPORTAL_COMMON, (Object[])new Object[0]), exportFile));
                return msg;
            }
            updateClient = clientManager.getUpdateClient();
            updateClient.setIgnoreExternals(false);
            repositoryURL = SVNURL.parseURIEncoded((String)exportFile);
            updateClient.doExport(repositoryURL, filePath, SVNRevision.HEAD, SVNRevision.HEAD, "", true, SVNDepth.INFINITY);
        }
        catch (Exception e) {
            msg.put(ERROR, (Object)e.getMessage());
            return msg;
        }
        return msg;
    }

    public static Map<String, Object> getRepositoryAndCommitClient(JSONObject svnMsg) {
        String password = svnMsg.getString(P);
        String username = svnMsg.getString(N);
        String svnPath = svnMsg.getString(SVNPATH);
        HashMap<String, Object> map = new HashMap<String, Object>();
        SVNUtil.setupLibrary();
        SVNUtil.getClientManager(svnPath, svnMsg);
        clientManager.getCommitClient();
        commitClient.setIgnoreExternals(false);
        map.put("commitClient", commitClient);
        try {
            password = Encrypters.decode((String)password);
            repositoryURL = SVNURL.parseURIEncoded((String)svnPath);
            repository = SVNRepositoryFactory.create((SVNURL)repositoryURL);
            authManager = new BasicAuthenticationManager(new SVNAuthentication[]{new SVNPasswordAuthentication(username, password, false, repositoryURL, false)});
            repository.setAuthenticationManager(authManager);
            map.put(REPOSITORY_KEY, repository);
        }
        catch (Exception e) {
            svnMsg.put(ERROR, (Object)e.getMessage());
        }
        return map;
    }

    public static boolean checkSvnPath(String svnPath, SVNRepository repository) {
        String root = null;
        try {
            root = String.valueOf(repository.getRepositoryRoot(true));
        }
        catch (SVNException e) {
            return false;
        }
        if (root != null && svnPath != null && svnPath.split(root).length > 1) {
            String checkpath = svnPath.split(root)[1];
            try {
                SVNNodeKind nodeKind = repository.checkPath(checkpath, -1L);
                if (nodeKind == SVNNodeKind.FILE) {
                    return true;
                }
                if (nodeKind == SVNNodeKind.NONE) {
                    return false;
                }
            }
            catch (SVNException svnException) {
                return false;
            }
        }
        return false;
    }

    public static void checkSvnPath(String svnPath, SVNRepository repository, List<String> oldDoc, JSONObject checkInMsg) {
        String root = null;
        try {
            root = String.valueOf(repository.getRepositoryRoot(true));
        }
        catch (SVNException e) {
            checkInMsg.put(ERROR, (Object)e.getMessage());
        }
        if (root != null && svnPath != null && svnPath.split(root).length > 1) {
            String checkpath = svnPath.split(root)[1];
            try {
                SVNNodeKind nodeKind = repository.checkPath(checkpath, -1L);
                if (nodeKind == SVNNodeKind.FILE) {
                    oldDoc.add(svnPath);
                }
            }
            catch (SVNException svnException) {
                checkInMsg.put(ERROR, (Object)svnException.getMessage());
            }
        }
    }

    public static boolean checkSvnPath(String svnPath, SVNRepository repository, JSONObject checkInMsg) {
        String root = null;
        try {
            root = String.valueOf(repository.getRepositoryRoot(true));
        }
        catch (SVNException e) {
            checkInMsg.put(ERROR, (Object)e.getMessage());
        }
        SVNNodeKind nodeKind = null;
        if (root != null && svnPath != null && svnPath.split(root).length > 1) {
            String checkpath = svnPath.split(root)[1];
            try {
                nodeKind = repository.checkPath(checkpath, -1L);
            }
            catch (SVNException e) {
                checkInMsg.put(ERROR, (Object)e.getMessage());
            }
        }
        return nodeKind == SVNNodeKind.FILE;
    }

    public static JSONObject deleteSVN(JSONObject svnMsg, JSONArray forms) {
        String svnPath = svnMsg.getString(SVNPATH);
        if (StringUtils.isNotBlank((CharSequence)(svnMsg = SVNUtil.getClientManager(svnPath, svnMsg)).getString(ERROR))) {
            return svnMsg;
        }
        ArrayList<String> formUrls = new ArrayList<String>();
        for (int i = 0; i < forms.size(); ++i) {
            JSONObject formsObject = (JSONObject)forms.get(i);
            String formNumber = (String)formsObject.get((Object)"formnumber");
            List<String> list = AppUtils.getFilePaths(formNumber, svnPath);
            for (int j = 0; j < list.size(); ++j) {
                String svnUrl = list.get(j);
                SVNUtil.checkSvnPath(svnUrl, repository, formUrls, svnMsg);
                if (!StringUtils.isNotBlank((CharSequence)svnMsg.getString(ERROR))) continue;
                return svnMsg;
            }
        }
        if (formUrls.size() > 0) {
            SVNURL[] deleteUrls = new SVNURL[formUrls.size()];
            try {
                for (int i = 0; i < formUrls.size(); ++i) {
                    String deleteUrl = (String)formUrls.get(i);
                    deleteUrls[i] = SVNURL.parseURIEncoded((String)deleteUrl);
                }
                commitClient.doDelete(deleteUrls, svnMsg.getString("annotation"));
            }
            catch (SVNException e) {
                svnMsg.put(ERROR, (Object)e.getMessage());
                return svnMsg;
            }
        } else {
            svnMsg.put(ERROR, (Object)ResManager.loadKDString((String)"svn\u811a\u672c\u4e0d\u5b58\u5728\uff0c\u8bf7\u52ff\u52fe\u9009\uff01", (String)"622135570612617216", (SubSystemType)SubSystemType.SL, (Object[])new Object[0]));
            return svnMsg;
        }
        return svnMsg;
    }

    static {
        PROPERTY = System.getProperty("user.home");
    }
}

