/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.common.kingscript;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.kingscript.KingScriptPluginType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;

public class KingScriptType {
    public static final String OPERATE = "operate";
    public static final String REPORT_PLUGIN_EXT = "ReportPluginExt";
    public static final String REPORT_QUERY_PLUGIN = "ReportQueryPlugin";
    public static final String SCHEDULE_TASK = "ScheduleTask";
    public static final String BASE_DATA_CONTROLLER = "BaseDataController";
    public static final String IMPORT_DATA = "importData";
    public static final String EXPORT_ENTRY_PLUGIN = "exportEntryPlugin";
    public static final String IMPORT_ENTRY_TEMPLATE_PLUGIN = "importEntryTemplatePlugin";
    public static final String IMPORT_TEMPLATE_PLUGIN = "importTemplatePlugin";
    public static final String WRITE_BACK_PLUGIN = "writebackplugin";
    public static final String OPEN_API_PLUGIN = "openApiPlugin";
    public static final String WORKFLOW_PLUGIN = "workflow_plugin";
    private static final String PLUGIN = "plugin";
    private static final String IBillPlugin = "kd.bos.bill.IBillPlugin";
    private static final String IBasedataController = "kd.bos.base.IBasedataController";
    private static final String IConvertPlugIn = "kd.bos.entity.botp.plugin.IConvertPlugIn";
    private static final String IWriteBackPlugIn = "kd.bos.entity.botp.plugin.IWriteBackPlugIn";
    private static final String IImportDataPlugin = "kd.bos.entity.plugin.IImportDataPlugin";
    private static final String IOperationServicePlugIn = "kd.bos.entity.plugin.IOperationServicePlugIn";
    private static final String ImportTemplateListener = "kd.bos.entity.plugin.ImportTemplateListener";
    private static final String IReportListDataPlugin = "kd.bos.entity.report.IReportListDataPlugin";
    private static final String IReportListDataServiceExt = "kd.bos.entity.report.IReportListDataServiceExt";
    private static final String IExportEntryPlugin = "kd.bos.form.plugin.IExportEntryPlugin";
    private static final String IFormPlugin = "kd.bos.form.plugin.IFormPlugin";
    private static final String ImportEntryTemplateListener = "kd.bos.form.plugin.importentry.strategy.ImportEntryTemplateListener";
    private static final String IListPlugin = "kd.bos.list.plugin.IListPlugin";
    private static final String IPrintPlugin = "kd.bos.print.core.plugin.IPrintPlugin";
    private static final String IReportFormPlugin = "kd.bos.report.plugin.IReportFormPlugin";
    private static final String AbstractTask = "kd.bos.schedule.executor.AbstractTask";
    private static final String ApiQueryPlugin = "kd.bos.openapi.api.plugin.ApiQueryPlugin";
    private static final String ApiSavePlugin = "kd.bos.openapi.api.plugin.ApiSavePlugin";
    private static final String ApiSubmitPlugin = "kd.bos.openapi.api.plugin.ApiSubmitPlugin";
    private static final String ApiUnSubmitPlugin = "kd.bos.openapi.api.plugin.ApiUnSubmitPlugin";
    private static final String ApiAuditPlugin = "kd.bos.openapi.api.plugin.ApiAuditPlugin";
    private static final String ApiUnAuditPlugin = "kd.bos.openapi.api.plugin.ApiUnAuditPlugin";
    private static final String ApiDeletePlugin = "kd.bos.openapi.api.plugin.ApiDeletePlugin";
    private static final String ApiEnablePlugin = "kd.bos.openapi.api.plugin.ApiEnablePlugin";
    private static final String ApiDisablePlugin = "kd.bos.openapi.api.plugin.ApiDisablePlugin";
    private static final String ApiCommonPlugin = "kd.bos.openapi.api.plugin.ApiCommonPlugin";
    private static final String ApiSerializerPlugin = "kd.bos.openapi.api.plugin.ApiSerializerPlugin";
    private static final String ApiDeserializerPlugin = "kd.bos.openapi.api.plugin.ApiDeserializerPlugin";
    private static final String WORKFLOW_PLUGIN_CLASS = "kd.bos.workflow.engine.extitf.WorkflowPlugin";

    public static String getScriptType(IFormView view, String modelType, Function<IFormView, String> customHook) {
        String scriptTypeFilter = (String)view.getFormShowParameter().getCustomParams().get("scripttypefilter");
        if (OPERATE.equals(scriptTypeFilter)) {
            return KingScriptPluginType.OPERATE_PLUGIN.getValue();
        }
        if (REPORT_PLUGIN_EXT.equals(scriptTypeFilter)) {
            return KingScriptPluginType.REPORT_QUERY_EXT_PLUGIN.getValue();
        }
        if (REPORT_QUERY_PLUGIN.equals(scriptTypeFilter)) {
            return KingScriptPluginType.REPORT_QUERY_PLUGIN.getValue();
        }
        if (SCHEDULE_TASK.equals(scriptTypeFilter)) {
            return KingScriptPluginType.SCHEDULE_EXECUTOR.getValue();
        }
        if (BASE_DATA_CONTROLLER.equals(scriptTypeFilter)) {
            return KingScriptPluginType.BASE_DATA_CONTROLLER.getValue();
        }
        if (OPEN_API_PLUGIN.equals(scriptTypeFilter)) {
            return KingScriptPluginType.OPEN_API_PLUGIN.getValue();
        }
        if (EXPORT_ENTRY_PLUGIN.equals(scriptTypeFilter)) {
            return KingScriptPluginType.EXPORT_ENTRY_PLUGIN.getValue();
        }
        if (IMPORT_ENTRY_TEMPLATE_PLUGIN.equals(scriptTypeFilter)) {
            return KingScriptPluginType.IMPORT_ENTRY_TEMPLATE_PLUGIN.getValue();
        }
        if (IMPORT_TEMPLATE_PLUGIN.equals(scriptTypeFilter)) {
            return KingScriptPluginType.IMPORT_TEMPLATE_PLUGIN.getValue();
        }
        if (IMPORT_DATA.equals(scriptTypeFilter)) {
            return KingScriptPluginType.IMPORT_PLUGIN.getValue();
        }
        if (StringUtils.isBlank((CharSequence)modelType)) {
            return KingScriptPluginType.TOOL_SCRIPT.getValue();
        }
        if (WRITE_BACK_PLUGIN.equalsIgnoreCase(modelType)) {
            modelType = "WriteBackRuleModel";
        }
        String type = KingScriptPluginType.TOOL_SCRIPT.getValue();
        switch (modelType) {
            case "DynamicFormModel": 
            case "MobileFormModel": {
                type = KingScriptPluginType.FORM_PLUGIN.getValue();
                break;
            }
            case "BillFormModel": 
            case "BaseFormModel": {
                type = customHook.apply(view);
                break;
            }
            case "MobileBillFormModel": {
                type = KingScriptPluginType.BILL_PLUGIN.getValue();
                break;
            }
            case "MobileListModel": {
                type = KingScriptPluginType.LIST_PLUGIN.getValue();
                break;
            }
            case "ConvertRuleModel": {
                type = KingScriptPluginType.CONVERT_PLUGIN.getValue();
                break;
            }
            case "WriteBackRuleModel": {
                type = KingScriptPluginType.WRITE_BACK_PLUGIN.getValue();
                break;
            }
            case "PrintModel": {
                type = KingScriptPluginType.PRINT_PLUGIN.getValue();
                break;
            }
            case "ReportFormModel": {
                type = KingScriptPluginType.REPORT_FORM_PLUGIN.getValue();
                break;
            }
            case "WORKFLOW_PLUGIN_MODEL": {
                type = KingScriptPluginType.WORKFLOW_PLUGIN.getValue();
            }
        }
        return type;
    }

    public static String getScriptType(Map<String, Object> exports) {
        if (exports.get(PLUGIN) == null) {
            return KingScriptPluginType.TOOL_SCRIPT.getValue();
        }
        Class<?> clazz = exports.get(PLUGIN).getClass();
        if (KingScriptType.isAssignableFrom(clazz, IBillPlugin)) {
            return KingScriptPluginType.BILL_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, IListPlugin)) {
            return KingScriptPluginType.LIST_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, IOperationServicePlugIn)) {
            return KingScriptPluginType.OPERATE_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, IConvertPlugIn)) {
            return KingScriptPluginType.CONVERT_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, IWriteBackPlugIn)) {
            return KingScriptPluginType.WRITE_BACK_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, IPrintPlugin)) {
            return KingScriptPluginType.PRINT_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, IImportDataPlugin)) {
            return KingScriptPluginType.IMPORT_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, IExportEntryPlugin)) {
            return KingScriptPluginType.EXPORT_ENTRY_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, ImportEntryTemplateListener)) {
            return KingScriptPluginType.IMPORT_ENTRY_TEMPLATE_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, ImportTemplateListener)) {
            return KingScriptPluginType.IMPORT_TEMPLATE_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, IReportFormPlugin)) {
            return KingScriptPluginType.REPORT_FORM_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, IReportListDataServiceExt)) {
            return KingScriptPluginType.REPORT_QUERY_EXT_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, IReportListDataPlugin)) {
            return KingScriptPluginType.REPORT_QUERY_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, AbstractTask)) {
            return KingScriptPluginType.SCHEDULE_EXECUTOR.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, IBasedataController)) {
            return KingScriptPluginType.BASE_DATA_CONTROLLER.getValue();
        }
        if (KingScriptType.isOpenOpiInterface(clazz)) {
            return KingScriptPluginType.OPEN_API_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, IFormPlugin)) {
            return KingScriptPluginType.FORM_PLUGIN.getValue();
        }
        if (KingScriptType.isAssignableFrom(clazz, WORKFLOW_PLUGIN_CLASS)) {
            return KingScriptPluginType.WORKFLOW_PLUGIN.getValue();
        }
        return KingScriptPluginType.TOOL_SCRIPT.getValue();
    }

    public static boolean isKingScript(String scriptType, String scriptTypeFilter) {
        if (KingScriptPluginType.TOOL_SCRIPT.getValue().equals(scriptType)) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)scriptTypeFilter)) {
            return true;
        }
        if ("page".equals(scriptTypeFilter) && (KingScriptPluginType.FORM_PLUGIN.getValue().equals(scriptType) || KingScriptPluginType.BILL_PLUGIN.getValue().equals(scriptType) || KingScriptPluginType.LIST_PLUGIN.getValue().equals(scriptType) || KingScriptPluginType.REPORT_FORM_PLUGIN.getValue().equals(scriptType))) {
            return true;
        }
        if ("mobpage".equals(scriptTypeFilter) && ("9".equals(scriptType) || KingScriptPluginType.FORM_PLUGIN.getValue().equals(scriptType) || KingScriptPluginType.BILL_PLUGIN.getValue().equals(scriptType) || KingScriptPluginType.LIST_PLUGIN.getValue().equals(scriptType))) {
            return true;
        }
        if ("printpage".equals(scriptTypeFilter) && KingScriptPluginType.PRINT_PLUGIN.getValue().equals(scriptType)) {
            return true;
        }
        if (OPERATE.equals(scriptTypeFilter) && KingScriptPluginType.OPERATE_PLUGIN.getValue().equals(scriptType)) {
            return true;
        }
        if ("unittest".equals(scriptTypeFilter) && KingScriptPluginType.UNIT_TEST_PLUGIN.getValue().equals(scriptType)) {
            return true;
        }
        if ("webapi".equals(scriptTypeFilter) && "8".equals(scriptType)) {
            return true;
        }
        if ("convertplugin".equals(scriptTypeFilter) && KingScriptPluginType.CONVERT_PLUGIN.getValue().equals(scriptType)) {
            return true;
        }
        if (IMPORT_DATA.equals(scriptTypeFilter) && KingScriptPluginType.IMPORT_PLUGIN.getValue().equals(scriptType)) {
            return true;
        }
        if (EXPORT_ENTRY_PLUGIN.equals(scriptTypeFilter) && KingScriptPluginType.EXPORT_ENTRY_PLUGIN.getValue().equals(scriptType)) {
            return true;
        }
        if (IMPORT_ENTRY_TEMPLATE_PLUGIN.equals(scriptTypeFilter) && KingScriptPluginType.IMPORT_ENTRY_TEMPLATE_PLUGIN.getValue().equals(scriptType)) {
            return true;
        }
        if (IMPORT_TEMPLATE_PLUGIN.equals(scriptTypeFilter) && KingScriptPluginType.IMPORT_TEMPLATE_PLUGIN.getValue().equals(scriptType)) {
            return true;
        }
        if (WRITE_BACK_PLUGIN.equals(scriptTypeFilter) && KingScriptPluginType.WRITE_BACK_PLUGIN.getValue().equals(scriptType)) {
            return true;
        }
        if (REPORT_PLUGIN_EXT.equals(scriptTypeFilter) && KingScriptPluginType.REPORT_QUERY_EXT_PLUGIN.getValue().equals(scriptType)) {
            return true;
        }
        if (REPORT_QUERY_PLUGIN.equals(scriptTypeFilter) && KingScriptPluginType.REPORT_QUERY_PLUGIN.getValue().equals(scriptType)) {
            return true;
        }
        if (SCHEDULE_TASK.equals(scriptTypeFilter) && KingScriptPluginType.SCHEDULE_EXECUTOR.getValue().equals(scriptType)) {
            return true;
        }
        if (BASE_DATA_CONTROLLER.equals(scriptTypeFilter) && KingScriptPluginType.BASE_DATA_CONTROLLER.getValue().equals(scriptType)) {
            return true;
        }
        if (OPEN_API_PLUGIN.equals(scriptTypeFilter) && KingScriptPluginType.OPEN_API_PLUGIN.getValue().equals(scriptType)) {
            return true;
        }
        return WORKFLOW_PLUGIN.equals(scriptTypeFilter) && KingScriptPluginType.WORKFLOW_PLUGIN.getValue().equals(scriptType);
    }

    public static String getScriptNameByIndex(String value) {
        KingScriptPluginType type = KingScriptPluginType.fromValue(value);
        return type != null ? type.getDisplayName() : "";
    }

    private static String getBillScriptType(IPageCache pageCache) {
        String designerName = pageCache.get("designer");
        String type = "2";
        if (StringUtils.isNotBlank((CharSequence)designerName)) {
            switch (designerName) {
                case "MobListMeta": 
                case "ListMeta": {
                    type = "3";
                    break;
                }
                case "MobMeta": {
                    type = "2";
                }
            }
        }
        return type;
    }

    private static boolean isOpenOpiInterface(Class<?> clazz) {
        ArrayList<String> interfaceNames = new ArrayList<String>(10);
        interfaceNames.add(ApiQueryPlugin);
        interfaceNames.add(ApiSavePlugin);
        interfaceNames.add(ApiSubmitPlugin);
        interfaceNames.add(ApiUnSubmitPlugin);
        interfaceNames.add(ApiAuditPlugin);
        interfaceNames.add(ApiUnAuditPlugin);
        interfaceNames.add(ApiDeletePlugin);
        interfaceNames.add(ApiEnablePlugin);
        interfaceNames.add(ApiDisablePlugin);
        interfaceNames.add(ApiCommonPlugin);
        interfaceNames.add(ApiSerializerPlugin);
        interfaceNames.add(ApiDeserializerPlugin);
        return KingScriptType.isAssignableFrom(clazz, interfaceNames);
    }

    private static boolean isAssignableFrom(Class<?> clazz, List<String> interfaceNames) {
        for (String interfaceName : interfaceNames) {
            Class<?> interfaceClazz = null;
            try {
                interfaceClazz = Class.forName(interfaceName);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            if (!interfaceClazz.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableFrom(Class<?> clazz, String interfaceName) {
        try {
            Class<?> interfaceClazz = Class.forName(interfaceName);
            return interfaceClazz.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

