/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.devportal.common.hosting.SVNManagerUtil;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.devportal.AppElement;
import kd.bos.entity.devportal.AppFunctionPacketElement;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.isv.ISVService;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.util.FileUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class AppUtils {
    public static final Log logger = LogFactory.getLog(AppUtils.class);
    public static final String ERROR = "ERROR";
    public static final String NOPATH = "NOPATH";
    public static final String PAGE_WARN = "PAGE_WARN";
    public static final String CARD_WARN = "CARD_WARN";
    public static final String SCRIPT_WARN = "SCRIPT_WARN";
    public static final String DYM_WARN = "DYM_WARN";
    public static final String DYMX_WARN = "DYMX_WARN";
    public static final String SUCCESS = "SUCCESS";
    public static final String CONFLICT = "CONFLICT";
    public static final String EMPTY_COMMIT = "EMPTY COMMIT";
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String UPLOADPATH = "KINGDEEUPDATEDOWNLOAD";
    public static final String DOWNLOADPATH = "KINGDEEDOWNLOAD";
    public static final String APPPLUGIN = "APPPLUGIN";
    public static final String PAGEPLUGIN = "PAGEPLUGIN";
    private static final String DEV_DEVPORTAL_COMMON = "bos-devportal-common";
    public static final String ORITENENTISV = "kingdee";
    public static final String SCENE_DELETEAPP = "deleteapp";
    private static final String ORDERBY = "sequence asc";
    private static final String BIZAPPID = "bizappid";
    private static final String SVNURL = "svnurl";
    private static final int ONE_HUNDRED = 100;
    private static final String ISV_KINGDEE = "kingdee";
    private static final String IS_DELETE = "is delete";
    private static final String BOS_FOEMMETA = "bos_formmeta";
    private static final String NUMBER = "number";
    private static final String BIZAPP = "bizapp";
    private static final String BIZAPPNAME = "bizappname";
    private static final String BIZUNIT = "bizunit";
    private static final String BIZUNITID = "bizunitid";
    private static final String BIZUNITNAME = "bizunitname";
    private static final String MASTERID = "masterid";
    private static final String USERTYPE = "usetype";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String S = "success";
    private static final String MESSAGE = "message";
    private static final String USERESOURCE = "useresource";
    private static final String INDUSTRY = "industry";
    private static final String BIZCLOUD = "bizcloud";
    private static final String CLOUD = "cloud";
    private static final String ROOTNODE = "rootNode";
    public static final String NOCODE_CLOUD_ID = "2HGKCE94QELW";
    public static final String NOCODE_SYS_APP_ID = "2HGKTA7HH43C";
    private static final String DEFAUT_UUID_SVNDIFF = "d12ca300-34fc-4f55-a975-75f42d7b4ec6";

    public static String getNoPermissionTips() {
        return ResManager.loadKDString((String)"\u5f53\u524d\u5f00\u53d1\u5546\u6ca1\u6709\u8be5\u8d44\u6e90\u6743\u9650\u3002", (String)"AppUtils_0", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]);
    }

    public static String getSVNPathByAppId(String appId) {
        QFilter[] filters = new QFilter[]{new QFilter(BIZAPPID, "=", (Object)appId)};
        DynamicObject svnManage = BusinessDataServiceHelper.loadSingle((String)"svnmanage", (String)"id,svnserver,svnurl", (QFilter[])filters);
        if (svnManage != null) {
            String svnServer = svnManage.getString("svnserver");
            if ("customserver".equals(svnServer)) {
                return svnManage.getString(SVNURL);
            }
            if ("nextserver".equals(svnServer)) {
                String svnUrl = AppUtils.getSvnUrl();
                String path = svnManage.getString(SVNURL);
                if (StringUtils.isNotBlank((CharSequence)svnUrl) && StringUtils.isNotBlank((CharSequence)path)) {
                    return svnUrl + path;
                }
            }
        }
        return null;
    }

    public static String getSVNPathByAppId(String appId, String metadataId) {
        QFilter[] filters = new QFilter[]{new QFilter(BIZAPPID, "=", (Object)appId)};
        DynamicObject svnManage = BusinessDataServiceHelper.loadSingle((String)"svnmanage", (String)"id,svnserver,svnurl,mobilealone,mobilesvnurl", (QFilter[])filters);
        if (svnManage != null) {
            String svnServer = svnManage.getString("svnserver");
            if ("customserver".equals(svnServer)) {
                if (svnManage.getBoolean("mobilealone")) {
                    FormMetadata formmeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)metadataId, (MetaCategory)MetaCategory.Form);
                    if (formmeta == null) {
                        return svnManage.getString(SVNURL);
                    }
                    boolean isMobMeta = formmeta.getModelType().startsWith("Mob");
                    if (isMobMeta) {
                        return svnManage.getString("mobilesvnurl");
                    }
                    return svnManage.getString(SVNURL);
                }
                return svnManage.getString(SVNURL);
            }
            if ("nextserver".equals(svnServer)) {
                String svnUrl = AppUtils.getSvnUrl();
                String path = svnManage.getString(SVNURL);
                if (StringUtils.isNotBlank((CharSequence)svnUrl) && StringUtils.isNotBlank((CharSequence)path)) {
                    return svnUrl + path;
                }
            }
        }
        return null;
    }

    public static Map<String, String> getGitPathByAppId(String appId) {
        QFilter filter = new QFilter(BIZAPPID, "=", (Object)appId);
        String selectFields = "id,giturl,gitrepository,managetype";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"svnmanage", (String)selectFields, (QFilter[])new QFilter[]{filter});
        if (dynamicObjects.length > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("giturl", dynamicObjects[0].getString("giturl"));
            map.put("gitrepository", dynamicObjects[0].getString("gitrepository"));
            return map;
        }
        return Collections.emptyMap();
    }

    public static String getSvnUrl() {
        String host = System.getProperty("mc.server.url");
        String accountId = CacheKeyUtil.getAcctId();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        JSONObject map = new JSONObject();
        map.put("accountId", (Object)accountId);
        JSONObject result = SVNManagerUtil.doPost(host + "login/getsvnurl", map, headers);
        if (result != null && result.getIntValue("errorcode") == 100 && result.getJSONObject("data") != null) {
            return result.getJSONObject("data").getString(SVNURL);
        }
        return null;
    }

    public static void deleteFiles(String deletePath) {
        String checkPath = AppUtils.checkFilePath(deletePath);
        AppUtils.deleteKd(new File(checkPath + File.separator + "dbschema"));
        AppUtils.deleteKd(new File(checkPath + File.separator + "metadata"));
        AppUtils.deleteKd(new File(checkPath + File.separator + "preinsdata"));
    }

    public static void deleteKd(File file) {
        if (!file.isDirectory()) {
            boolean fileDelete = file.delete();
            if (fileDelete) {
                logger.debug(file + IS_DELETE);
            }
        } else if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File delfile = fileList[i];
                if (!delfile.isDirectory()) {
                    boolean isDelFile = delfile.delete();
                    if (!isDelFile) continue;
                    logger.debug(delfile + IS_DELETE);
                    continue;
                }
                if (!delfile.isDirectory()) continue;
                AppUtils.deleteKd(fileList[i]);
            }
            boolean fileDelete = file.delete();
            if (fileDelete) {
                logger.debug(file + IS_DELETE);
            }
        }
    }

    public static void deleteFile(String deletePath) {
        String checkPath = AppUtils.checkFilePath(deletePath);
        File file = new File(FileUtils.cleanString((String)checkPath));
        AppUtils.deleteKd(file);
    }

    public static List<String> getFilePaths(String formNumber, String svnLocalPath) {
        ArrayList<String> filePathList = new ArrayList<String>();
        List<String> fileList = AppUtils.getFileNames(formNumber);
        for (String fileName : fileList) {
            if (!fileName.endsWith(".dym") && !fileName.endsWith(".dymx")) continue;
            filePathList.add(AppUtils.getMetaXmlPath(fileName, svnLocalPath));
        }
        return filePathList;
    }

    private static List<String> getFileNames(String formNumber) {
        ArrayList<String> fileList = new ArrayList<String>();
        String dynFileName = String.format("%s.dym", formNumber);
        String dynLangFileName_CN = String.format("%s.zh_CN.dymx", formNumber);
        String dynLangFileName_EN = String.format("%s.en.dymx", formNumber);
        String dynLangFileName_EN_US = String.format("%s.en_US.dymx", formNumber);
        String dynLangFileName_TW = String.format("%s.zh_TW.dymx", formNumber);
        fileList.add(dynFileName);
        fileList.add(dynLangFileName_CN);
        fileList.add(dynLangFileName_EN);
        fileList.add(dynLangFileName_EN_US);
        fileList.add(dynLangFileName_TW);
        return fileList;
    }

    public static String getMetaXmlPath(String filename, String exportPath) {
        String fullPath = String.format("%s/metadata/%s", exportPath, filename);
        return fullPath;
    }

    public static String getSessionKey(String svnPath, String uuid) {
        String substring;
        String[] split2;
        String urlCheck = "((http|https|svn|file)://)(([a-zA-Z0-9._-]+)|([0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}))(([a-zA-Z]{2,6})|(:[0-9]{1,4})?)";
        Pattern pattern = Pattern.compile(urlCheck);
        Matcher matcher = pattern.matcher(svnPath);
        String sessionKey = "";
        sessionKey = matcher.matches() ? svnPath : ((split2 = svnPath.split(urlCheck)).length > 1 ? (substring = svnPath.substring(0, svnPath.length() - split2[1].length())) : split2[0]);
        String userId = RequestContext.get().getUserId();
        return sessionKey + uuid + userId;
    }

    public static String getSessionIdForSvnDiff(String sessionId) {
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            return DEFAUT_UUID_SVNDIFF;
        }
        return sessionId;
    }

    public static String getSessionKeyForSvnDiff(String svnPath, String uuid) {
        return AppUtils.getSessionKey(svnPath, uuid) + "_SvnDiff";
    }

    public static String getIsvByAppId(String bizAppId) {
        return AppMetaServiceHelper.getIsvByAppId((String)bizAppId);
    }

    public static String getIsvByCloudId(String bizCloudId) {
        return BizCloudServiceHelp.getIsvByCloudId((String)bizCloudId);
    }

    public static boolean checkCloudResourceBelongsToCurDeveloper(String bizCloudId) {
        if (StringUtils.isBlank((CharSequence)bizCloudId)) {
            return false;
        }
        return AppUtils.getIsvByCloudId(bizCloudId).equals(AppUtils.getDeveloperInfo());
    }

    public static boolean checkResourceBelongsToCurDeveloper(String bizAppId) {
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return false;
        }
        return AppUtils.getIsvByAppId(bizAppId).equals(AppUtils.getDeveloperInfo());
    }

    public static boolean checkResourceBelongsToCurDeveloper(String bizAppId, String developer) {
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            return false;
        }
        return AppUtils.getIsvByAppId(bizAppId).equals(developer);
    }

    public static String getDeveloperInfo() {
        return ISVService.getISVInfo().getId();
    }

    public static boolean isScriptBeReferenced(String scriptId) {
        QFilter[] qFilterArr = new QFilter[]{new QFilter("scriptid", "=", (Object)scriptId)};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_devp_pagerelscript", (String)"pageid", (QFilter[])qFilterArr);
        return dynamicObjects.length > 0;
    }

    public static boolean checkDeleteResource(String id, String bizAppId, IFormView view, String resourceType, String sceneType) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return false;
        }
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        switch (resourceType) {
            case "page": {
                DynamicObject[] bizApp;
                DynamicObject thisform = BusinessDataServiceHelper.loadSingle((Object)id, (String)BOS_FOEMMETA, (String)"number,basedatafield.id");
                String number = thisform.getString(NUMBER);
                if (thisform == null || StringUtils.isBlank((CharSequence)number)) {
                    return true;
                }
                MetadataWriter writer = new MetadataWriter();
                if (writer.isExistFormRefs(id)) {
                    DynamicObject[] forms;
                    QFilter q1 = new QFilter("basedatafield", "=", (Object)id);
                    QFilter q2 = new QFilter("id", "!=", (Object)id);
                    QFilter q3 = new QFilter("modeltype", "!=", (Object)"PrintModel");
                    QFilter q4 = new QFilter("inheritpath", "like", (Object)("%" + id + "%"));
                    QFilter filter = q1.and(q2).and(q3).or(q4);
                    QFilter[] filters1 = new QFilter[]{filter};
                    for (DynamicObject dynamicObject : forms = BusinessDataServiceHelper.load((String)BOS_FOEMMETA, (String)"id,name,number,modeltype,masterid,basedatafield", (QFilter[])filters1)) {
                        try {
                            DynamicObject unitRelForm = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_unitrelform", (String)"bizapp,bizunit", (QFilter[])new QFilter[]{new QFilter("form", "=", dynamicObject.get("id"))});
                            if (unitRelForm == null) continue;
                            JSONObject page = new JSONObject();
                            DynamicObject bizApp2 = unitRelForm.getDynamicObject(BIZAPP);
                            page.put(BIZAPPID, (Object)bizApp2.getString("id"));
                            page.put(BIZAPPNAME, (Object)bizApp2.getString("name"));
                            String bizunitid = unitRelForm.getString(BIZUNIT);
                            page.put(BIZUNITID, (Object)bizunitid);
                            String bizunitname = AppMetaServiceHelper.getFunctionPacketById((String)bizunitid, (String)bizApp2.getString("id"), (boolean)false).getName().getLocaleValue();
                            page.put(BIZUNITNAME, (Object)bizunitname);
                            page.put("id", (Object)dynamicObject.getString("id"));
                            page.put("name", (Object)dynamicObject.getString("name"));
                            page.put(NUMBER, (Object)dynamicObject.getString(NUMBER));
                            page.put("type", (Object)ResManager.loadKDString((String)"\u9875\u9762", (String)"AppUtils_1", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
                            String masterId = dynamicObject.getString(MASTERID);
                            String formId = dynamicObject.getString("id");
                            String entityId = dynamicObject.getString("basedatafield_id");
                            if (!formId.equals(entityId)) {
                                page.put(USERTYPE, (Object)ResManager.loadKDString((String)"\u5e03\u5c40", (String)"AppUtils_2", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
                            } else if (StringUtils.isNotBlank((CharSequence)masterId) && masterId.equals(id)) {
                                page.put(USERTYPE, (Object)ResManager.loadKDString((String)"\u6269\u5c55", (String)"AppUtils_3", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
                            } else {
                                page.put(USERTYPE, (Object)ResManager.loadKDString((String)"\u7ee7\u627f", (String)"AppUtils_4", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
                            }
                            jsonArray.add((Object)page);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                        }
                    }
                }
                String selectFields = "DISTINCT(FAPPID)";
                StringBuilder sb = new StringBuilder();
                sb.append("SELECT ").append(selectFields).append(" FROM T_META_MENURUNTIME WHERE FFORMID = ?");
                String menuSql = sb.toString();
                Object[] params = new SqlParameter[]{new SqlParameter(":FFORMID", 12, (Object)MetadataDao.getNumberById((String)id))};
                ResultSetHandler callBackHanlder = rs -> {
                    ArrayList<String> appIds = new ArrayList<String>();
                    try {
                        while (rs.next()) {
                            String appId = rs.getString("FAPPID");
                            if (!StringUtils.isNotBlank((CharSequence)appId)) continue;
                            appIds.add(appId);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return appIds;
                };
                List appIds = (List)DB.query((DBRoute)DBRoute.meta, (String)menuSql, (Object[])params, (ResultSetHandler)callBackHanlder);
                if (appIds != null && appIds.size() > 0) {
                    DynamicObject[] bizApps;
                    QFilter[] qfilter2 = new QFilter[]{new QFilter(NUMBER, "in", (Object)appIds.toArray(new String[appIds.size()]))};
                    for (DynamicObject dynamicObject : bizApps = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)"id", (QFilter[])qfilter2)) {
                        try {
                            if (SCENE_DELETEAPP.equals(sceneType) && dynamicObject.getString("id").equals(bizAppId)) continue;
                            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)dynamicObject.getString("id"), (boolean)false);
                            List appMenus = appMetadata.getAppMenus();
                            for (AppMenuElement appMenu : appMenus) {
                                String formId = appMenu.getFormId();
                                if (!StringUtils.isNotBlank((CharSequence)formId) || !formId.equals(id)) continue;
                                JSONObject menu = new JSONObject();
                                menu.put(BIZAPPID, (Object)appMetadata.getAppElement().getId());
                                menu.put(BIZAPPNAME, (Object)appMetadata.getAppElement().getName().getLocaleValue());
                                menu.put(BIZUNITID, (Object)"");
                                menu.put(BIZUNITNAME, (Object)"");
                                menu.put("id", (Object)appMenu.getId());
                                menu.put("name", (Object)appMenu.getName().getLocaleValue());
                                menu.put(NUMBER, (Object)appMenu.getNumber());
                                menu.put("type", (Object)ResManager.loadKDString((String)"\u5e94\u7528\u83dc\u5355", (String)"AppUtils_5", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
                                menu.put(USERTYPE, (Object)ResManager.loadKDString((String)"\u5e94\u7528\u83dc\u5355\u5f15\u7528", (String)"AppUtils_6", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
                                jsonArray.add((Object)menu);
                            }
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                        }
                    }
                }
                QFilter[] qfilter3 = new QFilter[]{new QFilter("mainformid", "=", (Object)id)};
                for (DynamicObject dynamicObject : bizApp = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)"id,name,number", (QFilter[])qfilter3)) {
                    try {
                        if (SCENE_DELETEAPP.equals(sceneType) && dynamicObject.getString("id").equals(bizAppId)) continue;
                        JSONObject bizapp = new JSONObject();
                        bizapp.put(BIZAPPID, (Object)dynamicObject.getString("id"));
                        bizapp.put(BIZAPPNAME, (Object)dynamicObject.getString("name"));
                        bizapp.put(BIZUNITID, (Object)"");
                        bizapp.put(BIZUNITNAME, (Object)"");
                        bizapp.put("id", (Object)dynamicObject.getString("id"));
                        bizapp.put("name", (Object)dynamicObject.getString("name"));
                        bizapp.put(NUMBER, (Object)dynamicObject.getString(NUMBER));
                        bizapp.put("type", (Object)ResManager.loadKDString((String)"\u5e94\u7528", (String)"AppUtils_7", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
                        bizapp.put(USERTYPE, (Object)ResManager.loadKDString((String)"\u5e94\u7528\u9996\u9875\u5f15\u7528", (String)"AppUtils_8", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
                        jsonArray.add((Object)bizapp);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
                String fEntityId = thisform.getString("basedatafield.id");
                if (StringUtils.isNotBlank((CharSequence)fEntityId) && StringUtils.isNotBlank((CharSequence)number)) {
                    DynamicObject object;
                    Map map;
                    EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)fEntityId, (MetaCategory)MetaCategory.Entity);
                    MainEntity rootEntity = metadata.getRootEntity();
                    String defaultPageSetting = "";
                    if (rootEntity instanceof BillEntity) {
                        defaultPageSetting = ((BillEntity)rootEntity).getDefaultPageSetting();
                    }
                    if (StringUtils.isNotBlank((CharSequence)defaultPageSetting) && (map = (Map)SerializationUtils.fromJsonString((String)defaultPageSetting, Map.class)).containsValue(number) && (object = BusinessDataServiceHelper.loadSingle((Object)fEntityId, (String)BOS_FOEMMETA, (String)"number,bizappid")) != null) {
                        JSONObject entity = new JSONObject();
                        String appId = object.getString(BIZAPPID);
                        entity.put(BIZAPPID, (Object)appId);
                        String appName = "";
                        String unitId = "";
                        String unitName = "";
                        DynamicObject unitRelForm = BusinessDataServiceHelper.loadSingle((String)"bos_devportal_unitrelform", (String)"bizapp,bizunit", (QFilter[])new QFilter[]{new QFilter("form", "=", (Object)fEntityId)});
                        if (unitRelForm != null) {
                            DynamicObject bizAppInfo = unitRelForm.getDynamicObject(BIZAPP);
                            appName = bizAppInfo.getString("name");
                            unitId = unitRelForm.getString(BIZUNIT);
                            unitName = AppMetaServiceHelper.getFunctionPacketById((String)unitId, (String)appId, (boolean)false).getName().getLocaleValue();
                        }
                        entity.put(BIZAPPNAME, (Object)appName);
                        entity.put(BIZUNITID, (Object)unitId);
                        entity.put(BIZUNITNAME, (Object)unitName);
                        entity.put("id", (Object)fEntityId);
                        entity.put("name", (Object)object.getString("name"));
                        entity.put(NUMBER, (Object)object.getString(NUMBER));
                        entity.put("type", (Object)ResManager.loadKDString((String)"\u9875\u9762", (String)"AppUtils_1", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
                        entity.put(USERTYPE, (Object)ResManager.loadKDString((String)"\u5b9e\u4f53\u7684\u9ed8\u8ba4\u5e03\u5c40", (String)"AppUtils_15", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
                        jsonArray.add((Object)entity);
                    }
                }
                if (jsonArray != null && jsonArray.size() > 0) {
                    DynamicObject form = BusinessDataServiceHelper.loadSingle((Object)id, (String)BOS_FOEMMETA);
                    String name = form.getString("name");
                    jsonObject.put(S, (Object)Boolean.FALSE);
                    jsonObject.put(MESSAGE, (Object)String.format(ResManager.loadKDString((String)"\"%s\"\u9875\u9762\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"AppUtils_16", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]), name));
                    jsonObject.put(USERESOURCE, (Object)jsonArray);
                    break;
                }
                jsonObject.put(S, (Object)Boolean.TRUE);
                break;
            }
            case "script": {
                JSONArray formIds = new JSONArray();
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_devp_pagerelscript", (String)"scriptid,pageid,enable", (QFilter[])new QFilter[]{new QFilter("scriptid", "=", (Object)id)});
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String formId = (String)dynamicObject.get("pageid");
                    formIds.add((Object)formId);
                }
                QFilter[] filters5 = new QFilter[]{new QFilter("id", "in", (Object)formIds)};
                try (DataSet dataSet5 = QueryServiceHelper.queryDataSet((String)"DEV.FRAME.MainPage", (String)BOS_FOEMMETA, (String)"id,name,number", (QFilter[])filters5, (String)"number asc");
                     DataSet dataSet6 = QueryServiceHelper.queryDataSet((String)"DEV.DEVPORTAL.BizPage", (String)"bos_devportal_unitrelform", (String)"bizunit,bizapp,form", null, null);
                     DataSet pages = dataSet5.join(dataSet6, JoinType.INNER).on("id", "form").select(new String[]{"id", "name", NUMBER}, new String[]{BIZUNIT, BIZAPP, "form"}).finish();){
                    for (Row row : pages) {
                        try {
                            JSONObject page = new JSONObject();
                            AppElement appElement = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)row.getString(BIZAPP), (boolean)false).getAppElement();
                            AppFunctionPacketElement functionPacket = AppMetaServiceHelper.getFunctionPacketById((String)row.getString(BIZUNIT), (String)row.getString(BIZAPP), (boolean)false);
                            page.put(BIZAPPID, (Object)appElement.getId());
                            page.put(BIZAPPNAME, (Object)appElement.getName().getLocaleValue());
                            page.put(BIZUNITID, (Object)functionPacket.getId());
                            page.put(BIZUNITNAME, (Object)functionPacket.getName().getLocaleValue());
                            page.put("id", (Object)row.getString("id"));
                            page.put("name", (Object)row.getString("name"));
                            page.put(NUMBER, (Object)row.getString(NUMBER));
                            page.put("type", (Object)ResManager.loadKDString((String)"\u9875\u9762", (String)"AppUtils_1", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
                            page.put(USERTYPE, (Object)ResManager.loadKDString((String)"\u9875\u9762\u6ce8\u518c\u811a\u672c\u63d2\u4ef6", (String)"AppUtils_10", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
                            jsonArray.add((Object)page);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                        }
                    }
                }
                if (jsonArray != null && jsonArray.size() > 0) {
                    jsonObject.put(S, (Object)Boolean.FALSE);
                    jsonObject.put(MESSAGE, (Object)ResManager.loadKDString((String)"\u8be5\u811a\u672c\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"AppUtils_11", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
                    jsonObject.put(USERESOURCE, (Object)jsonArray);
                    break;
                }
                jsonObject.put(S, (Object)Boolean.TRUE);
                break;
            }
            case "unittest": {
                if (jsonArray != null && jsonArray.size() > 0) {
                    jsonObject.put(S, (Object)Boolean.FALSE);
                    jsonObject.put(MESSAGE, (Object)ResManager.loadKDString((String)"\u8be5\u5355\u5143\u6d4b\u8bd5\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"AppUtils_12", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
                    jsonObject.put(USERESOURCE, (Object)jsonArray);
                    break;
                }
                jsonObject.put(S, (Object)Boolean.TRUE);
                break;
            }
        }
        if (jsonObject != null && jsonObject.getBooleanValue(S)) {
            return true;
        }
        if (SCENE_DELETEAPP.equals(sceneType)) {
            return false;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_devp_delresourcetip");
        if (StringUtils.equals((CharSequence)"page", (CharSequence)resourceType)) {
            parameter.setCaption(ResManager.loadKDString((String)"\u5220\u9664\u9875\u9762\u63d0\u793a", (String)"AppUtils_9", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
        } else {
            parameter.setCaption(ResManager.loadKDString((String)"\u5220\u9664\u8d44\u6e90\u63d0\u793a", (String)"AppUtils_13", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]));
        }
        parameter.setCustomParam("scenetype", (Object)sceneType);
        parameter.setCustomParam(MESSAGE, jsonObject.get((Object)MESSAGE));
        parameter.setCustomParam(USERESOURCE, (Object)jsonObject.get((Object)USERESOURCE).toString());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(parameter);
        return false;
    }

    public static void getMetadataContent(File filePath, JSONObject msg) {
        File[] files;
        for (File file : files = filePath.listFiles()) {
            String fileName = file.getName();
            if (!fileName.endsWith("dym") && !fileName.endsWith("dymx")) continue;
            try (BufferedReader br = new BufferedReader(new FileReader(file.getCanonicalFile()));){
                String line = null;
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append(System.getProperty("line.separator"));
                }
                String content = sb.toString();
                MetadataDao.deployMetadata((String)content);
                AppUtils.rebuildRuntimeMetaById(content);
            }
            catch (IOException e) {
                msg.put(ERROR, (Object)e);
                return;
            }
        }
    }

    public static void getMetadataContent(File file) {
        String fileName = file.getName();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            String content = sb.toString();
            if (fileName.endsWith(".dym")) {
                MetadataDao.deployMetadata((String)content);
                AppUtils.rebuildRuntimeMetaById(content);
            } else if (fileName.endsWith(".dymx")) {
                MetadataDao.deployMetadata((String)content);
            } else if (fileName.endsWith(".ks") || fileName.endsWith(".ts")) {
                MetadataDao.deployScript((String)content);
            } else if (fileName.endsWith(".card")) {
                MetadataDao.deployCard((String)content);
            } else if (fileName.endsWith(".app") || fileName.endsWith(".appx")) {
                AppMetaServiceHelper.deployAppMetadata((String)content);
            }
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static void rebuildRuntimeMetaById(String content) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
        if (!deployNew.isMultilanguage()) {
            String formId = deployNew.getMasterId();
            MetadataDao.rebuildRuntimeMetaById((String)formId);
        }
    }

    public static boolean checkPagePermission(String pageNumber, String permissionItemId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int flag = PermissionServiceHelper.checkPermission((long)userId, (String)"bos_org", (long)0L, null, (String)pageNumber, (String)permissionItemId);
        boolean isHasPermission = flag == 1;
        return isHasPermission;
    }

    public static void addLog(String id, String opName, String opDescription) {
        try {
            LogServiceHelper helper = new LogServiceHelper();
            AppLogInfo info = new AppLogInfo();
            info.setUserID(Long.valueOf(RequestContext.get().getUserId()));
            DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)"devportal")});
            if (bizApp != null) {
                info.setBizAppID(bizApp.getString("id"));
            }
            info.setBizObjID(id);
            info.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
            info.setOpTime(TimeServiceHelper.now());
            info.setClientType(RequestContext.get().getClient());
            info.setClientIP(RequestContext.get().getLoginIP());
            info.setOpName(opName);
            info.setOpDescription(opDescription);
            LogServiceHelper.addLog((AppLogInfo)info);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static void addOpLog(String id, String opKey, String keyWord, String status, String opName, String opDescription) {
        try {
            LogServiceHelper helper = new LogServiceHelper();
            OpLogAppInfo info = AppUtils.buildOpLogAppInfo(id, keyWord, status);
            info.setOpName(opKey, opName);
            info.setOpDescription(opDescription);
            LogServiceHelper.addLog((AppLogInfo)info);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static void addOpLog(String id, String opKey, String keyWord, String status, MultiLangEnumBridge opName, MultiLangEnumBridge opDescription, String ... args) {
        try {
            LogServiceHelper helper = new LogServiceHelper();
            OpLogAppInfo info = AppUtils.buildOpLogAppInfo(id, keyWord, status);
            info.setOpName(opKey, opName);
            info.setOpDesc(opDescription, args);
            LogServiceHelper.addLog((AppLogInfo)info);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static OpLogAppInfo buildOpLogAppInfo(String id, String keyWord, String status) {
        OpLogAppInfo info = new OpLogAppInfo();
        info.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)"devportal")});
        if (bizApp != null) {
            info.setBizAppID(bizApp.getString("id"));
        }
        info.setBizObjID(id);
        info.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        info.setOpTime(TimeServiceHelper.now());
        info.setClientType(RequestContext.get().getClient());
        info.setClientIP(RequestContext.get().getLoginIP());
        if (StringUtils.isNotBlank((CharSequence)status)) {
            info.setStatus(status);
        }
        if (StringUtils.isNotBlank((CharSequence)keyWord)) {
            info.setKeyWord(keyWord);
        }
        return info;
    }

    private static Map<Object, DynamicObject> getClouds(QFilter[] filters) {
        String fields = "id,name,number,sequence";
        filters = RunModeServiceHelper.getCloudIdBlacklistFilters((QFilter[])filters, (String)"id");
        Object[] newFilter = AppUtils.appendProductCloudIdBlackQFilter(filters, "id");
        newFilter = (QFilter[])ArrayUtils.add((Object[])newFilter, (Object)new QFilter("id", "!=", (Object)NOCODE_CLOUD_ID));
        Map cloudsMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)fields, (QFilter[])newFilter, (String)ORDERBY);
        return cloudsMap;
    }

    private static QFilter[] appendProductCloudIdBlackQFilter(QFilter[] oldCloudIdFilter, String fieldName) {
        ProductSettingService productService = AppUtils.getProductSettingService();
        List appids = productService.getCloudIdBlackList();
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (oldCloudIdFilter != null) {
            list.addAll(Arrays.asList(oldCloudIdFilter));
        }
        if (!appids.isEmpty()) {
            list.add(new QFilter(fieldName, "not in", (Object)appids.toArray()));
        }
        return list.toArray(new QFilter[list.size()]);
    }

    private static QFilter[] appendProductAppIdBlackQFilter(QFilter[] oldAppIdFilter, String fieldName) {
        ProductSettingService productService = AppUtils.getProductSettingService();
        List appids = productService.getAppIdBlackList();
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (oldAppIdFilter != null) {
            list.addAll(Arrays.asList(oldAppIdFilter));
        }
        if (!appids.isEmpty()) {
            list.add(new QFilter(fieldName, "not in", (Object)appids.toArray()));
        }
        return list.toArray(new QFilter[list.size()]);
    }

    private static ProductSettingService getProductSettingService() {
        ProductSettingService productService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        return productService;
    }

    public static List<DynamicObject> getApps(QFilter[] filters, String orderBy, boolean isRuntime) {
        return AppUtils.getApps(filters, orderBy, isRuntime, true);
    }

    public static List<DynamicObject> getApps(QFilter[] filters, boolean isRuntime) {
        return AppUtils.getApps(filters, ORDERBY, isRuntime);
    }

    private static List<DynamicObject> getApps(QFilter[] filters, String industryId, boolean isRuntime, boolean onlyVisible, String orderBy) {
        QFilter filter;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (StringUtils.isNotBlank((CharSequence)industryId)) {
            filter = new QFilter(INDUSTRY, "=", (Object)industryId);
            filter.or(new QFilter(INDUSTRY, "=", (Object)0));
            filterList.add(filter);
        }
        if (isRuntime) {
            filter = new QFilter("type", "!=", (Object)"2");
            filter.and(new QFilter("deploystatus", "=", (Object)"2"));
            filterList.add(filter);
        }
        if (filters != null) {
            for (QFilter f : filters) {
                filterList.add(f);
            }
        }
        if (filterList.size() > 0) {
            filters = filterList.toArray(new QFilter[filterList.size()]);
        }
        return AppUtils.getApps(filters, orderBy, isRuntime, onlyVisible);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<DynamicObject> getApps(QFilter[] filters, String orderBy, boolean isRuntime, boolean onlyVisible) {
        QFilter mstEmpty;
        QFilter mstNotNUll;
        QFilter[] mstfilters;
        DynamicObject[] appExtends;
        filters = RunModeServiceHelper.getAppAndCloudBlacklistFilters((QFilter[])filters, (String)"id", (String)BIZCLOUD);
        Object[] newFilter = AppUtils.appendProductCloudIdBlackQFilter(AppUtils.appendProductAppIdBlackQFilter(filters, "id"), BIZCLOUD);
        newFilter = (QFilter[])ArrayUtils.add((Object[])newFilter, (Object)new QFilter(BIZCLOUD, "!=", (Object)NOCODE_CLOUD_ID));
        newFilter = (QFilter[])ArrayUtils.add((Object[])newFilter, (Object)new QFilter("id", "!=", (Object)NOCODE_SYS_APP_ID));
        Map appsMap = BusinessDataServiceHelper.loadFromCache((String)BOS_DEVPORTAL_BIZAPP, (String)"id,name,number,type,industry,bizcloud,sequence,visible,deploystatus", (QFilter[])newFilter, (String)orderBy);
        HashSet<String> extendedAppIds = new HashSet<String>();
        HashMap hashMap = new HashMap(0);
        if (isRuntime && onlyVisible && (appExtends = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)"masterid,visible", (QFilter[])(mstfilters = new QFilter[]{mstNotNUll = new QFilter(MASTERID, "is not null", (Object)Boolean.TRUE), mstEmpty = new QFilter(MASTERID, "!=", (Object)" ")}))).length > 0) {
            for (DynamicObject obj : appExtends) {
                String masterStr = obj.getString(MASTERID);
                extendedAppIds.add(masterStr);
            }
            Map<String, ILocaleString> map = AppUtils.getAppNameMap();
        }
        ArrayList<DynamicObject> apps = new ArrayList<DynamicObject>();
        HashMap<String, DynamicObject> toAnalyzedApp = new HashMap<String, DynamicObject>(10);
        if (appsMap != null) {
            for (DynamicObject obj : appsMap.values()) {
                block12: {
                    String string = obj.getString("id");
                    String appNum = obj.getString(NUMBER);
                    if (isRuntime && onlyVisible) {
                        if ("portal".equals(appNum)) continue;
                        if (extendedAppIds.contains(string)) {
                            void var7_9;
                            ILocaleString name = (ILocaleString)var7_9.get(appNum);
                            if (name != null) {
                                obj.set("name", (Object)name);
                                break block12;
                            } else {
                                toAnalyzedApp.put(appNum, obj);
                                continue;
                            }
                        }
                        boolean visible = obj.getBoolean("visible");
                        if (!visible) continue;
                    }
                }
                apps.add(obj);
            }
        }
        if (toAnalyzedApp.size() > 0) {
            Map<String, Boolean> runtimeMaps = AppUtils.loadAppRealRuntimeInfo(toAnalyzedApp);
            for (Map.Entry entry : toAnalyzedApp.entrySet()) {
                AppInfo appInfo;
                String appNum = (String)entry.getKey();
                Boolean v = runtimeMaps.getOrDefault(appNum, true);
                if (!v.booleanValue() || !(appInfo = AppMetadataCache.getAppInfoByNumber((String)appNum)).isRealRuntime()) continue;
                ((DynamicObject)entry.getValue()).set("name", (Object)appInfo.getName());
                apps.add((DynamicObject)entry.getValue());
            }
        }
        final Map<Object, DynamicObject> cloudsMap = AppUtils.getClouds(null);
        try {
            Collections.sort(apps, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    String bizCloudId2;
                    if (null == o1 && null == o2) {
                        return 0;
                    }
                    if (null == o1) {
                        return -1;
                    }
                    if (null == o2) {
                        return 1;
                    }
                    String bizCloudId1 = o1.getString("bizcloud_id");
                    if (StringUtils.equals((CharSequence)bizCloudId1, (CharSequence)(bizCloudId2 = o2.getString("bizcloud_id")))) {
                        return 0;
                    }
                    DynamicObject obj1 = (DynamicObject)cloudsMap.get(bizCloudId1);
                    DynamicObject obj2 = (DynamicObject)cloudsMap.get(bizCloudId2);
                    int seq1 = obj1 == null ? 0 : obj1.getInt("sequence");
                    int seq2 = obj2 == null ? 0 : obj2.getInt("sequence");
                    return Integer.compare(seq1, seq2);
                }
            });
            return apps;
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        return apps;
    }

    private static Map<String, Boolean> loadAppRealRuntimeInfo(Map<String, DynamicObject> masterAppObjs) {
        try (EntityTraceSpan span = EntityTracer.create((String)"AppUtils", (String)"loadAppRealRuntimeInfo");){
            DynamicObject[] objs;
            HashMap<String, AppInfo> masterApps = new HashMap<String, AppInfo>(masterAppObjs.size());
            ArrayList<String> masterIds = new ArrayList<String>(masterAppObjs.size());
            HashMap<String, Integer> inheritCount = new HashMap<String, Integer>(masterAppObjs.size());
            for (Map.Entry<String, DynamicObject> it : masterAppObjs.entrySet()) {
                DynamicObject[] app = it.getValue();
                String pk = (String)app.getPkValue();
                AppInfo appInfo = new AppInfo();
                appInfo.setAppId(pk);
                appInfo.setNumber(app.getString(NUMBER));
                appInfo.setRealRuntime("2".equals(app.getString("deploystatus")) && app.getBoolean("visible"));
                masterApps.put(pk, appInfo);
                masterIds.add(pk);
            }
            span.addLocaleTag("masterIds", masterIds);
            QFilter filter = new QFilter(MASTERID, "in", (Object)masterIds.toArray(new String[masterIds.size()]));
            for (DynamicObject ext : objs = BusinessDataServiceHelper.load((String)BOS_DEVPORTAL_BIZAPP, (String)"id,number,inheritpath,name,visible,masterId,deploystatus", (QFilter[])new QFilter[]{filter}, (String)"masterId,inheritpath asc")) {
                String inherit = ext.getString("inheritpath");
                String masterid = ext.getString("masterId");
                if (StringUtils.isNotBlank((CharSequence)inherit) && inheritCount.getOrDefault(inherit, 0) > 0) {
                    masterApps.remove(ext.getString("masterId"));
                    continue;
                }
                inheritCount.put(inherit, 1);
                AppInfo appInfo = (AppInfo)masterApps.get(masterid);
                if (appInfo == null) continue;
                appInfo.setRealRuntime("2".equals(ext.getString("deploystatus")) && ext.getBoolean("visible"));
            }
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(masterApps.size());
            for (Map.Entry it : masterApps.entrySet()) {
                result.put(((AppInfo)it.getValue()).getNumber(), ((AppInfo)it.getValue()).isRealRuntime());
            }
            span.addLocaleTag("result", result);
            HashMap<String, Boolean> hashMap = result;
            return hashMap;
        }
    }

    private static Map<String, ILocaleString> getAppNameMap() {
        StringBuilder sb = new StringBuilder("select a.fappid ,b.fname, b.flocaleid from t_meta_appruntime a join t_meta_appruntime_l b on a.fappid = b.fappid ");
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sb.toString(), (ResultSetHandler)new ResultSetHandler<Map<String, ILocaleString>>(){

            public Map<String, ILocaleString> handle(ResultSet rs) throws SQLException {
                HashMap<String, ILocaleString> map = new HashMap<String, ILocaleString>(16);
                while (rs.next()) {
                    String appId = rs.getString("fappid");
                    String name = rs.getString("fname");
                    if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                    String localeid = rs.getString("flocaleid");
                    ILocaleString localeString = (ILocaleString)map.get(appId);
                    if (localeString == null) {
                        localeString = new LocaleString();
                        map.put(appId, localeString);
                    }
                    localeString.put((Object)localeid, (Object)name);
                }
                return map;
            }
        });
    }

    public static TreeNode getCloudSubsysTree(String[] bizCloudIds, String industryId) {
        TreeNode root = AppUtils.getSubsysTree(bizCloudIds, null, industryId, CLOUD, true);
        return root;
    }

    public static TreeNode getSubsysTree(String[] bizCloudIds, String[] bizAppIds, String industryId, String leafType, boolean isRuntime, boolean onlyVisible, boolean onlyDeployed) {
        TreeNode root = new TreeNode("", ROOTNODE, ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"AppUtils_14", (String)DEV_DEVPORTAL_COMMON, (Object[])new Object[0]), (Object)"root");
        root.setIsOpened(true);
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        ProductSettingService pService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List blackCloudId = pService.getCloudIdBlackList();
        List blackAppIds = pService.getAppIdBlackList();
        if (CLOUD.equals(leafType)) {
            QFilter filter;
            if (!blackCloudId.isEmpty()) {
                filterList.add(new QFilter("id", "not in", (Object)blackCloudId.toArray()));
            }
            if (bizCloudIds != null) {
                filter = new QFilter("id", "in", (Object)bizCloudIds);
                filterList.add(filter);
            }
            if (StringUtils.isNotBlank((CharSequence)industryId)) {
                filter = new QFilter(INDUSTRY, "=", (Object)industryId);
                filter.or(new QFilter(INDUSTRY, "=", (Object)0));
                filterList.add(filter);
            }
            QFilter[] filters = filterList.toArray(new QFilter[filterList.size()]);
            Map<Object, DynamicObject> cloudsMap = AppUtils.getClouds(filters);
            for (DynamicObject obj : cloudsMap.values()) {
                TreeNode node = new TreeNode(ROOTNODE, obj.getString("id"), obj.getString("name"), (Object)CLOUD);
                root.addChild(node);
            }
        } else {
            QFilter filter;
            if (!blackCloudId.isEmpty()) {
                filterList.add(new QFilter(BIZCLOUD, "not in", (Object)blackCloudId.toArray()));
            }
            if (!blackAppIds.isEmpty()) {
                filterList.add(new QFilter("id", "not in", (Object)blackAppIds.toArray()));
            }
            if (bizAppIds != null) {
                filter = new QFilter("id", "in", (Object)bizAppIds);
                filterList.add(filter);
            } else if (bizCloudIds != null) {
                filter = new QFilter(BIZCLOUD, "in", (Object)bizCloudIds);
                filterList.add(filter);
            }
            if (StringUtils.isNotBlank((CharSequence)industryId)) {
                filter = new QFilter(INDUSTRY, "=", (Object)industryId);
                filter.or(new QFilter(INDUSTRY, "=", (Object)0));
                filterList.add(filter);
            }
            if (isRuntime) {
                filter = new QFilter("type", "!=", (Object)"2");
                filterList.add(filter);
            }
            if (isRuntime && onlyDeployed) {
                filter = new QFilter("deploystatus", "=", (Object)"2");
                filterList.add(filter);
            }
            QFilter[] filters = filterList.toArray(new QFilter[filterList.size()]);
            List<DynamicObject> apps = AppUtils.getApps(filters, ORDERBY, isRuntime, onlyVisible);
            HashMap<String, TreeNode> allNodeMap = new HashMap<String, TreeNode>();
            for (DynamicObject obj : apps) {
                AppMetadata appMeta;
                DynamicObject cldObj = obj.getDynamicObject(BIZCLOUD);
                if (cldObj == null) continue;
                String cldName = cldObj.getLocaleString("name").toString();
                String cldId = cldObj.getString("id");
                String appName = obj.getLocaleString("name").toString();
                String appId = obj.getString("id");
                String appNum = obj.getString(NUMBER);
                if (cldId != null && allNodeMap.get(cldId) == null) {
                    TreeNode cldNode = new TreeNode(ROOTNODE, cldId, cldName, (Object)CLOUD);
                    allNodeMap.put(cldId, cldNode);
                    root.addChild(cldNode);
                }
                TreeNode appNode = new TreeNode(cldId, appId, appName, (Object)"app");
                allNodeMap.put(appId, appNode);
                ((TreeNode)allNodeMap.get(cldId)).addChild(appNode);
                if ("menu".equals(leafType)) {
                    TreeNode menuNode;
                    String menuName;
                    String menuId;
                    if (isRuntime) {
                        List appMenus = AppMetadataCache.getAppMenusInfoByAppNum((String)appNum);
                        if (appMenus == null) continue;
                        for (AppMenuInfo appMenu : appMenus) {
                            menuId = appMenu.getId();
                            menuName = appMenu.getName().toString();
                            menuNode = new TreeNode(appId, menuId, menuName, (Object)"menu");
                            allNodeMap.put(menuId, menuNode);
                            ((TreeNode)allNodeMap.get(appId)).addChild(menuNode);
                        }
                        continue;
                    }
                    appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)isRuntime);
                    if (appMeta == null) continue;
                    for (AppMenuInfo appMenu : appMeta.getAppMenus()) {
                        menuId = appMenu.getId();
                        menuName = appMenu.getName().toString();
                        menuNode = new TreeNode(appId, menuId, menuName, (Object)"menu");
                        allNodeMap.put(menuId, menuNode);
                        ((TreeNode)allNodeMap.get(appId)).addChild(menuNode);
                    }
                    continue;
                }
                if (!"func".equals(leafType) || (appMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)appId, (boolean)isRuntime)) == null) continue;
                for (AppFunctionPacketElement appFunc : appMeta.getAppFunctionPackets()) {
                    String funcId = appFunc.getId();
                    String funcName = appFunc.getName().toString();
                    TreeNode funcNode = new TreeNode(appId, funcId, funcName, (Object)"func");
                    allNodeMap.put(funcId, funcNode);
                    ((TreeNode)allNodeMap.get(appId)).addChild(funcNode);
                }
            }
        }
        return root;
    }

    public static TreeNode getSubsysTree(String[] bizCloudIds, String[] bizAppIds, String industryId, String leafType, boolean isRuntime) {
        return AppUtils.getSubsysTree(bizCloudIds, bizAppIds, industryId, leafType, isRuntime, true, true);
    }

    public static int getAppListConut(QFilter[] filters, String industryId, boolean isRuntime, boolean onlyVisible) {
        int count = 0;
        List<DynamicObject> apps = AppUtils.getApps(filters, industryId, isRuntime, onlyVisible, "");
        if (apps != null && apps.size() > 0) {
            count = apps.size();
        }
        return count;
    }

    public static Map<String, Object> getAppListInfo(QFilter[] filters, String industryId, boolean isRuntime, boolean onlyVisible, String orderBy, int pageIndex, int limit) {
        HashMap<String, Object> rt = new HashMap<String, Object>();
        List<DynamicObject> apps = AppUtils.getApps(filters, industryId, isRuntime, onlyVisible, orderBy);
        if (apps != null && apps.size() > 0) {
            rt.put("datacount", apps.size());
            DynamicObjectCollection col = new DynamicObjectCollection();
            for (int i = pageIndex * limit; i < (pageIndex + 1) * limit && i < apps.size(); ++i) {
                col.add((Object)apps.get(i));
            }
            rt.put("data", col);
        }
        return rt;
    }

    public static Map<String, Object> getAppListInfo(QFilter[] filters, String industryId, boolean isRuntime, String orderBy, int pageIndex, int limit) {
        return AppUtils.getAppListInfo(filters, industryId, isRuntime, false, orderBy, pageIndex, limit);
    }

    public static Map<String, Object> getRuntimeAppListInfo(QFilter[] filters, String industryId, String orderBy, int pageIndex, int limit) {
        return AppUtils.getAppListInfo(filters, industryId, true, true, orderBy, pageIndex, limit);
    }

    public static int getCountByFilter(QFilter[] filters, String entityName) {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(entityName + "_getCount"), (String)entityName, (String)"id", (QFilter[])filters, null);){
            int n = ds.count("id", true);
            return n;
        }
    }

    public static int getFromListConut(QFilter[] filters, String industryId, boolean isRuntime) {
        filters = AppUtils.buildQueryFilters(filters, industryId, isRuntime);
        int count = AppUtils.getCountByFilter(filters, BOS_FOEMMETA);
        return count;
    }

    private static QFilter[] buildQueryFilters(QFilter[] filters, String industryId, boolean isRuntime) {
        QFilter filter;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (StringUtils.isNotBlank((CharSequence)industryId)) {
            filter = new QFilter(INDUSTRY, "=", (Object)industryId);
            filter.or(new QFilter(INDUSTRY, "=", (Object)0));
            filterList.add(filter);
        }
        if (isRuntime) {
            filter = new QFilter("type", "!=", (Object)"2");
            filterList.add(filter);
        }
        if (filters != null) {
            for (QFilter f : filters) {
                filterList.add(f);
            }
        }
        if (filterList.size() > 0) {
            filters = filterList.toArray(new QFilter[filterList.size()]);
        }
        return filters;
    }

    public static Map<String, Object> getFormListInfo(QFilter[] filters, String industryId, boolean isRuntime, String orderBy, int pageIndex, int limit) {
        QFilter mstEmpty;
        QFilter mstNotNUll;
        QFilter[] mstfilters;
        Map appExtends;
        HashMap<String, Object> rt = new HashMap<String, Object>();
        filters = AppUtils.buildQueryFilters(filters, industryId, isRuntime);
        int count = AppUtils.getCountByFilter(filters, BOS_FOEMMETA);
        rt.put("datacount", count);
        DynamicObjectCollection col = new DynamicObjectCollection();
        DynamicObject[] formArray = BusinessDataServiceHelper.load((String)BOS_FOEMMETA, (String)"id,name,number,type,modeltype,bizappid", (QFilter[])filters, (String)orderBy, (int)pageIndex, (int)limit);
        HashSet<String> extendedFormPks = new HashSet<String>();
        if (isRuntime && (appExtends = BusinessDataServiceHelper.loadFromCache((String)BOS_FOEMMETA, (String)"masterid,visible", (QFilter[])(mstfilters = new QFilter[]{mstNotNUll = new QFilter(MASTERID, "is not null", (Object)Boolean.TRUE), mstEmpty = new QFilter(MASTERID, "!=", (Object)" ")}))).size() > 0) {
            for (DynamicObject obj : appExtends.values()) {
                String masterStr = obj.getString(MASTERID);
                extendedFormPks.add(masterStr);
            }
        }
        if (formArray != null) {
            for (DynamicObject obj : formArray) {
                FormConfig cfg;
                String id = obj.getString("id");
                String formNum = obj.getString(NUMBER);
                String modelType = obj.getString("modeltype");
                if (isRuntime && !"PrintModel".equals(modelType) && extendedFormPks.contains(id) && (cfg = FormMetadataCache.getFormConfig((String)formNum)) != null) {
                    obj.set("name", (Object)cfg.getCaption());
                }
                col.add((Object)obj);
            }
        }
        rt.put("data", col);
        return rt;
    }

    public static Map<String, Object> getRuntimeFormListInfo(QFilter[] filters, String industryId, String orderBy, int start, int limit) {
        return AppUtils.getFormListInfo(filters, industryId, true, orderBy, start, limit);
    }

    public static String autoExtendedNumber(String number) {
        String isv = AppUtils.getDeveloperInfo();
        number = number.toLowerCase(Locale.ENGLISH);
        if (!"kingdee".equalsIgnoreCase(isv) && StringUtils.isNotBlank((CharSequence)isv) && !number.startsWith(isv.toLowerCase() + "_")) {
            number = isv.toLowerCase() + "_" + number;
        }
        return number + "_ext";
    }

    public static String autoAppNumber(String bizCloudId, String appNumber, String tag) {
        if (appNumber.length() <= 25) {
            if (AppUtils.checkAppNumber(bizCloudId, appNumber)) {
                int i = 1;
                String number = appNumber + i;
                while (AppUtils.checkAppNumber(bizCloudId, number)) {
                    number = appNumber + ++i;
                }
                appNumber = number;
            }
        } else {
            int tag_len = tag.length();
            appNumber = appNumber.substring(0, 25 - tag_len) + tag;
            int i = 0;
            while (AppUtils.checkAppNumber(bizCloudId, appNumber)) {
                int i_len = String.valueOf(++i).length();
                appNumber = appNumber.substring(0, 25 - tag_len - i_len) + tag + i;
            }
        }
        return appNumber;
    }

    private static boolean checkAppNumber(String bizCloudId, String appNumber) {
        QFilter q1 = new QFilter(BIZCLOUD, "=", (Object)bizCloudId);
        QFilter q2 = new QFilter(NUMBER, "=", (Object)appNumber);
        QFilter[] filters = new QFilter[]{q1, q2};
        boolean exists = QueryServiceHelper.exists((String)BOS_DEVPORTAL_BIZAPP, (QFilter[])filters);
        return exists;
    }

    public static String checkFilePath(String path) {
        return path.replace("../", "#");
    }
}

