/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.FlatFieldAp;

public class DesignerUtils {
    public static final List<String> ISV_LIST = Arrays.asList("kingdee", "kdxk", "test");

    public static Map<String, Object> getSpecialPropsExtensible(String entityId) {
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return null;
        }
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        if (metadata == null) {
            return null;
        }
        if (!"2".equals(metadata.getDevType())) {
            return null;
        }
        if (!metadata.isEnableGlobalExtLimits()) {
            return null;
        }
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)metadata.getMasterId(), (MetaCategory)MetaCategory.Form);
        String masterIsv = formMetadata.getIsv();
        ArrayList<Map<String, Object>> fieldPropsLockList = new ArrayList<Map<String, Object>>(10);
        EntityMetadata originalMetadata = (EntityMetadata)MetadataDao.readMeta((String)metadata.getParentId(), (MetaCategory)MetaCategory.Entity);
        List items = originalMetadata.getItems();
        for (EntityItem item : items) {
            if (item instanceof Field) {
                if (((Field)item).isMustInput()) {
                    DesignerUtils.assembleFiledPropsLockList(metadata, ((Field)item).getId(), "MustInput", fieldPropsLockList, masterIsv);
                }
                if (!(item instanceof ComboField) || !((ComboField)item).isComboValueCheck()) continue;
                DesignerUtils.assembleFiledPropsLockList(metadata, ((Field)item).getId(), "ComboValueCheck", fieldPropsLockList, masterIsv);
                continue;
            }
            if (!(item instanceof EntryEntity)) continue;
            if (((EntryEntity)item).isEntryMustInput()) {
                DesignerUtils.assembleFiledPropsLockList(metadata, ((EntryEntity)item).getId(), "EntryMustInput", fieldPropsLockList, masterIsv);
            }
            if (!StringUtils.isNotBlank((CharSequence)((EntryEntity)item).getKeyFieldId())) continue;
            DesignerUtils.assembleFiledPropsLockList(metadata, ((EntryEntity)item).getId(), "KeyFieldId", fieldPropsLockList, masterIsv);
        }
        FormMetadata oriFormMeta = (FormMetadata)MetadataDao.readMeta((String)metadata.getParentId(), (MetaCategory)MetaCategory.Form);
        for (ControlAp control : oriFormMeta.getItems()) {
            String fieldId;
            EntityItem entityItem;
            String oriLock;
            if (!(control instanceof FormAp) && StringUtils.isNotBlank((CharSequence)(oriLock = control.getLock()))) {
                DesignerUtils.assembleFiledSpecialPropsLockList(oriLock, oriFormMeta, metadata, control.getId(), "Lock", fieldPropsLockList, masterIsv);
            }
            if (control instanceof FieldAp && ((FieldAp)control).isFireUpdEvt()) {
                DesignerUtils.assembleFiledPropsLockList(metadata, control.getId(), "FireUpdEvt", fieldPropsLockList, masterIsv);
            }
            if (control instanceof FlatFieldAp && (entityItem = originalMetadata.getItemById(fieldId = ((FlatFieldAp)control).getFieldId())) instanceof Field && ((Field)entityItem).isMustInput()) {
                DesignerUtils.assembleFiledPropsLockList(metadata, control.getId(), "MustInput", fieldPropsLockList, masterIsv);
            }
            if (control instanceof EntryFieldAp && !((EntryFieldAp)control).isF7MultipleSelect()) {
                DesignerUtils.assembleFiledPropsLockList(metadata, control.getId(), "F7MultipleSelect", fieldPropsLockList, masterIsv);
            }
            if (!(control instanceof CardEntryFieldAp) || ((CardEntryFieldAp)control).isF7MultipleSelect()) continue;
            DesignerUtils.assembleFiledPropsLockList(metadata, control.getId(), "F7MultipleSelect", fieldPropsLockList, masterIsv);
        }
        return DesignerUtils.mergeMaps(fieldPropsLockList);
    }

    private static void assembleFiledSpecialPropsLockList(String oriLock, FormMetadata formMetadata, EntityMetadata metadata, String fieldId, String propertyNumber, List<Map<String, Object>> fieldPropsLockList, String masterIsv) {
        ControlAp item = formMetadata.getItem(fieldId);
        String fieldIsv = "";
        if (item != null) {
            fieldIsv = item.getIsv();
        }
        if (ISV_LIST.contains(fieldIsv) && !StringUtils.equals((CharSequence)metadata.getIsv(), (CharSequence)fieldIsv)) {
            HashMap fieldLockType = new HashMap(1);
            ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((AbstractMetadata)metadata, (String)"Field", (String)metadata.getModelType(), (String)fieldId, (String)propertyNumber, (String)masterIsv);
            if (ExtLockTypeEnum.speciallock.equals((Object)lockType)) {
                HashMap<String, String> oriLockProp = new HashMap<String, String>(1);
                oriLockProp.put("Lock", oriLock);
                fieldLockType.put(fieldId, oriLockProp);
                fieldPropsLockList.add(fieldLockType);
            }
        }
    }

    private static void assembleFiledPropsLockList(EntityMetadata metadata, String fieldId, String propertyNumber, List<Map<String, Object>> fieldPropsLockList, String masterIsv) {
        EntityItem entityItem = metadata.getItemById(fieldId);
        String fieldIsv = "";
        if (entityItem != null) {
            fieldIsv = entityItem.getIsv();
        }
        if (ISV_LIST.contains(fieldIsv) && !StringUtils.equals((CharSequence)metadata.getIsv(), (CharSequence)fieldIsv)) {
            HashMap fieldLockType = new HashMap(1);
            ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((AbstractMetadata)metadata, (String)"Field", (String)metadata.getModelType(), (String)fieldId, (String)propertyNumber, (String)masterIsv);
            if (ExtLockTypeEnum.speciallock.equals((Object)lockType)) {
                HashSet<String> props = new HashSet<String>(1);
                props.add(propertyNumber);
                fieldLockType.put(fieldId, props);
                fieldPropsLockList.add(fieldLockType);
            }
        }
    }

    private static Map<String, Object> mergeMaps(List<Map<String, Object>> listOfMaps) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map<String, Object> map : listOfMaps) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                List<Object> values;
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Set) {
                    value = ((Set)value).toArray()[0];
                }
                if (result.containsKey(key)) {
                    values = (List)result.get(key);
                    values.add(value);
                    continue;
                }
                values = new ArrayList();
                values.add(value);
                result.put(key, values);
            }
        }
        return result;
    }
}

