/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.common.util;

import java.io.IOException;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HttpClientUtils {
    public static final Log logger = LogFactory.getLog(HttpClientUtils.class);
    private static int default_connectionTimeout = 3000;
    private static int default_readTimeout = 5000;
    private static String SCHEME_HTTPS = "https";

    private static HttpClient createHttpClient(int connectionTimeout, int readTimeout) {
        SystemDefaultHttpClient client = new SystemDefaultHttpClient();
        HttpParams httpParams = client.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimeout);
        return client;
    }

    public static HttpClient createHttpClient() {
        HttpClient client = HttpClientUtils.createHttpClient(3000, 5000);
        return client;
    }

    public static HttpClient wrapperHttpClient(HttpRequestBase httpUrl) {
        HttpClient httpClient = HttpClientUtils.createHttpClient();
        URI uri = httpUrl.getURI();
        if ("https".equalsIgnoreCase(uri.getScheme())) {
            if ((httpClient = HttpClientUtils.wrapperHttpClient(httpClient)) == null) {
                logger.error("failed to obtain the httpclient object in http state");
                return httpClient;
            }
            logger.info("success to obtain the httpclient object in http state");
        }
        return httpClient;
    }

    public static HttpClient wrapperHttpClient(HttpClient client) {
        if (client == null) {
            logger.debug("use default client when the client object is empty");
            client = HttpClientUtils.createHttpClient(default_connectionTimeout, default_readTimeout);
        }
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme(SCHEME_HTTPS, 443, (SchemeSocketFactory)ssf));
            ThreadSafeClientConnManager mgr = new ThreadSafeClientConnManager(registry);
            return new DefaultHttpClient((ClientConnectionManager)mgr, client.getParams());
        }
        catch (Exception ex) {
            logger.error("\u5305\u88c5\u65e0\u8bc1\u4e66\u6821\u9a8c\u5ba2\u6237\u7aef\u5931\u8d25:" + ex.getMessage());
            return null;
        }
    }

    public static HttpGet wrapperHttpGet(String url) {
        HttpGet httpGet = new HttpGet(url);
        String userAgent = RequestContext.get().getUserAgent();
        String sessionId = RequestContext.get().getGlobalSessionId();
        httpGet.setHeader("USER-AGENT", userAgent);
        httpGet.setHeader("Cookie", "KERPSESSIONID=" + sessionId);
        return httpGet;
    }

    public static String postjson(String url, Map<String, String> header, String json) throws IOException {
        String sHttpResponse = kd.bos.util.HttpClientUtils.postjson((String)url, header, (String)json);
        return sHttpResponse;
    }
}

