/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.agent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.gptas.agent.llm.AiAsyncChatModel;
import kd.bos.gptas.agent.llm.LocalAsyncChatModel;
import kd.bos.gptas.autoact.llm.ChatModel;
import kd.bos.gptas.autoact.llm.ChatModelFactory;
import kd.bos.login.utils.SystemPropertyUtils;
import kd.sdk.kingscript.config.ConfigurableItem;
import org.apache.commons.lang3.StringUtils;

public class AiChatModelFactory
implements ChatModelFactory {
    private static final Map<Long, AiAsyncChatModel> instances = new ConcurrentHashMap<Long, AiAsyncChatModel>();
    @ConfigurableItem(desc="GPT code generate Local enable")
    public static final String GPT_LOCAL_ENABLE = "gpt.local.enable";
    private static final long COMMON_PROMPT_ID = 1944994967177629696L;
    public static final String LOCAL_PROMPTNUMBER = "prompt-240415C02B7731";

    public ChatModel createDefaultModel() {
        return AiAsyncChatModel.builder().promptId(1944994967177629696L).build();
    }

    public ChatModel createModel(String chatModelName) {
        return this.buildChatModel(chatModelName);
    }

    private ChatModel buildChatModel(String chatModelName) {
        String isLocal = SystemPropertyUtils.getProptyByTenant((String)GPT_LOCAL_ENABLE, (String)String.valueOf(Boolean.FALSE));
        if (StringUtils.isNotBlank((CharSequence)isLocal) && "true".equals(isLocal)) {
            String promptNumber = this.getLocalPromptNumber();
            return LocalAsyncChatModel.builder().promptNumber(promptNumber).build();
        }
        long promptId = this.findPromptId(chatModelName);
        return AiChatModelFactory.getInstance(promptId);
    }

    private static AiAsyncChatModel getInstance(long promptId) {
        return instances.computeIfAbsent(promptId, AiAsyncChatModel::new);
    }

    private long findPromptId(String chatModelName) {
        boolean isPrompt = chatModelName.contains("prompt-");
        if (isPrompt) {
            String[] promptIds = chatModelName.split("prompt-");
            try {
                return Long.parseLong(promptIds[promptIds.length - 1]);
            }
            catch (Exception e) {
                return 1944994967177629696L;
            }
        }
        return 1944994967177629696L;
    }

    private String getLocalPromptNumber() {
        return LOCAL_PROMPTNUMBER;
    }
}

