/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.agent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.gptas.agent.AssistantConstants;
import kd.bos.gptas.agent.dao.AssistantDao;
import kd.bos.gptas.agent.dao.AssistantDaoImpl;
import kd.bos.gptas.agent.pojo.AssistantModel;
import kd.bos.gptas.agent.pojo.SkillModel;
import kd.bos.gptas.autoact.agent.AgentBuilder;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.autoact.agent.Agents;
import kd.bos.gptas.autoact.agent.reflect.AgentScanner;
import kd.bos.gptas.autoact.def.Agent;
import kd.bos.gptas.autoact.def.P;
import kd.bos.gptas.autoact.memory.ChatMemory;
import kd.bos.gptas.autoact.memory.EmptyChatMemory;
import kd.bos.gptas.autoact.message.MessageStream;
import kd.bos.gptas.autoact.model.Tool;
import kd.bos.gptas.km.pojo.CorpusLibs;
import kd.bos.gptas.km.service.SkillService;
import kd.bos.gptas.km.service.SkillServiceImpl;
import kd.bos.gptas.milvus.Chunk;
import kd.bos.gptas.milvus.MilvusDao;
import kd.bos.gptas.qa.QAUtil;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class AssistantBuilder
implements AssistantConstants {
    private AssistantDao assistantDao = new AssistantDaoImpl();
    private SkillService skillService = new SkillServiceImpl();
    private AssistantModel assistantModel;

    public static Assistant create(String assistantNumber, String chatSessionId) {
        return new AssistantBuilder().build(assistantNumber, chatSessionId);
    }

    private Assistant build(String assistantNumber, String chatSessionId) {
        this.loadAssistantModel(assistantNumber);
        Object skillInfo = this.loadSkillModel(this.getSkillNumber(this.assistantModel)).orElseThrow(() -> new RuntimeException("Skill not found"));
        List<String> knowledgeCodes = this.getKnowledgeCodes(this.assistantModel);
        AgentBuilder assistantBuilder = Agents.builder(Assistant.class);
        assistantBuilder.externalToolBuilder(this::loadSkillModel);
        assistantBuilder.agentAsTool(skillInfo);
        Assistant assistantAgent = (Assistant)assistantBuilder.build();
        this.configureAgentContext(assistantAgent, skillInfo, knowledgeCodes, chatSessionId);
        return assistantAgent;
    }

    private void loadAssistantModel(String assistantNumber) {
        this.assistantModel = Optional.ofNullable(this.assistantDao.search(assistantNumber)).filter(a -> a.getId() != null).orElseThrow(() -> new RuntimeException("Assistant not found: " + assistantNumber));
    }

    private List<String> getKnowledgeCodes(AssistantModel assistant) {
        return Optional.ofNullable(assistant.getLibs()).filter(CollectionUtils::isNotEmpty).map(libs -> libs.stream().map(CorpusLibs::getNumber).collect(Collectors.toList())).orElseGet(() -> new ArrayList(1));
    }

    private Optional<Object> loadSkillModel(String skillName) {
        SkillModel skill = this.skillService.getSkillByNum(skillName);
        JSONObject skillJson = this.parseSkillJson(skill);
        skillJson.put("llm", (Object)("prompt-" + this.assistantModel.getPromptId()));
        Class skillClass = AgentScanner.getAgentReflectInfo((String)skill.getApi()).getAgentClass();
        return Optional.of(Agents.builder((Class)skillClass).externalToolBuilder(this::loadSkillModel).refine((Map)skillJson).build());
    }

    private JSONObject parseSkillJson(SkillModel skill) {
        try {
            return JSON.parseObject((String)skill.getInputContent());
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid JSON format in skill: " + skill.getInputContent(), e);
        }
    }

    private String getSkillNumber(AssistantModel assistant) {
        return Optional.ofNullable(assistant.getEnabledSkills()).filter(CollectionUtils::isNotEmpty).map(skills -> ((SkillModel)skills.get(0)).getNumber()).orElseThrow(() -> new RuntimeException("No enabled skills for assistant: " + assistant.getName()));
    }

    private void configureAgentContext(Assistant assistantAgent, Object skillInfo, List<String> knowledgeCodes, String chatSessionId) {
        if (StringUtils.isBlank((CharSequence)chatSessionId)) {
            chatSessionId = ID.genStringId();
        }
        AgentContext agentContext = Agents.getAgentContext((Object)assistantAgent);
        Tool retrievalTool = agentContext.getTool("retrieval");
        retrievalTool.getProperties().put("knowledgeCodes", knowledgeCodes);
        retrievalTool.getProperties().put("chatSessionId", chatSessionId);
        String newSkillName = Agents.getAgentContext((Object)skillInfo).getAgent().getName();
        retrievalTool.getAfterActionTools().add(newSkillName);
        agentContext.setMemory((ChatMemory)EmptyChatMemory.INSTANCE);
    }

    private static class MilvusSearcher {
        private MilvusSearcher() {
        }

        public static List<Map<String, String>> searchMilvus(List<String> knowledgeCodes, String message, String chatSessionId) {
            if (CollectionUtils.isEmpty(knowledgeCodes)) {
                return new ArrayList<Map<String, String>>(0);
            }
            Map<Object, DynamicObject> corpusLibs = MilvusSearcher.fetchCorpusLibs(knowledgeCodes);
            Map<String, List<Long>> indexMethodGroups = MilvusSearcher.groupCorpusByIndexMethod(corpusLibs);
            List<Chunk> allChunks = indexMethodGroups.entrySet().stream().flatMap(entry -> {
                String indexMethod = (String)entry.getKey();
                List corpusIds = (List)entry.getValue();
                return MilvusSearcher.searchMilvusChunks(indexMethod, corpusIds, message, chatSessionId).stream();
            }).collect(Collectors.toList());
            return QAUtil.createKMPromptList(allChunks, false);
        }

        private static Map<Object, DynamicObject> fetchCorpusLibs(List<String> knowledgeCodes) {
            QFilter qFilter = new QFilter("number", "in", knowledgeCodes);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"corpus_libs");
            Map corpusLibs = BusinessDataReader.loadFromCache((DynamicObjectType)type, (QFilter[])new QFilter[]{qFilter});
            if (MapUtils.isEmpty((Map)corpusLibs)) {
                throw new RuntimeException("corpus_libs not found for: " + knowledgeCodes);
            }
            return corpusLibs;
        }

        private static Map<String, List<Long>> groupCorpusByIndexMethod(Map<Object, DynamicObject> corpusLibs) {
            return corpusLibs.values().stream().collect(Collectors.groupingBy(corpus -> corpus.getString("indexmethod"), Collectors.mapping(corpus -> corpus.getLong("id"), Collectors.toList())));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static List<Chunk> searchMilvusChunks(String indexMethod, List<Long> corpusIds, String message, String chatSessionId) {
            try (MilvusDao milvusDao = MilvusDao.createByKM(indexMethod);){
                List<Chunk> list = milvusDao.searchByChunks(corpusIds, new ArrayList<Long>(1), message, 5);
                return list;
            }
            catch (Exception ex) {
                throw new RuntimeException("Error searching Milvus chunks", ex);
            }
        }
    }

    @Agent(defaultTool="retrieval")
    public static interface Assistant {
        default public MessageStream call(String userInput) {
            return (MessageStream)Agents.callAgent((Object)this, (Object)userInput);
        }

        @kd.bos.gptas.autoact.def.Tool(name="retrieval")
        default public String retrieval(@P(value="knowledgeCodes") List<String> knowledgeCodes, @P(value="__input__") String message, @P(value="chatSessionId") String chatSessionId) {
            List<Map<String, String>> results = MilvusSearcher.searchMilvus(knowledgeCodes, message, chatSessionId);
            return JSON.toJSONString(results);
        }
    }
}

