/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.agent.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.gptas.agent.dao.AssistantDao;
import kd.bos.gptas.agent.pojo.AssistantModel;
import kd.bos.gptas.agent.pojo.SkillModel;
import kd.bos.gptas.km.pojo.CorpusLibs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;

public class AssistantDaoImpl
implements AssistantDao {
    private static final String ENTITY_ASSISTANT = "bos_corpus_assistant";
    private static final String ENTITY_SKILL = "bos_skillcorpus";

    @Override
    public AssistantModel search(String assistantNumber) {
        List<SkillModel> enableSkills;
        AssistantModel assistant = new AssistantModel();
        if (StringUtils.isBlank((CharSequence)assistantNumber)) {
            return assistant;
        }
        List<String> selectedFields = Arrays.asList("id", "name", "libs", "prompt", "des", "intention", "skillconfentry.skill", "skillconfentry.skillenable");
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)assistantNumber)};
        DynamicObject assistantObj = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_ASSISTANT, (String)String.join((CharSequence)",", selectedFields), (QFilter[])qFilters);
        if (null == assistantObj) {
            return assistant;
        }
        Long id = assistantObj.getLong("id");
        assistant.setId(id);
        assistant.setNumber(assistantNumber);
        String name = assistantObj.getString("name");
        assistant.setName(name);
        String promptValue = assistantObj.getString("prompt");
        Long promptId = 0L;
        if (StringUtils.isNotBlank((CharSequence)promptValue)) {
            promptId = Long.valueOf(promptValue);
        }
        assistant.setPromptId(promptId);
        String des = assistantObj.getString("des");
        assistant.setDes(des);
        String intention = assistantObj.getString("intention");
        assistant.setIntention(intention);
        List<CorpusLibs> libs = this.getLibsByAssistant(assistantObj);
        if (CollectionUtils.isNotEmpty(libs)) {
            assistant.setLibs(libs);
        }
        if (CollectionUtils.isNotEmpty(enableSkills = this.getEnableSkillByAssistant(assistantObj))) {
            assistant.setEnabledSkills(enableSkills);
        }
        return assistant;
    }

    private List<CorpusLibs> getLibsByAssistant(DynamicObject assistant) {
        DynamicObjectCollection libObjCol = assistant.getDynamicObjectCollection("libs");
        if (CollectionUtils.isEmpty((Collection)libObjCol)) {
            return new ArrayList<CorpusLibs>(0);
        }
        ArrayList<CorpusLibs> libs = new ArrayList<CorpusLibs>(libObjCol.size());
        for (DynamicObject libObj : libObjCol) {
            CorpusLibs lib = new CorpusLibs();
            if (null == libObj.get("fbasedataid")) continue;
            DynamicObject obj = libObj.getDynamicObject("fbasedataid");
            lib.setId(obj.getLong("id"));
            lib.setNumber(obj.getString("number"));
            lib.setName(obj.getString("name"));
            lib.setIndexMethod(obj.getString("indexmethod"));
            libs.add(lib);
        }
        return libs;
    }

    private List<SkillModel> getEnableSkillByAssistant(DynamicObject assistant) {
        DynamicObjectCollection skillConfs = assistant.getDynamicObjectCollection("skillconfentry");
        if (CollectionUtils.isEmpty((Collection)skillConfs)) {
            return new ArrayList<SkillModel>(0);
        }
        ArrayList<Long> enableSkillIds = new ArrayList<Long>(skillConfs.size());
        for (DynamicObject skillConf : skillConfs) {
            boolean skillEnable = skillConf.getBoolean("skillenable");
            if (!skillEnable) continue;
            Long skillId = skillConf.getLong("skill_id");
            enableSkillIds.add(skillId);
        }
        if (CollectionUtils.isEmpty(enableSkillIds)) {
            return new ArrayList<SkillModel>(0);
        }
        Map skillObjMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_SKILL, (String)"id,number,name,api,inputcontent_tag", (QFilter[])new QFilter[]{new QFilter("id", "in", enableSkillIds)});
        if (null == skillObjMap || skillObjMap.isEmpty()) {
            return new ArrayList<SkillModel>(0);
        }
        ArrayList<SkillModel> enableSkills = new ArrayList<SkillModel>(skillConfs.size());
        for (Map.Entry entry : skillObjMap.entrySet()) {
            SkillModel skill = new SkillModel();
            skill.setId((Long)entry.getKey());
            DynamicObject skillObj = (DynamicObject)entry.getValue();
            skill.setNumber(skillObj.getString("number"));
            skill.setName(skillObj.getString("name"));
            skill.setApi(skillObj.getString("api"));
            skill.setInputContent(skillObj.getString("inputcontent_tag"));
            enableSkills.add(skill);
        }
        return enableSkills;
    }
}

