/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.agent.llm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.gptas.agent.llm.AiChatModel;
import kd.bos.gptas.agent.llm.callback.ChatCallback;
import kd.bos.gptas.agent.llm.callback.ChatCallbackProxy;
import kd.bos.gptas.agent.llm.model.AiServiceResponse;
import kd.bos.gptas.autoact.message.AIMessage;
import kd.bos.gptas.autoact.message.ChatMessage;
import kd.bos.gptas.autoact.message.IterMessageStream;
import kd.bos.gptas.autoact.message.MessageStream;
import kd.bos.gptas.autoact.message.read.LineReader;
import kd.bos.gptas.autoact.output.Response;
import kd.bos.gptas.qa.QACache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class AiAsyncChatModel
extends AiChatModel {
    private static Log logger = LogFactory.getLog(AiAsyncChatModel.class);
    private static final String AI_PARAM_METHODNAME = "asyncCall";

    public AiAsyncChatModel(long promptId) {
        this.promptId = promptId;
    }

    @Override
    public String name() {
        return "ai-async";
    }

    @Override
    public Response<AIMessage> generate(List<ChatMessage> messages) {
        Map invokeResult = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)AI_PARAM_METHODNAME, (Object[])new Object[]{this.buildCallBackInfo(), true, this.promptId, this.toRequestString(messages), new HashMap(1)});
        logger.info(String.format("GaiPromptService \u8fd4\u56de\u7ed3\u679c\uff1a%s", invokeResult == null ? "" : SerializationUtils.toJsonString((Object)invokeResult)));
        AiServiceResponse aiServiceResponse = AiServiceResponse.convert(Objects.requireNonNull(invokeResult));
        String requestId = ID.genStringId();
        QACache qaCache = new QACache(requestId).save();
        qaCache.setTaskId(aiServiceResponse.getTaskId()).save();
        Function<String, String> resultConsumer = msg -> msg;
        ChatCallbackProxy lineReader = new ChatCallbackProxy(aiServiceResponse.getTaskId());
        return new Response((Object)new AIMessage((MessageStream)new IterMessageStream((LineReader)lineReader, (AutoCloseable)lineReader, resultConsumer)));
    }

    private Map<String, String> buildCallBackInfo() {
        HashMap<String, String> callBackInfo = new HashMap<String, String>();
        callBackInfo.put("cloudId", "bos");
        callBackInfo.put("appId", "bos");
        callBackInfo.put("serviceName", ChatCallback.class.getSimpleName());
        callBackInfo.put("methodName", "callBack");
        return callBackInfo;
    }
}

