/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.agent.llm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.devportal.script.npm.gpt.process.GPTResult;
import kd.bos.gptas.autoact.exception.ChatException;
import kd.bos.gptas.autoact.llm.ChatModel;
import kd.bos.gptas.autoact.message.AIMessage;
import kd.bos.gptas.autoact.message.ChatMessage;
import kd.bos.gptas.autoact.output.Response;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class AiChatModel
implements ChatModel {
    protected static final String AI_PARAM_CLOUDID = "ai";
    protected static final String AI_PARAM_APPID = "gai";
    protected static final String AI_PARAM_SERVICENAME = "GaiPromptService";
    private static final String AI_PARAM_METHODNAME = "syncCall";
    protected long promptId;

    public static ChatBuilder builder() {
        return new ChatBuilder<AiChatModel>(AiChatModel.class);
    }

    public String name() {
        return AI_PARAM_CLOUDID;
    }

    public Response<AIMessage> generate(List<ChatMessage> messages) {
        Map gptResult = (Map)DispatchServiceHelper.invokeBizService((String)AI_PARAM_CLOUDID, (String)AI_PARAM_APPID, (String)AI_PARAM_SERVICENAME, (String)AI_PARAM_METHODNAME, (Object[])new Object[]{this.promptId, this.toRequestString(messages), new HashMap(0)});
        GPTResult result = GPTResult.convertFromResult((Map)gptResult);
        if (!result.isStatus()) {
            throw new ChatException(result.getErrMsg() + "(task_id=" + result.getTaskId() + ")");
        }
        return new Response((Object)new AIMessage(result.getLlmValue()));
    }

    protected String toRequestString(List<ChatMessage> messages) {
        if (CollectionUtils.isEmpty(messages)) {
            return "";
        }
        return messages.stream().map(ChatMessage::getMessage).collect(Collectors.joining("\n\n"));
    }

    public static class ChatBuilder<T extends AiChatModel> {
        private long promptId;
        private Class<T> clazz;

        public ChatBuilder(Class<T> clazz) {
            this.clazz = clazz;
        }

        public AiChatModel build() {
            AiChatModel chat;
            try {
                chat = (AiChatModel)this.clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            chat.promptId = this.promptId;
            return chat;
        }

        public ChatBuilder promptId(long promptId) {
            this.promptId = promptId;
            return this;
        }
    }
}

