/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.agent.llm;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import kd.bos.gptas.agent.llm.LocalChatModel;
import kd.bos.gptas.agent.llm.callback.ChatCallback;
import kd.bos.gptas.agent.llm.callback.ChatCallbackProxy;
import kd.bos.gptas.agent.llm.model.AiResponse;
import kd.bos.gptas.autoact.exception.ChatException;
import kd.bos.gptas.autoact.message.AIMessage;
import kd.bos.gptas.autoact.message.ChatMessage;
import kd.bos.gptas.autoact.message.IterMessageStream;
import kd.bos.gptas.autoact.message.MessageStream;
import kd.bos.gptas.autoact.message.read.LineReader;
import kd.bos.gptas.autoact.monitor.Cost;
import kd.bos.gptas.autoact.output.Response;
import kd.bos.gptas.openapi.OpenApiClient;
import kd.bos.gptas.qa.QACache;
import kd.bos.service.ServiceFactory;
import kd.bos.threads.ThreadPools;

public class LocalAsyncChatModel
extends LocalChatModel {
    private static OpenApiClient openApiClient = OpenApiClient.builder().build();

    public static LocalChatModel.ChatBuilder builder() {
        return new LocalChatModel.ChatBuilder<LocalAsyncChatModel>(LocalAsyncChatModel.class);
    }

    @Override
    public String name() {
        return "local-async";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response<AIMessage> generate(List<ChatMessage> messages) {
        try (Cost ignored = Cost.trace((String)(this.getClass().getSimpleName() + ".generate"));){
            JsonObject jsonObject = openApiClient.requestPost("/kapi/v2/gai/prompt/syncCall", this.toRequestJsonString(messages));
            AiResponse aiResponse = AiResponse.convert(jsonObject);
            String taskId = UUID.randomUUID().toString().replaceAll("-", "");
            QACache qaCache = new QACache(aiResponse.getRequestId()).save();
            qaCache.setTaskId(taskId).save();
            this.callback(taskId, aiResponse.getData().getLlmValue());
            Function<String, String> resultConsumer = msg -> msg;
            ChatCallbackProxy lineReader = new ChatCallbackProxy(taskId);
            Response response = new Response((Object)new AIMessage((MessageStream)new IterMessageStream((LineReader)lineReader, (AutoCloseable)lineReader, resultConsumer)));
            return response;
        }
        catch (Exception e) {
            throw ChatException.asChatException((Throwable)e);
        }
    }

    private void callback(String taskId, String llmValue) {
        char[] llmchars = llmValue.toCharArray();
        ThreadPools.executeOnce((String)"agent_local_thread", () -> {
            for (int i = 0; i < llmchars.length; ++i) {
                char llmchar = llmchars[i];
                HashMap<String, Object> response = new HashMap<String, Object>();
                response.put("errMsg", "");
                response.put("status", true);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("taskId", taskId);
                data.put("isEnd", i >= llmchars.length - 1);
                data.put("llmValue", String.valueOf(llmchar));
                response.put("data", data);
                ChatCallback agentCallback = (ChatCallback)ServiceFactory.getService(ChatCallback.class);
                agentCallback.callBack(response);
            }
        });
    }
}

