/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.agent.llm;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.gptas.agent.llm.model.AiResponse;
import kd.bos.gptas.autoact.exception.ChatException;
import kd.bos.gptas.autoact.llm.ChatModel;
import kd.bos.gptas.autoact.message.AIMessage;
import kd.bos.gptas.autoact.message.ChatMessage;
import kd.bos.gptas.autoact.monitor.Cost;
import kd.bos.gptas.autoact.output.Response;
import kd.bos.gptas.autoact.util.JsonUtil;
import kd.bos.gptas.openapi.OpenApiClient;
import org.apache.commons.collections4.CollectionUtils;

public class LocalChatModel
implements ChatModel {
    private static OpenApiClient openApiClient = OpenApiClient.builder().build();
    protected String promptNumber;

    public static ChatBuilder builder() {
        return new ChatBuilder<LocalChatModel>(LocalChatModel.class);
    }

    public String name() {
        return "local";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response<AIMessage> generate(List<ChatMessage> messages) {
        try (Cost ignored = Cost.trace((String)(this.getClass().getSimpleName() + ".generate"));){
            JsonObject jsonObject = openApiClient.requestPost("/kapi/v2/gai/prompt/syncCall", this.toRequestJsonString(messages));
            AiResponse aiResponse = AiResponse.convert(jsonObject);
            Response response = new Response((Object)new AIMessage(aiResponse.getData().getLlmValue()));
            return response;
        }
        catch (Exception e) {
            throw ChatException.asChatException((Throwable)e);
        }
    }

    protected String toRequestJsonString(List<ChatMessage> messages) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("stream", Boolean.FALSE);
        ret.put("promptNumber", this.promptNumber);
        ret.put("varParams", new HashMap(1));
        String result = "";
        if (CollectionUtils.isNotEmpty(messages)) {
            result = messages.stream().map(ChatMessage::getMessage).collect(Collectors.joining("\n\n"));
        }
        ret.put("input", result);
        return JsonUtil.toJSONString(ret, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static class ChatBuilder<T extends LocalChatModel> {
        private String promptNumber = "prompt-240415C02B7731";
        private Class<T> clazz;

        public ChatBuilder(Class<T> clazz) {
            this.clazz = clazz;
        }

        public LocalChatModel build() {
            LocalChatModel chat;
            try {
                chat = (LocalChatModel)this.clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            chat.promptNumber = this.promptNumber;
            return chat;
        }

        public ChatBuilder promptNumber(String promptNumber) {
            this.promptNumber = promptNumber;
            return this;
        }
    }
}

