/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.agent.llm.callback;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.gptas.agent.llm.callback.ChatCallback;
import kd.bos.gptas.autoact.log.Logable;
import kd.bos.gptas.autoact.message.read.LineReader;
import kd.bos.gptas.qa.QACache;
import kd.bos.gptas.qa.model.LLMAPIMsg;
import kd.bos.gptas.qa.model.LLMData;
import kd.bos.gptas.qa.model.QAModel;

public class ChatCallbackProxy
implements ChatCallback,
LineReader,
AutoCloseable,
Logable {
    private static final int STREAM_WAIT_TIME = 300;
    private static final long TASK_MAX_TIME = 90000L;
    private String taskId;

    public ChatCallbackProxy() {
    }

    public ChatCallbackProxy(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public void callBack(Map<String, Object> response) {
        ProductHandler.handleLLMResponse(response);
    }

    public String read() {
        LLMAPIMsg llmapiMsg = ConsumeHandler.fetchLLMResponse(this.taskId);
        if (llmapiMsg == null || !llmapiMsg.isStatus() || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)llmapiMsg.getErrMsg())) {
            if (llmapiMsg != null) {
                logger.info("read error, errcode: {}, errmsg: {}", (Object)llmapiMsg.getErrCode(), (Object)llmapiMsg.getErrMsg());
            }
            return null;
        }
        return llmapiMsg.getData().getLlmValue();
    }

    @Override
    public void close() {
        QACache qaCache = QACache.getByTaskId(this.taskId);
        if (qaCache != null) {
            qaCache.release();
        }
    }

    private static String getTaskId(Map<String, Object> response) {
        Map dataMap;
        Object taskId;
        Object data = response.get("data");
        if (data != null && (taskId = (dataMap = (Map)data).get("taskId")) != null) {
            return taskId.toString();
        }
        return "";
    }

    private static boolean isEnd(LLMAPIMsg response) {
        LLMData data = response.getData();
        if (data != null) {
            return data.isEnd();
        }
        return false;
    }

    static class ConsumeHandler {
        ConsumeHandler() {
        }

        static LLMAPIMsg fetchLLMResponse(String taskId) {
            QACache qaCache = QACache.getByTaskId(taskId);
            if (qaCache == null) {
                Logable.logger.error("agent error, can't find qacache\u3002{}", (Object)taskId);
                return null;
            }
            long ts = System.currentTimeMillis();
            return ConsumeHandler.polling(qaCache, ts);
        }

        static LLMAPIMsg polling(QACache qaCache, long startTime) {
            qaCache.initReservedCharacters();
            LLMAPIMsg combine = null;
            do {
                if (qaCache.isStop()) {
                    return null;
                }
                String llmData = qaCache.popLLMData();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)llmData)) {
                    if (combine != null) {
                        qaCache.saveRef();
                        return combine;
                    }
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        Logable.logger.warn(e.getMessage());
                    }
                    continue;
                }
                LLMAPIMsg mapData = (LLMAPIMsg)JSON.parseObject((String)llmData, LLMAPIMsg.class);
                if (!mapData.isStatus()) {
                    qaCache.release();
                    return mapData;
                }
                mapData.getData().setLlmValue(qaCache.reservedLLMValue(mapData.getData().getLlmValue(), mapData.getData().isEnd()));
                if (combine == null) {
                    combine = mapData;
                } else {
                    combine.getData().setEnd(mapData.getData().isEnd());
                    combine.getData().concatLLMValue(mapData.getData().getLlmValue());
                    combine.setErrCode(mapData.getErrCode());
                    combine.setErrMsg(mapData.getErrMsg());
                    combine.setStatus(mapData.isStatus());
                }
                if (System.currentTimeMillis() - startTime < 300L && !ChatCallbackProxy.isEnd(mapData)) continue;
                qaCache.saveRef();
                if (ChatCallbackProxy.isEnd(mapData)) {
                    String[] ref = qaCache.getRef();
                    if (ref != null && ref.length > 0) {
                        ArrayList<Object> list = new ArrayList<Object>(16);
                        for (String s : ref) {
                            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                            list.add(Long.parseLong(s));
                        }
                        combine.getData().getRefFileList().addAll(QAModel.parseRefFileList(list, true));
                    }
                    qaCache.release();
                }
                return combine;
            } while (System.currentTimeMillis() - startTime <= 90000L);
            qaCache.release();
            Logable.logger.warn("LLM response polling timed out for task: {}. Max time of {} ms exceeded.", (Object)qaCache.getTaskId(), (Object)90000L);
            return null;
        }
    }

    static class ProductHandler {
        ProductHandler() {
        }

        static void handleLLMResponse(Map<String, Object> response) {
            String taskId = ChatCallbackProxy.getTaskId(response);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)taskId)) {
                Logable.logger.error("agent error, can't get taskid for callback\u3002{}", (Object)SerializationUtils.toJsonString(response));
                return;
            }
            QACache qaCache = QACache.getByTaskId(taskId);
            if (qaCache == null) {
                Logable.logger.error("agent error, can't find qacache for callback\u3002{}", (Object)taskId);
                return;
            }
            String llmValue = SerializationUtils.toJsonString(response);
            qaCache.pushLLMData(llmValue);
        }
    }
}

