/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.agent.llm.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import kd.bos.gptas.autoact.exception.ChatException;

public class AiResponse {
    private static final Gson GSON = new Gson();
    private Data data;
    private String requestId;
    private String errCode;
    private boolean status;

    public static AiResponse convert(JsonObject jsonObject) {
        try {
            int errCode = jsonObject.get("errCode").getAsInt();
            boolean status = jsonObject.get("status").getAsBoolean();
            if (errCode != 0 || !status) {
                throw new ChatException(jsonObject.get("message").getAsString() + "(error_code=" + errCode + ")");
            }
            return (AiResponse)GSON.fromJson((JsonElement)jsonObject, AiResponse.class);
        }
        catch (Exception e) {
            throw ChatException.asChatException((Throwable)e);
        }
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String toString() {
        return "Response{data=" + this.data + ", requestId='" + this.requestId + '\'' + ", errCode='" + this.errCode + '\'' + ", status=" + this.status + '}';
    }

    public static class Data {
        private String llmValue;
        private String referenceInfos;

        public String getLlmValue() {
            return this.llmValue;
        }

        public void setLlmValue(String llmValue) {
            this.llmValue = llmValue;
        }

        public String getReferenceInfos() {
            return this.referenceInfos;
        }

        public void setReferenceInfos(String referenceInfos) {
            this.referenceInfos = referenceInfos;
        }

        public String toString() {
            return "Data{llmValue='" + this.llmValue + '\'' + ", referenceInfos='" + this.referenceInfos + '\'' + '}';
        }
    }
}

