/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.agent.prompt;

import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.gptas.autoact.prompt.loader.PromptLoader;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.sdk.kingscript.config.ConfigurableItem;
import org.apache.commons.lang3.StringUtils;

public class DBPromptLoader
implements PromptLoader {
    @ConfigurableItem(desc="GPT code generate prompt from db enable")
    public static final String GPT_PROMPT_DB_ENABLE = "kingscript.gpt.prompt.db.enable";

    public String loadAlternative(String resourceName, String alternativeSuffix) {
        String promptDBEnable = SystemPropertyUtils.getProptyByTenant((String)GPT_PROMPT_DB_ENABLE, (String)String.valueOf(Boolean.TRUE));
        if (String.valueOf(Boolean.FALSE).equals(promptDBEnable)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            throw new RuntimeException("DBPromptLoader.loadAlternative error: Resource name is empty.");
        }
        int dotIndex = resourceName.lastIndexOf(".json");
        if (dotIndex == -1) {
            QFilter numberFilter = new QFilter("number", "=", (Object)resourceName);
            Optional<String> result = this.findResourceName(numberFilter);
            return result.orElseThrow(() -> new RuntimeException("DBPromptLoader.loadAlternative error: Resource name not found in the database."));
        }
        QFilter pathFilter = new QFilter("number", "=", (Object)resourceName);
        Optional<String> pathResult = this.findResourceName(pathFilter);
        return pathResult.orElse(null);
    }

    private Optional<String> findResourceName(QFilter qFilter) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_skillcorpus", (String)"number, name, inputcontent, inputcontent_tag", (QFilter[])qFilter.and(enableFilter).toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            String json = dynamicObjects[0].getString("inputcontent_tag");
            return Optional.of(json);
        }
        return Optional.empty();
    }
}

