/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.chat;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.gpt.api.DevAssistantService;
import kd.bos.gptas.autoact.message.MessageStream;
import kd.bos.gptas.chat.ChatAiUtils;
import kd.bos.gptas.chat.pojo.ChatMessage;
import kd.bos.gptas.chat.pojo.ChatType;
import kd.bos.gptas.qa.client.QAClient;
import kd.bos.gptas.qa.model.LLMAPIMsg;
import kd.bos.gptas.qa.model.LLMData;
import kd.bos.gptas.qa.model.RefFile;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ChatStreamThread
implements Runnable {
    private static final Log logger = LogFactory.getLog(ChatStreamThread.class);
    private final DevAssistantService devAssistantService = (DevAssistantService)ServiceFactory.getService(DevAssistantService.class);
    private IFormView rootView;
    private IFormView view;
    private CustomControl control;
    private String question;
    private String number;
    private String requestId;
    private String userType;
    private int clientType;
    private String chatSessionId;
    private String uid;
    private String assistant;

    public ChatStreamThread() {
    }

    public ChatStreamThread(IFormView rootView, IFormView view, CustomControl control) {
        this.rootView = rootView;
        this.view = view;
        this.control = control;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public int getClientType() {
        return this.clientType;
    }

    public void setClientType(int clientType) {
        this.clientType = clientType;
    }

    public String getChatSessionId() {
        return this.chatSessionId;
    }

    public void setChatSessionId(String chatSessionId) {
        this.chatSessionId = chatSessionId;
    }

    public IFormView getRootView() {
        return this.rootView;
    }

    public void setRootView(IFormView rootView) {
        this.rootView = rootView;
    }

    public IFormView getView() {
        return this.view;
    }

    public void setView(IFormView view) {
        this.view = view;
    }

    public CustomControl getControl() {
        return this.control;
    }

    public void setControl(CustomControl control) {
        this.control = control;
    }

    @Override
    public void run() {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("time", System.currentTimeMillis());
        if (StringUtils.isBlank((CharSequence)this.assistant) || "-1".equals(this.assistant)) {
            this.chatAnswer(dataMap);
            return;
        }
        this.devAssistantAnswer(dataMap);
    }

    private void chatAnswer(Map<String, Object> dataMap) {
        boolean end = false;
        String errorMsg = null;
        do {
            try {
                if (!ChatAiUtils.isChatting(this.requestId)) {
                    dataMap.put("stop", true);
                    this.control.setData(dataMap);
                    ChatStreamThread.sendFormActionByWS(this.rootView, this.view);
                    break;
                }
                LLMAPIMsg result = QAClient.create().qaPolling(this.question, this.number, this.requestId, this.clientType, this.userType, this.chatSessionId, 0, this.uid);
                if (!result.isStatus()) {
                    logger.info("chat_error===>" + result);
                    errorMsg = result.getErrMsg();
                    break;
                }
                LLMData value = result.getData();
                List<ChatMessage> messages = this.getChatMessages(value);
                end = value.isEnd();
                dataMap.put("messages", messages);
                dataMap.put("end", end);
                this.control.setData(dataMap);
                ChatStreamThread.sendFormActionByWS(this.rootView, this.view);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                errorMsg = e.getMessage();
                end = true;
            }
        } while (!end);
        if (errorMsg != null) {
            ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(2);
            ChatMessage chatMessage = new ChatMessage(ChatType.error, errorMsg);
            messages.add(chatMessage);
            dataMap.put("messages", messages);
            dataMap.put("end", end);
            this.control.setData(dataMap);
            ChatStreamThread.sendFormActionByWS(this.rootView, this.view);
        }
        ChatAiUtils.stopChat(this.requestId);
    }

    private List<ChatMessage> getChatMessages(LLMData value) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(4);
        ChatMessage chatMessage = new ChatMessage(this.requestId + "_robot", ChatType.markdown, value.getLlmValue());
        messages.add(chatMessage);
        List<RefFile> refFileList = value.getRefFileList();
        if (refFileList != null && !refFileList.isEmpty()) {
            for (RefFile refFile : refFileList) {
                ChatMessage message = new ChatMessage(ChatType.link, refFile.getName());
                message.setUrl(refFile.getUrl());
                message.setLinkId(refFile.getId());
                messages.add(message);
            }
        }
        return messages;
    }

    private void devAssistantAnswer(Map<String, Object> dataMap) {
        try {
            Object result = this.devAssistantService.process(this.assistant, this.question);
            if (result instanceof MessageStream) {
                LLMData llmData;
                MessageStream messageStream = (MessageStream)result;
                while (messageStream.hasNext()) {
                    if (!ChatAiUtils.isChatting(this.requestId)) {
                        dataMap.put("stop", true);
                        this.control.setData(dataMap);
                        ChatStreamThread.sendFormActionByWS(this.rootView, this.view);
                        break;
                    }
                    llmData = new LLMData();
                    llmData.setLlmValue((String)messageStream.next());
                    List<ChatMessage> chatMessages = this.getChatMessages(llmData);
                    dataMap.put("messages", chatMessages);
                    dataMap.put("end", false);
                    this.control.setData(dataMap);
                    ChatStreamThread.sendFormActionByWS(this.rootView, this.view);
                }
                llmData = new LLMData();
                llmData.setLlmValue("");
                dataMap.put("messages", this.getChatMessages(llmData));
                dataMap.put("end", true);
            } else {
                String llmValue = result.toString();
                LLMData llmData = new LLMData();
                llmData.setLlmValue(llmValue);
                List<ChatMessage> chatMessages = this.getChatMessages(llmData);
                dataMap.put("messages", chatMessages);
                dataMap.put("end", true);
            }
        }
        catch (Exception e) {
            ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(2);
            ChatMessage chatMessage = new ChatMessage(ChatType.error, e.getMessage());
            messages.add(chatMessage);
            dataMap.put("messages", messages);
            dataMap.put("end", true);
            logger.error((Throwable)e);
        }
        this.control.setData(dataMap);
        ChatStreamThread.sendFormActionByWS(this.rootView, this.view);
        ChatAiUtils.stopChat(this.requestId);
    }

    private static void sendFormActionByWS(IFormView rootView, IFormView formView) {
        rootView.sendFormAction(formView);
        PushMessage message = new PushMessage(PushMessageRange.RootPage, rootView.getPageId(), (Object)JSON.toJSONString((Object)rootView.getActionResult()));
        PushServiceHelper.push((PushMessage)message);
    }

    public ChatStreamThread buildQuestion(String question) {
        this.question = question;
        return this;
    }

    public ChatStreamThread buildNumber(String number) {
        this.number = number;
        return this;
    }

    public ChatStreamThread buildRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public ChatStreamThread buildUserType(String userType) {
        this.userType = userType;
        return this;
    }

    public ChatStreamThread buildClientType(int clientType) {
        this.clientType = clientType;
        return this;
    }

    public ChatStreamThread buildChatSessionId(String chatSessionId) {
        this.chatSessionId = chatSessionId;
        return this;
    }

    public ChatStreamThread buildAssistant(String assistant) {
        this.assistant = assistant;
        return this;
    }

    public void buildUid(String uid) {
        this.uid = uid;
    }
}

