/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.customcss;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.customcss.CustomCSSAction;
import kd.bos.gptas.homepage.FAQAction;
import kd.bos.gptas.qa.client.QAAction;
import kd.bos.mvc.SessionManager;

public class ActionTestFormPlugin
extends AbstractFormPlugin {
    private static final String FORM_META = "formmeta";
    private static final String ENTITY_META = "entitymeta";
    private static final String ITEMS = "Items";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"doaction", "docss", "dorefresh", "dostartfaq", "btnqa", "btnproperty"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equals("txtpageid")) {
            this.doRefreshComboList();
        }
    }

    private void doRefreshComboList() {
        String pageId = (String)this.getModel().getValue("txtpageid");
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        Map content = (Map)SerializationUtils.fromJsonString((String)formView.getPageCache().get("designer_content"), Map.class);
        Map formMeta = (Map)content.get(FORM_META);
        List items = (List)formMeta.get(ITEMS);
        ComboEdit txtitemlist = (ComboEdit)this.getControl("txtitemlist");
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(16);
        for (Object item : items) {
            Map map = (Map)item;
            String number = (String)map.get("Key");
            comboItemList.add(new ComboItem(new LocaleString(number), number));
        }
        txtitemlist.setComboItems(comboItemList);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        if ("doaction".equals(key)) {
            CustomCSSAction customCSSAction = new CustomCSSAction();
            String pageId = (String)this.getModel().getValue("txtpageid");
            String number = (String)this.getModel().getValue("txtitemlist");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", number);
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("number", SerializationUtils.toJsonString(map));
            Map<String, String> result = customCSSAction.invokeAction(pageId, "GETDOM", params);
            this.getModel().setValue("txtresult", (Object)SerializationUtils.toJsonString(result));
        } else if ("docss".equals(key)) {
            CustomCSSAction customCSSAction = new CustomCSSAction();
            String pageId = (String)this.getModel().getValue("txtpageid");
            String number = (String)this.getModel().getValue("txtitemlist");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("result", (String)this.getModel().getValue("css"));
            Map<String, String> result = customCSSAction.invokeAction(pageId, "SETCSS", params);
            this.getModel().setValue("txtresult", (Object)SerializationUtils.toJsonString(result));
        } else if ("dorefresh".equals(key)) {
            this.doRefreshComboList();
        } else if ("dostartfaq".equals(key)) {
            FAQAction action = new FAQAction();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("ROOT_PAGE_ID", (String)this.getModel().getValue("txtpageid"));
            Map<String, String> result = action.invokeAction("START_bos_qa", params);
            this.getModel().setValue("txtresult", (Object)SerializationUtils.toJsonString(result));
        } else if ("btnqa".equals(key)) {
            QAAction qaAction = new QAAction();
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("question", (String)this.getModel().getValue("txtanswer"));
            Map<String, String> result = qaAction.invokeAction("QA_DISP_cosmic_qa", params);
            String s = result.get("result");
            this.getView().openUrl(s);
        } else if ("btnproperty".equals(key)) {
            String pageId = (String)this.getModel().getValue("txtpageid");
            String number = (String)this.getModel().getValue("txtitemlist");
            IFormView formView = SessionManager.getCurrent().getView(pageId);
            FormDesigner formDesigner = (FormDesigner)formView.getControl("formdesigner");
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            Map<String, Object> itemMap = this.getItemByNumber(formView, number);
            if (itemMap != null) {
                param.put("itemId", itemMap.get("Id"));
            }
            param.put("propertyName", "Grow");
            param.put("metaType", FORM_META);
            param.put("value", "3");
            formDesigner.setProperty(param);
            this.getView().sendFormAction(formView);
        }
    }

    private Map<String, Object> getItemByNumber(IFormView desginerView, String number) {
        Map content = (Map)SerializationUtils.fromJsonString((String)desginerView.getPageCache().get("designer_content"), Map.class);
        Map formMeta = (Map)content.get(FORM_META);
        List items = (List)formMeta.get(ITEMS);
        for (Object item : items) {
            Map map = (Map)item;
            if (!map.get("Key").equals(number)) continue;
            return map;
        }
        return null;
    }
}

