/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.customcss;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.gpt.IGPTFormAction;
import kd.bos.gptas.utils.GPTActionUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;

public class CustomCSSAction
implements IGPTFormAction {
    private static final Log logger = LogFactory.getLog(CustomCSSAction.class);
    private static final String FORM_META = "formmeta";
    private static final String ENTITY_META = "entitymeta";
    private static final String ITEMS = "Items";
    private static final String ACTION_GETDOM = "GETDOM";
    private static final String ACTION_SETCSS = "SETCSS";

    public Map<String, String> invokeAction(String pageID, String action, Map<String, String> params) {
        IFormView formView = SessionManager.getCurrent().getView(pageID);
        if (formView == null) {
            logger.error("FormView not exits. pageID:{}", (Object)pageID);
            return null;
        }
        if (ACTION_GETDOM.equalsIgnoreCase(action)) {
            return this.getDomAction(params, formView);
        }
        if (ACTION_SETCSS.equalsIgnoreCase(action)) {
            return this.setCSSAction(params, formView);
        }
        return null;
    }

    private Map<String, String> setCSSAction(Map<String, String> params, IFormView formView) {
        JSONObject jsonObject = GPTActionUtil.parseObject(params.get("result"));
        String number = jsonObject.getString("number");
        String css = jsonObject.getString("css");
        Map content = (Map)SerializationUtils.fromJsonString((String)formView.getPageCache().get("current_metadata"), Map.class);
        String[] controlIds = null;
        if (params.containsKey("controlIds")) {
            controlIds = params.get("controlIds").split(",");
        }
        String[] f_controlIds = controlIds;
        Map formMeta = (Map)content.get(FORM_META);
        Map<String, Object> item = this.getItemByFilter(formMeta, map -> {
            if (f_controlIds != null && f_controlIds.length > 0) {
                String id = (String)map.get("Id");
                return id.equals(f_controlIds[0]);
            }
            String itemKey = (String)map.get("Key");
            return itemKey.equals(number);
        });
        HashMap<String, String> result = new HashMap<String, String>(2);
        if (item == null) {
            result.put("result", "number not exists\u3002");
            return result;
        }
        FormDesigner formDesigner = this.getFormDesigner(formView);
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("itemId", item.get("Id"));
        param.put("propertyName", "CustomeStyles");
        param.put("metaType", FORM_META);
        HashMap<String, Object> value = new HashMap<String, Object>(2);
        value.put("type", 0);
        value.put("content", css);
        String s = Base64.getEncoder().encodeToString(SerializationUtils.toJsonString(value).getBytes(StandardCharsets.UTF_8));
        param.put("value", s);
        formDesigner.setProperty(param);
        PushMessage message = new PushMessage(PushMessageRange.RootPage, formView.getPageId(), (Object)JSON.toJSONString((Object)formView.getActionResult()));
        PushServiceHelper.push((PushMessage)message);
        result.put("result", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u8bbe\u7f6e\u3002\u8bf7\u70b9\u4fdd\u5b58\uff0c\u9884\u89c8\u67e5\u770b\u6548\u679c\u3002", (String)"CustomCSSAction_0", (String)"bos-devportal-gptas", (Object[])new Object[0]));
        return result;
    }

    private FormDesigner getFormDesigner(IFormView formView) {
        FormDesigner formDesigner = (FormDesigner)formView.getControl("formdesigner");
        if (formDesigner == null) {
            formDesigner = (FormDesigner)formView.getControl("proformdesigner");
        }
        return formDesigner;
    }

    private Map<String, String> getDomAction(Map<String, String> params, IFormView formView) {
        String[] f_controlIds;
        Map<String, Object> item;
        String number;
        String json = params.get("number");
        if (params.containsKey("{") && params.containsKey("}")) {
            JSONObject jsonObject = GPTActionUtil.parseObject(json);
            number = jsonObject.getString("number");
        } else {
            number = "";
        }
        Map content = (Map)SerializationUtils.fromJsonString((String)formView.getPageCache().get("current_metadata"), Map.class);
        Map formMeta = (Map)content.get(FORM_META);
        String[] controlIds = null;
        if (params.containsKey("controlIds")) {
            controlIds = params.get("controlIds").split(",");
        }
        if ((item = this.getItemByFilter(formMeta, arg_0 -> CustomCSSAction.lambda$getDomAction$1(f_controlIds = controlIds, number, arg_0))) == null) {
            return null;
        }
        String type = (String)item.get("_Type_");
        if ("FieldAp".equals(type)) {
            String fieldId;
            Map entityMeta = (Map)content.get(ENTITY_META);
            item = this.getItemByFilter(entityMeta, arg_0 -> CustomCSSAction.lambda$getDomAction$2(fieldId = (String)item.get("FieldId"), arg_0));
            if (item == null) {
                return null;
            }
            type = (String)item.get("_Type_");
        }
        String dom = this.getDom(type, (String)formMeta.get("ModelType"));
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("result", dom);
        return result;
    }

    private Map<String, Object> getItemByFilter(Map<String, Object> meta, Function<Map<String, Object>, Boolean> filterFunc) {
        List items = (List)meta.get(ITEMS);
        for (Object item : items) {
            Map map = (Map)item;
            if (!filterFunc.apply(map).booleanValue()) continue;
            return map;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDom(String clsName, String modelType) {
        InputStream resourceAsStream = null;
        try {
            InputStreamReader inputStreamReader;
            resourceAsStream = CustomCSSAction.class.getResourceAsStream("/ElementDom/" + clsName + "Dom.html");
            if (resourceAsStream == null) {
                List<Class<?>> superClassList = this.getSuperClassList(modelType, clsName);
                for (Class<?> superClass : superClassList) {
                    resourceAsStream = CustomCSSAction.class.getResourceAsStream("/ElementDom/" + superClass.getSimpleName() + "Dom.html");
                    if (resourceAsStream == null) continue;
                    break;
                }
            }
            if (resourceAsStream != null) {
                String line;
                inputStreamReader = new InputStreamReader(Objects.requireNonNull(resourceAsStream));
                BufferedReader reader = new BufferedReader(inputStreamReader);
                StringBuilder txt = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    txt.append(line);
                }
                resourceAsStream.close();
                resourceAsStream = null;
                String string = txt.toString();
                return string;
            }
            inputStreamReader = null;
            return inputStreamReader;
        }
        catch (IOException ex) {
            logger.error((Throwable)ex);
            Iterator<Class<?>> iterator = null;
            return iterator;
        }
        finally {
            if (resourceAsStream != null) {
                try {
                    resourceAsStream.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    private List<Class<?>> getSuperClassList(String modelType, String clsName) {
        DomainModelType domainModelType = DomainModelTypeFactory.getDomainModelType((String)modelType, (boolean)false);
        ElementType elementType = domainModelType.getElementType(clsName);
        Class type = TypesContainer.getOrRegister((String)elementType.getClassName());
        ArrayList list = new ArrayList(16);
        for (Class superclass = type.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            list.add(superclass);
        }
        return list;
    }

    private static /* synthetic */ Boolean lambda$getDomAction$2(String fieldId, Map map) {
        String entityId = (String)map.get("Id");
        return entityId.equals(fieldId);
    }

    private static /* synthetic */ Boolean lambda$getDomAction$1(String[] f_controlIds, String number, Map map) {
        if (f_controlIds != null && f_controlIds.length > 0) {
            String id = (String)map.get("Id");
            return id.equals(f_controlIds[0]);
        }
        String itemKey = (String)map.get("Key");
        return itemKey.equals(number);
    }
}

