/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.dashboard;

import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.ListboxItem;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.BindingContext;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.service.KDDateUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DashBoardFormPlugin
extends AbstractFormPlugin
implements ItemClickListener,
ClickListener,
ListboxClickListener {
    private static final String BOS_DEVPORTAL_GPTAS = "bos-devportal-gptas";
    private static final String[] POINTLINE_TYPE = new String[]{"qa"};

    public void initialize() {
        Listbox usercountlistboxap = (Listbox)this.getControl("usercountlistbox");
        usercountlistboxap.addListboxClickListener((ListboxClickListener)this);
        Listbox questionvollistbox = (Listbox)this.getControl("questionvollistbox");
        questionvollistbox.addListboxClickListener((ListboxClickListener)this);
        Listbox webvisitlistbox = (Listbox)this.getControl("webvisitlistbox");
        webvisitlistbox.addListboxClickListener((ListboxClickListener)this);
        Listbox questionTrendListbox = (Listbox)this.getControl("questiontrendlistbox");
        questionTrendListbox.addListboxClickListener((ListboxClickListener)this);
        Listbox feedbacklistboxap = (Listbox)this.getControl("feedbacklistbox");
        feedbacklistboxap.addListboxClickListener((ListboxClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.bindUserCount(-1);
        this.bindQuestionVolumn(-1);
        this.bindQaTrend(-1);
        this.bindQaFeedBack(-1);
        this.bindDataGover();
        Listbox usercountlistbox = (Listbox)this.getControl("usercountlistbox");
        ArrayList<ListboxItem> usercountlistboxItems = new ArrayList<ListboxItem>();
        usercountlistboxItems.add(new ListboxItem("usercountday", ResManager.loadKDString((String)"\u4eca\u5929", (String)"DashBoardFormPlugin_0", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        usercountlistboxItems.add(new ListboxItem("usercountweek", ResManager.loadKDString((String)"\u672c\u5468", (String)"DashBoardFormPlugin_1", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        usercountlistboxItems.add(new ListboxItem("usercountmonth", ResManager.loadKDString((String)"\u672c\u6708", (String)"DashBoardFormPlugin_2", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        usercountlistbox.addItems(usercountlistboxItems);
        Listbox questionvollistbox = (Listbox)this.getControl("questionvollistbox");
        ArrayList<ListboxItem> questionvollistboxItems = new ArrayList<ListboxItem>();
        questionvollistboxItems.add(new ListboxItem("questionvolday", ResManager.loadKDString((String)"\u4eca\u5929", (String)"DashBoardFormPlugin_0", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        questionvollistboxItems.add(new ListboxItem("questionvolweek", ResManager.loadKDString((String)"\u672c\u5468", (String)"DashBoardFormPlugin_1", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        questionvollistboxItems.add(new ListboxItem("questionvolmonth", ResManager.loadKDString((String)"\u672c\u6708", (String)"DashBoardFormPlugin_2", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        questionvollistbox.addItems(questionvollistboxItems);
        Listbox webvisitlistbox = (Listbox)this.getControl("webvisitlistbox");
        ArrayList<ListboxItem> webvisitlistboxItems = new ArrayList<ListboxItem>();
        webvisitlistboxItems.add(new ListboxItem("webvisitday", ResManager.loadKDString((String)"\u4eca\u5929", (String)"DashBoardFormPlugin_0", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        webvisitlistboxItems.add(new ListboxItem("webvisitweek", ResManager.loadKDString((String)"\u672c\u5468", (String)"DashBoardFormPlugin_1", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        webvisitlistboxItems.add(new ListboxItem("webvisitmonth", ResManager.loadKDString((String)"\u672c\u6708", (String)"DashBoardFormPlugin_2", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        webvisitlistbox.addItems(webvisitlistboxItems);
        Listbox questiontrendlistbox = (Listbox)this.getControl("questiontrendlistbox");
        ArrayList<ListboxItem> questiontrendlistboxItems = new ArrayList<ListboxItem>();
        questiontrendlistboxItems.add(new ListboxItem("questiontrendday", ResManager.loadKDString((String)"\u4eca\u5929", (String)"DashBoardFormPlugin_0", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        questiontrendlistboxItems.add(new ListboxItem("questiontrendweek", ResManager.loadKDString((String)"\u672c\u5468", (String)"DashBoardFormPlugin_1", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        questiontrendlistboxItems.add(new ListboxItem("questiontrendmonth", ResManager.loadKDString((String)"\u672c\u6708", (String)"DashBoardFormPlugin_2", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        questiontrendlistbox.addItems(questiontrendlistboxItems);
        Listbox feedbacklistbox = (Listbox)this.getControl("feedbacklistbox");
        ArrayList<ListboxItem> feedbacklistboxItems = new ArrayList<ListboxItem>();
        feedbacklistboxItems.add(new ListboxItem("feedbackday", ResManager.loadKDString((String)"\u4eca\u5929", (String)"DashBoardFormPlugin_0", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        feedbacklistboxItems.add(new ListboxItem("feedbackweek", ResManager.loadKDString((String)"\u672c\u5468", (String)"DashBoardFormPlugin_1", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        feedbacklistboxItems.add(new ListboxItem("feedbackmonth", ResManager.loadKDString((String)"\u672c\u6708", (String)"DashBoardFormPlugin_2", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
        feedbacklistbox.addItems(feedbacklistboxItems);
        this.getView().updateView();
    }

    public void listboxClick(ListboxEvent event) {
        switch (event.getItemId()) {
            case "usercountday": {
                this.bindUserCount(-1);
                break;
            }
            case "usercountweek": {
                this.bindUserCount(-7);
                break;
            }
            case "usercountmonth": {
                this.bindUserCount(-30);
                break;
            }
            case "questionvolday": {
                this.bindQuestionVolumn(-1);
                break;
            }
            case "questionvolweek": {
                this.bindQuestionVolumn(-7);
                break;
            }
            case "questionvolmonth": {
                this.bindQuestionVolumn(-30);
                break;
            }
            case "questiontrendday": {
                this.bindQaTrend(-1);
                break;
            }
            case "questiontrendweek": {
                this.bindQaTrend(-7);
                break;
            }
            case "questiontrendmonth": {
                this.bindQaTrend(-30);
                break;
            }
            case "feedbackday": {
                this.bindQaFeedBack(-1);
                break;
            }
            case "feedbackweek": {
                this.bindQaFeedBack(-7);
                break;
            }
            case "feedbackmonth": {
                this.bindQaFeedBack(-30);
            }
        }
    }

    private void bindUserCount(int day) {
        String sql = "SELECT count(DISTINCT(fusername)) FROM t_qa_userbehavior WHERE fopdate >= ?  AND fopdate <= ? GROUP BY fusername";
        Object[] params = new SqlParameter[]{new SqlParameter(":fopdate", 93, (Object)DashBoardFormPlugin.getStartTime(day)), new SqlParameter(":fopdate", 93, (Object)DashBoardFormPlugin.getEndTime(day))};
        long userCount = (Long)DB.query((DBRoute)DBRoute.of((String)"log"), (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                long user = 0L;
                while (rs.next()) {
                    user += (long)rs.getInt(1);
                }
                return user;
            }
        });
        Label userCountLabel = (Label)this.getControl("usercount");
        userCountLabel.setText(String.valueOf(userCount));
        this.getView().updateView("usercount");
    }

    private void bindQuestionVolumn(int day) {
        Map<String, Integer> questionVolumn = this.getQuestionVolumn(day);
        this.bindQuestionVolumnChart(questionVolumn);
    }

    private Map<String, Integer> getQuestionVolumn(int day) {
        String sql = "select count(fusertype) num,fusertype  FROM t_qa_userbehavior  where fopdate >= ? AND fopdate <= ?  and fusertype in (?,?,?,?,?,?,?,?,?) group by fusertype";
        Object[] params = new SqlParameter[]{new SqlParameter(":fopdate", 93, (Object)DashBoardFormPlugin.getStartTime(day)), new SqlParameter(":fopdate", 93, (Object)DashBoardFormPlugin.getEndTime(day)), new SqlParameter(":fusertype", 12, (Object)"1"), new SqlParameter(":fusertype", 12, (Object)"2"), new SqlParameter(":fusertype", 12, (Object)"3"), new SqlParameter(":fusertype", 12, (Object)"4"), new SqlParameter(":fusertype", 12, (Object)"5"), new SqlParameter(":fusertype", 12, (Object)"6"), new SqlParameter(":fusertype", 12, (Object)"7"), new SqlParameter(":fusertype", 12, (Object)"8"), new SqlParameter(":fusertype", 12, (Object)"9")};
        return (Map)DB.query((DBRoute)DBRoute.of((String)"log"), (String)sql, (Object[])params, resultSet -> {
            HashMap<String, Integer> ret = new HashMap<String, Integer>(8);
            while (resultSet.next()) {
                String usertype = resultSet.getString("fusertype");
                int num = resultSet.getInt("num");
                ret.put(usertype, num);
            }
            return ret;
        });
    }

    private void bindQuestionVolumnChart(Map<String, Integer> result) {
        PieChart chart = (PieChart)this.getControl("questionvolumn");
        PieSeries series = chart.createSeries(ResManager.loadKDString((String)"\u7528\u6237", (String)"DashBoardFormPlugin_3", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]));
        long totalNum = 0L;
        for (Map.Entry<String, Integer> entry : result.entrySet()) {
            int value = entry.getValue();
            totalNum += (long)value;
            String status = entry.getKey();
            String color = this.getQaVolumnColor(status);
            String name = DashBoardFormPlugin.getStatusName(status);
            ItemValue itemValue = new ItemValue(name, (Number)value);
            if (!StringUtils.isEmpty((CharSequence)color)) {
                itemValue.setColor(color);
            }
            series.addData(itemValue);
        }
        chart.bindData(null);
        series.setRadius("50", "70");
        chart.setShowLegend(true);
        chart.setLegendAlign(XAlign.right, YAlign.center);
        chart.setLegendVertical(true);
        chart.setShowTooltip(true);
        chart.setTitleAlign(XAlign.center, YAlign.center);
        chart.setName(new LocaleString(String.valueOf(totalNum)));
        this.getView().updateView("questionvolumn");
    }

    private void setTotalUser() {
        long totalUserCount = 0L;
        String sql = "SELECT count(DISTINCT(fip)) FROM t_qa_userbehavior GROUP BY fip";
        totalUserCount = (Long)DB.query((DBRoute)DBRoute.of((String)"log"), (String)sql, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                long userCount = 0L;
                while (rs.next()) {
                    userCount += (long)rs.getInt(1);
                }
                return userCount;
            }
        });
        this.getModel().setValue("totaluser", (Object)totalUserCount);
    }

    private void setDailyVisitCount() {
        long visitCount = 0L;
        LocalDate currentDate = LocalDate.now();
        LocalDateTime startTime = currentDate.atStartOfDay();
        LocalDateTime endTime = currentDate.atTime(LocalTime.MAX);
        String sql = String.format("SELECT count(1) FROM t_qa_userbehavior WHERE fopdate >= '%s'  AND fopdate <= '%s'", startTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), endTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        visitCount = ((Integer)DB.query((DBRoute)DBRoute.of((String)"log"), (String)sql, rs -> {
            if (rs.next()) {
                return rs.getInt(1);
            }
            return 0;
        })).intValue();
        this.getModel().setValue("dailyvisit", (Object)visitCount);
    }

    private String getQaVolumnColor(String status) {
        String color;
        switch (status) {
            case "1": {
                color = "#2391FF";
                break;
            }
            case "2": {
                color = "#05C985";
                break;
            }
            case "3": {
                color = "#FFC328";
                break;
            }
            case "4": {
                color = " #F88D48";
                break;
            }
            case "5": {
                color = "#F35352";
                break;
            }
            case "6": {
                color = "#8954D4";
                break;
            }
            case "7": {
                color = "#CE62D6";
                break;
            }
            case "C": 
            case "8": {
                color = "#9BCC66";
                break;
            }
            case "9": {
                color = "#5156B8";
                break;
            }
            default: {
                color = "#e5e5e5";
            }
        }
        return color;
    }

    public static String getStatusName(String status) {
        String statusName;
        switch (status) {
            case "1": {
                statusName = ResManager.loadKDString((String)"\u91d1\u8776\u5ba2\u6237", (String)"DashBoardFormPlugin_11", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
                break;
            }
            case "2": {
                statusName = ResManager.loadKDString((String)"\u91d1\u8776\u96c6\u56e2", (String)"DashBoardFormPlugin_12", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
                break;
            }
            case "3": {
                statusName = ResManager.loadKDString((String)"\u4ea4\u4ed8\u4f19\u4f34", (String)"DashBoardFormPlugin_13", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
                break;
            }
            case "4": {
                statusName = ResManager.loadKDString((String)"\u91d1\u8776\u4f19\u4f34", (String)"DashBoardFormPlugin_14", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
                break;
            }
            case "5": {
                statusName = ResManager.loadKDString((String)"ISV\u4f19\u4f34", (String)"DashBoardFormPlugin_15", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
                break;
            }
            case "6": {
                statusName = ResManager.loadKDString((String)"\u5176\u4ed6\u4f19\u4f34", (String)"DashBoardFormPlugin_16", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
                break;
            }
            case "7": {
                statusName = ResManager.loadKDString((String)"\u9662\u6821\u4eba\u5458", (String)"DashBoardFormPlugin_17", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
                break;
            }
            case "8": {
                statusName = ResManager.loadKDString((String)"\u4f01\u4e1a\u4eba\u5458", (String)"DashBoardFormPlugin_18", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
                break;
            }
            case "9": {
                statusName = ResManager.loadKDString((String)"\u5176\u4ed6\u4eba\u5458", (String)"DashBoardFormPlugin_19", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
                break;
            }
            case "C": {
                statusName = ResManager.loadKDString((String)"\u5df2\u89e3\u51b3", (String)"DashBoardFormPlugin_20", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
                break;
            }
            default: {
                statusName = ResManager.loadKDString((String)"\u672a\u89e3\u51b3", (String)"DashBoardFormPlugin_21", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
            }
        }
        return statusName;
    }

    private void bindQaTrend(int day) {
        int i;
        Map<String, Map<Integer, Integer>> map;
        int xendIndex;
        int xstartIndex;
        String xSuffix;
        ArrayList<String> xData = new ArrayList<String>(8);
        HashMap<String, List<Number>> yDatas = new HashMap<String, List<Number>>(8);
        int days = 0;
        Map<String, Map<Integer, Integer>> todayMap = DashBoardFormPlugin.getPointLineTypeNum(day);
        if (day == -7 || day == -30) {
            xSuffix = ResManager.loadKDString((String)"\u65e5", (String)"DashBoardFormPlugin_30", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
            Date startTime = DashBoardFormPlugin.getStartTime(day);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startTime);
            xstartIndex = calendar.get(5);
            days = calendar.getActualMaximum(5);
            calendar.setTime(new Date());
            xendIndex = calendar.get(5);
            map = DashBoardFormPlugin.getPointLineTypeNum(day);
            if (xendIndex < xstartIndex) {
                for (i = xstartIndex; i <= days; ++i) {
                    xData.add(i + xSuffix);
                }
                for (i = 1; i <= xendIndex; ++i) {
                    xData.add(i + xSuffix);
                }
            } else {
                for (i = xstartIndex; i <= xendIndex; ++i) {
                    xData.add(i + xSuffix);
                }
            }
        } else {
            xSuffix = "h";
            map = todayMap;
            Calendar calendar = Calendar.getInstance();
            int hourNow = calendar.get(11);
            xstartIndex = 0;
            xendIndex = hourNow;
            for (String ponitLineType : POINTLINE_TYPE) {
                Map<Integer, Integer> numMap = map.get(ponitLineType);
                ArrayList<Integer> yList = new ArrayList<Integer>(24);
                for (int i2 = 0; i2 <= hourNow; ++i2) {
                    Integer num;
                    Integer n = num = numMap == null ? null : numMap.get(i2);
                    if (num == null) {
                        num = 0;
                    }
                    yList.add(num);
                }
                yDatas.put(ponitLineType, yList);
            }
            for (i = xstartIndex; i <= xendIndex; ++i) {
                xData.add(i + xSuffix);
            }
        }
        for (String pointLineType : POINTLINE_TYPE) {
            Integer num;
            int i3;
            Map<Integer, Integer> numMap = map.get(pointLineType);
            ArrayList<Integer> yList = new ArrayList<Integer>(24);
            if (xendIndex < xstartIndex) {
                for (i3 = xstartIndex; i3 <= days; ++i3) {
                    Integer n = num = numMap == null ? null : numMap.get(i3);
                    if (num == null) {
                        num = 0;
                    }
                    yList.add(num);
                }
                for (i3 = 1; i3 <= xendIndex; ++i3) {
                    Integer n = num = numMap == null ? null : numMap.get(i3);
                    if (num == null) {
                        num = 0;
                    }
                    yList.add(num);
                }
            } else {
                for (i3 = xstartIndex; i3 <= xendIndex; ++i3) {
                    Integer n = num = numMap == null ? null : numMap.get(i3);
                    if (num == null) {
                        num = 0;
                    }
                    yList.add(num);
                }
            }
            yDatas.put(pointLineType, yList);
        }
        this.bindQaTrendNumberChart(xData, yDatas);
    }

    private void bindQaTrendNumberChart(List<String> xData, Map<String, List<Number>> yDatas) {
        PointLineChart chart = (PointLineChart)this.getControl("qatrendpointline");
        Axis xAxis = chart.createXAxis(ResManager.loadKDString((String)"x\u8f74", (String)"DashBoardFormPlugin_31", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), AxisType.category);
        xAxis.setCategorys(xData);
        Axis yaxis = chart.createYAxis(ResManager.loadKDString((String)"\u63d0\u95ee\u6570", (String)"DashBoardFormPlugin_32", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), AxisType.value);
        HashMap<String, Object[]> nameTextStyle = new HashMap<String, Object[]>(4);
        nameTextStyle.put("padding", new Object[]{3, 4, 5, 100});
        yaxis.setPropValue("nameTextStyle", nameTextStyle);
        for (Map.Entry<String, List<Number>> entry : yDatas.entrySet()) {
            String pointLineType = entry.getKey();
            LineSeries series = chart.createSeries(this.getPointLineTypeName(pointLineType));
            series.setData(entry.getValue().toArray(new Number[0]));
            series.setColor(this.getColorByPointLineType(pointLineType));
            series.setLineColor(this.getColorByPointLineType(pointLineType));
            series.setItemColor(this.getColorByPointLineType(pointLineType));
        }
        chart.setShowLegend(true);
        chart.setShowTooltip(true);
        chart.setShowTitle(true);
        chart.bindData((BindingContext)null);
    }

    private void bindQaFeedBack(int day) {
        Map<String, Integer> feedBackMap = this.getQaFeedBackNum(day);
        Integer like = feedBackMap.get("B");
        Label liekLabel = (Label)this.getControl("like");
        if (like != null) {
            liekLabel.setText(String.valueOf(like));
        } else {
            liekLabel.setText(String.valueOf(0));
        }
        Integer tap = feedBackMap.get("C");
        Label tapLabel = (Label)this.getControl("tap");
        if (tap != null) {
            tapLabel.setText(String.valueOf(tap));
        } else {
            tapLabel.setText(String.valueOf(0));
        }
        Integer notMatch = feedBackMap.get("A");
        Label notmatchLabel = (Label)this.getControl("notmatch");
        if (notMatch != null) {
            notmatchLabel.setText(String.valueOf(notMatch));
        } else {
            notmatchLabel.setText(String.valueOf(0));
        }
        this.getView().updateView("like");
        this.getView().updateView("tap");
        this.getView().updateView("notmatch");
    }

    private Map<String, Integer> getQaFeedBackNum(int day) {
        String sql = "select count(ftype) num, ftype  FROM t_knl_qaresult  where fcreatetime >= ? AND fcreatetime <= ? group by ftype";
        Object[] params = new SqlParameter[]{new SqlParameter(":fcreatetime", 93, (Object)DashBoardFormPlugin.getStartTime(day)), new SqlParameter(":fcreatetime", 93, (Object)DashBoardFormPlugin.getEndTime(day))};
        return (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params, resultSet -> {
            HashMap<String, Integer> ret = new HashMap<String, Integer>(8);
            while (resultSet.next()) {
                String type = resultSet.getString("ftype");
                int num = resultSet.getInt("num");
                ret.put(type, num);
            }
            return ret;
        });
    }

    private String getPointLineTypeName(String pointLine) {
        String str = "";
        if ("qa".equals(pointLine)) {
            str = ResManager.loadKDString((String)"\u63d0\u95ee\u91cf", (String)"DashBoardFormPlugin_33", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
        }
        return str;
    }

    private String getColorByPointLineType(String pointLineType) {
        String color = "#73d13d";
        if ("qa".equals(pointLineType)) {
            color = "#1890FF";
        }
        return color;
    }

    public static Map<String, Map<Integer, Integer>> getPointLineTypeNum(int day) {
        HashMap<String, Map<Integer, Integer>> result = new HashMap<String, Map<Integer, Integer>>(8);
        for (String pointLineType : POINTLINE_TYPE) {
            Map<Integer, Integer> map = DashBoardFormPlugin.getQuestionCount(day);
            result.put(pointLineType, map);
        }
        return result;
    }

    private void bindDataGover() {
        Map<String, Integer> statusMap = this.getGoverData();
        this.bindDataGoverChart(statusMap);
    }

    private void bindDataGoverChart(Map<String, Integer> result) {
        PieChart chart = (PieChart)this.getControl("datagover");
        PieSeries series = chart.createSeries(ResManager.loadKDString((String)"\u6570\u636e\u6cbb\u7406", (String)"DashBoardFormPlugin_34", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]));
        long totalNum = 0L;
        float handledNum = 0.0f;
        for (Map.Entry<String, Integer> entry : result.entrySet()) {
            int value = entry.getValue();
            totalNum += (long)value;
            String status = entry.getKey();
            if ("C".equals(status)) {
                handledNum += (float)value;
            }
            String color = this.getQaVolumnColor(status);
            String name = DashBoardFormPlugin.getStatusName(status);
            ItemValue itemValue = new ItemValue(name, (Number)value);
            if (!StringUtils.isEmpty((CharSequence)color)) {
                itemValue.setColor(color);
            }
            series.addData(itemValue);
        }
        chart.bindData(null);
        series.setRadius("50", "70");
        chart.setShowLegend(true);
        chart.setLegendAlign(XAlign.right, YAlign.center);
        chart.setLegendVertical(true);
        chart.setShowTooltip(true);
        chart.setTitleAlign(XAlign.center, YAlign.center);
        chart.setName(new LocaleString(String.format(ResManager.loadKDString((String)"\u5df2\u89e3\u51b3%.0f%%", (String)"DashBoardFormPlugin_22", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), Float.valueOf(handledNum * 100.0f / (float)totalNum))));
        this.getView().updateView("datagover");
    }

    private Map<String, Integer> getGoverData() {
        String sql = "SELECT count(fbillstatus) num,fbillstatus FROM t_knl_qaresult WHERE ftype IN ('A','C') GROUP BY fbillstatus";
        SqlParameter[] params = new SqlParameter[]{};
        return (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, null, resultSet -> {
            HashMap<String, Integer> ret = new HashMap<String, Integer>(8);
            while (resultSet.next()) {
                String billstatus = resultSet.getString("fbillstatus");
                int num = resultSet.getInt("num");
                ret.put(billstatus, num);
            }
            return ret;
        });
    }

    private static int getNowHour() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(11);
    }

    private static int getNowDayOfWeek() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(7);
    }

    private static int getNowDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(5);
    }

    private static Map<Integer, Integer> getQuestionCount(int day) {
        String sql = "select fopdate  FROM t_qa_userbehavior  where fopdate >= ? AND fopdate <= ? AND fopname <> 'qaFeedback'";
        Object[] params = new SqlParameter[]{new SqlParameter(":fopdate", 93, (Object)DashBoardFormPlugin.getStartTime(day)), new SqlParameter(":fopdate", 93, (Object)DashBoardFormPlugin.getEndTime(day))};
        return (Map)DB.query((DBRoute)DBRoute.of((String)"log"), (String)sql, (Object[])params, resultSet -> {
            HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>(8);
            int value = day == -1 ? DashBoardFormPlugin.getNowHour() : DashBoardFormPlugin.getNowDayOfMonth();
            for (int i = 0; i <= value; ++i) {
                if (day != -1 && i == 0) continue;
                ret.put(i, 0);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            while (resultSet.next()) {
                String opdate = resultSet.getString("fopdate");
                Date rqDate = simpleDateFormat.parse(opdate);
                int index = day == -1 ? rqDate.getHours() : rqDate.getDate();
                ret.compute(index, (k, num) -> num + 1);
            }
            return ret;
        });
    }

    private static Date getStartTime(int day) {
        if (day == -1) {
            return DateUtils.addDays((Date)DashBoardFormPlugin.getBaseToday(), (int)0);
        }
        return day == -7 ? KDDateUtils.getTheWeekStart((int)0, (Date)DashBoardFormPlugin.getBaseToday(), (int)2) : KDDateUtils.getTheMonthStart((int)0, (Date)DashBoardFormPlugin.getBaseToday());
    }

    private static Date getEndTime(int day) {
        if (day == -1) {
            return DateUtils.addDays((Date)DashBoardFormPlugin.getBaseToday(), (int)1);
        }
        return day == -7 ? KDDateUtils.getTheWeekEnd((int)0, (Date)DashBoardFormPlugin.getBaseToday(), (int)2) : KDDateUtils.getTheMonthEnd((int)0, (Date)DashBoardFormPlugin.getBaseToday());
    }

    private static Date getBaseToday() {
        return DateUtils.truncate((Date)new Date(), (int)5);
    }
}

