/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.embed;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.metadata.domainmodel.Category;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BatchEmbedConfigFormPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
TreeNodeCheckListener,
F7SelectedListRemoveListener {
    public static final String TREEKEY = "treeviewap";
    private static final String KEY_ALL_FIELDTREE = "All_FieldTree";
    private static final String F7SELECTEDLISTAP = "f7selectedlistap";
    private static final String KEY_CHECKNODES = "checkNodes";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "groupname"});
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(F7SELECTEDLISTAP);
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        TreeView tree = (TreeView)this.getView().getControl(TREEKEY);
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        Search search = (Search)this.getView().getControl("search");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initTreeView("");
    }

    private void initTreeView(String searchText) {
        TreeView trans = (TreeView)this.getView().getControl(TREEKEY);
        TreeNode root = new TreeNode();
        root.setId("0");
        root.setText("root");
        root.setIsOpened(true);
        HashSet<String> checkNodes = new HashSet<String>(this.getCheckNodes());
        ArrayList<TreeNode> checkTreeNodes = new ArrayList<TreeNode>(16);
        for (Category category : DomainModelType.getDomainModelType((String)"BillFormModel").getCategories()) {
            TreeNode categoryNode = new TreeNode();
            categoryNode.setId(category.getId());
            categoryNode.setText(category.getName().toString());
            if (checkNodes.contains(categoryNode.getId())) {
                checkTreeNodes.add(categoryNode);
            }
            for (ElementType elementType : category.getElementTypes()) {
                if (elementType.getName() == null) continue;
                TreeNode elementNode = new TreeNode();
                elementNode.setId(elementType.getId());
                elementNode.setText(this.concat(elementType.getId(), elementType.getName()).toString());
                if (!elementNode.getText().contains(searchText)) continue;
                if (checkNodes.contains(elementNode.getId())) {
                    checkTreeNodes.add(elementNode);
                }
                categoryNode.addChild(elementNode);
            }
            if (categoryNode.getChildren() == null) continue;
            root.addChild(categoryNode);
        }
        trans.deleteAllNodes();
        trans.addNode(root);
        trans.checkNodes(checkTreeNodes);
        if (searchText.equals("")) {
            this.getView().getPageCache().put(KEY_ALL_FIELDTREE, SerializationUtils.toJsonString((Object)root));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals("btnok")) {
            this.doSave();
        } else if (control.getKey().equals("groupname")) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"gai_process_group", (boolean)false);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectgroup"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection rows;
        if (evt.getActionId().equals("selectgroup") && (rows = (ListSelectedRowCollection)evt.getReturnData()) != null && !rows.isEmpty()) {
            ListSelectedRow listSelectedRow = rows.get(0);
            this.getModel().setValue("groupname", (Object)listSelectedRow.getName());
            this.getModel().setValue("groupid", listSelectedRow.getPrimaryKeyValue());
        }
    }

    private LocaleString concat(String v, LocaleString s) {
        LocaleString n = new LocaleString();
        for (Map.Entry kv : s.entrySet()) {
            n.put((String)kv.getKey(), (Object)((String)kv.getValue() + "(" + v + ")"));
        }
        return n;
    }

    private List<String> getCheckNodes() {
        if (this.getView().getPageCache().get(KEY_CHECKNODES) == null) {
            return new ArrayList<String>(16);
        }
        return (List)SerializationUtils.fromJsonString((String)this.getView().getPageCache().get(KEY_CHECKNODES), List.class);
    }

    private void doSave() {
        List<String> checkNodes = this.getCheckNodes();
        if (checkNodes == null || checkNodes.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u63a7\u4ef6\u3002", (String)"BatchEmbedConfigFormPlugin_0", (String)"bos-devportal-gptas", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] rows = new DynamicObject[checkNodes.size()];
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_emedctlconfig");
        int i = 0;
        Map allRows = BusinessDataReader.loadFromCache((DynamicObjectType)type, (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)0)});
        ArrayList pks = new ArrayList(16);
        for (String selectData : checkNodes) {
            DynamicObject row = new DynamicObject((DynamicObjectType)type);
            row.set("type", (Object)selectData);
            row.set("groupid", this.getModel().getValue("groupid"));
            row.set("groupname", this.getModel().getValue("groupname"));
            row.set("isonly", this.getModel().getValue("isonly"));
            row.set("isentry", this.getModel().getValue("isentry"));
            rows[i++] = row;
            for (Map.Entry kv : allRows.entrySet()) {
                DynamicObject oldData = (DynamicObject)kv.getValue();
                if (!oldData.getString("groupid").equals(row.getString("groupid")) || !oldData.getString("type").equals(row.getString("type")) || oldData.getBoolean("isentry") != row.getBoolean("isentry")) continue;
                pks.add(kv.getKey());
            }
        }
        DeleteServiceHelper.delete((IDataEntityType)type, (Object[])pks.toArray());
        SaveServiceHelper.save((DynamicObject[])rows);
        this.getView().close();
    }

    public void search(SearchEnterEvent evt) {
        String text = evt.getText();
        this.initTreeView(text);
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        F7SelectedList f7SelectedList;
        TreeView tree = (TreeView)this.getView().getControl(TREEKEY);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_ALL_FIELDTREE), TreeNode.class);
        List<String> checkNodeIds = this.getCheckNodes();
        List currChecks = tree.getTreeState().getCheckedNodeIds();
        for (Object currCheck : currChecks) {
            if (checkNodeIds.contains(currCheck)) continue;
            checkNodeIds.add((String)currCheck);
        }
        if (evt.getChecked().booleanValue()) {
            ArrayList<ValueTextItem> listValue = new ArrayList<ValueTextItem>();
            for (String id : checkNodeIds) {
                TreeNode node = root.getTreeNode(id, 16);
                if (node.getChildren() != null) continue;
                ValueTextItem map = new ValueTextItem(node.getId(), node.getText());
                listValue.add(map);
            }
            if (!listValue.isEmpty()) {
                f7SelectedList = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
                f7SelectedList.addItems(listValue);
            }
        } else {
            TreeNode currentNode = root.getTreeNode((String)evt.getNodeId(), 16);
            f7SelectedList = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
            if (checkNodeIds.remove(currentNode.getId())) {
                f7SelectedList.removeItem((Object)currentNode.getId());
            }
            if (currentNode.getChildren() != null) {
                for (TreeNode child : currentNode.getChildren()) {
                    if (!checkNodeIds.remove(child.getId())) continue;
                    f7SelectedList.removeItem((Object)child.getId());
                }
            }
        }
        this.getPageCache().put(KEY_CHECKNODES, SerializationUtils.toJsonString(checkNodeIds));
    }

    public void RemoveClick(F7SelectedListRemoveEvent evt) {
        TreeView tree = (TreeView)this.getView().getControl(TREEKEY);
        if (evt.getParam() != null) {
            tree.uncheckNode(evt.getParam().toString());
            List<String> checkNodes = this.getCheckNodes();
            checkNodes.remove(evt.getParam().toString());
            this.getPageCache().put(KEY_CHECKNODES, SerializationUtils.toJsonString(checkNodes));
        } else {
            List<String> checkNodes = this.getCheckNodes();
            checkNodes.clear();
            tree.uncheckNodes(tree.getTreeState().getCheckedNodeIds());
            this.getPageCache().put(KEY_CHECKNODES, SerializationUtils.toJsonString(checkNodes));
        }
    }
}

