/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.embedaction;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.form.IFormView;
import kd.bos.form.control.FormDesigner;
import kd.bos.gptas.autoact.agent.AgentContext;
import kd.bos.gptas.embedaction.MetadataUtil;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;

public class AbstractSetPropertyAction {
    private static final String FORM_META = "formmeta";
    protected final List<Map<String, Object>> controlIdList;
    protected final Map<String, Object> formmeta;
    private Map<String, String> params;
    protected final FormDesigner formDesigner;
    protected final IFormView designerView;

    public AbstractSetPropertyAction(AgentContext context) {
        this.params = (Map)context.getContextVarProvider().get("actionpara");
        this.designerView = SessionManager.getCurrent().getView(this.params.get("PAGE_ID"));
        this.formDesigner = MetadataUtil.getFormDesigner(this.designerView);
        Map<String, Object> designMetadata = MetadataUtil.getDesignMetadta(this.designerView);
        this.formmeta = (Map)designMetadata.get(FORM_META);
        String controlIds = this.params.get("controlIds");
        HashSet<String> controlId = new HashSet<String>(Arrays.asList(controlIds.split(",")));
        this.controlIdList = MetadataUtil.getItemListByFilter(this.formmeta, o -> controlId.contains((String)o.get("Id")));
    }

    public AbstractSetPropertyAction(Map<String, String> params) {
        this.params = params;
        this.designerView = SessionManager.getCurrent().getView(params.get("PAGE_ID"));
        if (this.designerView != null) {
            this.formDesigner = MetadataUtil.getFormDesigner(this.designerView);
            Map<String, Object> designMetadata = MetadataUtil.getDesignMetadta(this.designerView);
            this.formmeta = (Map)designMetadata.get(FORM_META);
            String controlIds = params.get("controlIds");
            HashSet<String> controlId = new HashSet<String>(Arrays.asList(controlIds.split(",")));
            this.controlIdList = MetadataUtil.getItemListByFilter(this.formmeta, o -> controlId.contains((String)o.get("Id")));
        } else {
            this.formDesigner = null;
            this.formmeta = null;
            this.controlIdList = null;
        }
    }

    protected void setProperty(String propertyName, Object value) {
        for (Map<String, Object> item : this.controlIdList) {
            this.setProperty((String)item.get("Id"), propertyName, value, null);
        }
    }

    protected void setProperty(String controlId, String propertyName, Object value, Object alias) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("itemId", controlId);
        param.put("propertyName", propertyName);
        param.put("metaType", FORM_META);
        param.put("value", value);
        if (alias != null) {
            param.put("alias", alias);
        }
        this.formDesigner.setProperty(param);
    }

    protected void sendActionResult() {
        PushMessage message = new PushMessage(PushMessageRange.RootPage, this.designerView.getPageId(), (Object)JSON.toJSONString((Object)this.designerView.getActionResult()));
        PushServiceHelper.push((PushMessage)message);
    }
}

