/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.embedaction;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.IFormView;
import kd.bos.form.gpt.IGPTFormAction;
import kd.bos.gptas.embedaction.MetadataUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.domainmodel.ElementType;
import kd.bos.mvc.SessionManager;

public class ControlInfoAction
implements IGPTFormAction {
    private static final Log logger = LogFactory.getLog(ControlInfoAction.class);

    public Map<String, String> invokeAction(String pageID, String action, Map<String, String> params) {
        IFormView formView = SessionManager.getCurrent().getView(pageID);
        if (formView == null) {
            logger.error("FormView not exits. pageID:{}", (Object)pageID);
            return null;
        }
        String controlIds = params.get("controlIds");
        HashSet<String> controlId = new HashSet<String>(Arrays.asList(controlIds.split(",")));
        Map<String, Object> designMetadta = MetadataUtil.getDesignMetadta(formView);
        List<Map<String, Object>> list = MetadataUtil.getItemListByFilter(designMetadta, o -> controlId.contains(o.get("Id")));
        String modelType = (String)designMetadta.get("ModelType");
        DomainModelType domainModelType = DomainModelType.getDomainModelType((String)modelType);
        HashMap<String, String> result = new HashMap<String, String>(16);
        for (Map<String, Object> map : list) {
            String type = (String)map.get("_Type_");
            ElementType elementType = domainModelType.getElementType(type);
            if (elementType == null) continue;
            LocaleString name = elementType.getName();
            result.put("type", name.toString());
        }
        return result;
    }
}

