/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.embedaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.FormDesigner;
import kd.bos.login.actions.SerializationUtils;

public class MetadataUtil {
    private static final String ITEMS = "Items";
    private static final String FORM_META = "formmeta";

    public static List<Map<String, Object>> getItemListByFilter(Map<String, Object> meta, Function<Map<String, Object>, Boolean> filterFunc) {
        List items = (List)meta.get(ITEMS);
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(16);
        for (Object item : items) {
            Map map = (Map)item;
            if (!filterFunc.apply(map).booleanValue()) continue;
            resultList.add(map);
        }
        return resultList;
    }

    public static Map<String, Object> getItemByParentId(Map<String, Object> meta, String id, Function<Map<String, Object>, Boolean> filterFunc) {
        List items = (List)meta.get(ITEMS);
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(16);
        items.forEach(o -> map.put((String)o.get("Id"), (Map<String, Object>)o));
        return MetadataUtil.getItemListByParentId((Map)items.get(0), map, id, filterFunc);
    }

    private static Map<String, Object> getItemListByParentId(Map<String, Object> root, Map<String, Map<String, Object>> mapItems, String id, Function<Map<String, Object>, Boolean> filterFunc) {
        String parentId = (String)mapItems.get(id).get("ParentId");
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            Map<String, Object> parentItem = mapItems.get(parentId);
            if (filterFunc.apply(parentItem).booleanValue()) {
                return parentItem;
            }
            return MetadataUtil.getItemListByParentId(root, mapItems, (String)parentItem.get("Id"), filterFunc);
        }
        return root;
    }

    public static FormDesigner getFormDesigner(IFormView formView) {
        FormDesigner formDesigner = (FormDesigner)formView.getControl("formdesigner");
        if (formDesigner == null) {
            formDesigner = (FormDesigner)formView.getControl("proformdesigner");
        }
        return formDesigner;
    }

    public static Map<String, Object> getDesignMetadta(IFormView desingerView) {
        return (Map)SerializationUtils.fromJsonString((String)desingerView.getPageCache().get("current_metadata"), Map.class);
    }

    public static void setDesignerProperty(IFormView desingerView, String controlIds, String propertyName, Object value) {
        HashSet<String> controlId = new HashSet<String>(Arrays.asList(controlIds.split(",")));
        FormDesigner formDesigner = MetadataUtil.getFormDesigner(desingerView);
        Map<String, Object> designMetadta = MetadataUtil.getDesignMetadta(desingerView);
        List<Map<String, Object>> list = MetadataUtil.getItemListByFilter((Map)designMetadta.get(FORM_META), o -> controlId.contains(o.get("Id")));
        for (Map<String, Object> item : list) {
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.put("itemId", item.get("Id"));
            param.put("propertyName", propertyName);
            param.put("metaType", FORM_META);
            param.put("value", value);
            formDesigner.setProperty(param);
        }
    }
}

