/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.embedaction.formrule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.gptas.embedaction.MetadataUtil;
import kd.bos.metadata.form.rule.FieldId;
import kd.bos.metadata.form.rule.FormRuleAction;
import kd.bos.metadata.form.rule.HideControlAction;
import kd.bos.metadata.form.rule.HideFieldAction;
import kd.bos.metadata.form.rule.LockControlAction;
import kd.bos.metadata.form.rule.LockFieldAction;
import kd.bos.metadata.form.rule.ShowControlAction;
import kd.bos.metadata.form.rule.ShowFieldAction;
import kd.bos.metadata.form.rule.UnlockControlAction;
import kd.bos.metadata.form.rule.UnlockFieldAction;

public class FormRuleActionModel {
    private String actionType;
    private String action;

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public List<FormRuleAction> toFormRuleAction(Map<String, Object> formmeta) {
        HideControlAction controlAction;
        HideFieldAction fieldAction;
        ArrayList<FormRuleAction> list = new ArrayList<FormRuleAction>(16);
        switch (this.getActionType()) {
            case "hidefield": 
            case "hidecontrol": {
                fieldAction = new HideFieldAction();
                controlAction = new HideControlAction();
                break;
            }
            case "lockfield": 
            case "lockcontrol": {
                fieldAction = new LockFieldAction();
                controlAction = new LockControlAction();
                break;
            }
            case "showfield": 
            case "showcontrol": {
                fieldAction = new ShowFieldAction();
                controlAction = new ShowControlAction();
                break;
            }
            case "unlockfield": 
            case "unlockcontrol": {
                fieldAction = new UnlockFieldAction();
                controlAction = new UnlockControlAction();
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        fieldAction.setDescription(fieldAction.getClass().getSimpleName());
        fieldAction.setActionType(fieldAction.getClass().getSimpleName());
        fieldAction.setRET(251);
        controlAction.setDescription(controlAction.getClass().getSimpleName());
        controlAction.setActionType(fieldAction.getClass().getSimpleName());
        fieldAction.setRET(251);
        list.addAll(this.toClientSetPropAction(formmeta, (FormRuleAction)fieldAction, (FormRuleAction)controlAction));
        return list;
    }

    private List<FormRuleAction> toClientSetPropAction(Map<String, Object> formmeta, FormRuleAction fieldAction, FormRuleAction controlAction) {
        String action = this.getAction();
        HashSet<String> actionsSet = new HashSet<String>(Arrays.asList(action.split(",")));
        List<Map<String, Object>> itemList = MetadataUtil.getItemListByFilter(formmeta, o -> actionsSet.contains((String)o.get("Name")) || actionsSet.contains((String)o.get("Key")));
        for (Map<String, Object> item : itemList) {
            if (item.containsKey("FieldType")) {
                fieldAction.getFields().add(new FieldId((String)item.get("Id")));
                continue;
            }
            controlAction.getFields().add(new FieldId((String)item.get("Id")));
        }
        ArrayList<FormRuleAction> list = new ArrayList<FormRuleAction>(2);
        if (!fieldAction.getFields().isEmpty()) {
            list.add(fieldAction);
        }
        if (!controlAction.getFields().isEmpty()) {
            list.add(controlAction);
        }
        return list;
    }
}

