/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.homepage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class FAQPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(FAQPlugin.class);
    private final List<String> faqList = new ArrayList<String>();

    public FAQPlugin() {
        try (InputStream resourceAsStream = FAQPlugin.class.getResourceAsStream("/fqa.txt");
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(resourceAsStream));
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                this.faqList.add(line);
            }
        }
        catch (IOException ex) {
            logger.error((Throwable)ex);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillFAQList();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if ("nextlist".equals(source.getOperateKey())) {
            this.fillFAQList();
        }
        if (source.getOperateKey().startsWith("settext")) {
            int index = Integer.parseInt(source.getOperateKey().substring(7));
            String text = this.getView().getPageCache().get("label" + index);
            try {
                Map actionParams = (Map)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("actionparams")), Map.class);
                String processNumber = (String)actionParams.get("proccess");
                QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)processNumber)};
                DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_process", (QFilter[])filters);
                if (obj == null) {
                    logger.error("GaiService.startProcessInSideBar error, {} process not exists.", (Object)processNumber);
                    return;
                }
                String designerPageId = (String)actionParams.get("ROOT_PAGE_ID");
                long processId = obj.getLong("id");
                HashMap<String, String> startParams = new HashMap<String, String>();
                startParams.put("input", text);
                try {
                    DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"startProcessInSideBar", (Object[])new Object[]{processId, designerPageId, startParams, text});
                }
                catch (RuntimeException ex) {
                    Throwable cause;
                    for (cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof NoSuchMethodException)) continue;
                        DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"startProcessInSideBar", (Object[])new Object[]{processId, designerPageId, startParams});
                        break;
                    }
                    if (cause == null) {
                        throw ex;
                    }
                }
            }
            catch (Exception ex) {
                logger.error("GaiService.startProcessInSideBar error", (Throwable)ex);
            }
        }
    }

    private void fillFAQList() {
        String s = this.getView().getPageCache().get("lastfill");
        CharSequence[] excludes = StringUtils.isNotBlank((CharSequence)s) ? s.split(",") : new String[4];
        int[] indexes = this.getRandomNum(4, this.faqList.size(), (String[])excludes);
        for (int i = 0; i < indexes.length; ++i) {
            Label label = (Label)this.getControl("label" + (i + 1));
            String text = this.faqList.get(indexes[i]);
            this.getView().getPageCache().put(label.getKey(), text);
            label.setText(text);
            excludes[i] = String.valueOf(indexes[i]);
        }
        this.getView().getPageCache().put("lastfill", String.join((CharSequence)",", excludes));
    }

    private int[] getRandomNum(int size, int max, String[] excludes) {
        HashSet<Integer> uniqueNumbers = new HashSet<Integer>(16);
        SecureRandom random = new SecureRandom();
        while (uniqueNumbers.size() < size) {
            int n = random.nextInt(max);
            boolean exists = false;
            for (String exclude : excludes) {
                if (!String.valueOf(n).equals(exclude)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            uniqueNumbers.add(n);
        }
        int[] numArray = new int[size];
        int index = 0;
        Iterator iterator = uniqueNumbers.iterator();
        while (iterator.hasNext()) {
            int num = (Integer)iterator.next();
            numArray[index++] = num;
        }
        return numArray;
    }
}

