/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.jsoup.UncheckedIOException;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class DataUtil {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*(?:[\"'])?([^\\s,;\"']*)");
    public static final Charset UTF_8 = StandardCharsets.UTF_8;
    static final String defaultCharsetName = UTF_8.name();

    public static Document parseHtml(String html, @Nullable String charsetName, String baseUri, Parser parser) throws IOException {
        Document doc = null;
        try {
            doc = parser.parseInput(html, baseUri);
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.ioException();
        }
        Elements metaElements = doc.select("meta[http-equiv=content-type], meta[charset]");
        String foundCharset = null;
        for (Element meta : metaElements) {
            if (meta.hasAttr("http-equiv")) {
                foundCharset = DataUtil.getCharsetFromContentType(meta.attr("content"));
            }
            if (foundCharset == null && meta.hasAttr("charset")) {
                foundCharset = meta.attr("charset");
            }
            if (foundCharset == null) continue;
            break;
        }
        if (foundCharset == null && doc.childNodeSize() > 0) {
            Comment comment;
            Node first = doc.childNode(0);
            XmlDeclaration decl = null;
            if (first instanceof XmlDeclaration) {
                decl = (XmlDeclaration)first;
            } else if (first instanceof Comment && (comment = (Comment)first).isXmlDeclaration()) {
                decl = comment.asXmlDeclaration();
            }
            if (decl != null && decl.name().equalsIgnoreCase("xml")) {
                foundCharset = decl.attr("encoding");
            }
        }
        if ((foundCharset = DataUtil.validateCharset(foundCharset)) != null && !foundCharset.equalsIgnoreCase(defaultCharsetName)) {
            charsetName = foundCharset = foundCharset.trim().replaceAll("[\"']", "");
            doc = null;
        }
        if (doc == null) {
            if (charsetName == null) {
                charsetName = defaultCharsetName;
            }
            try {
                doc = parser.parseInput(html, baseUri);
            }
            catch (UncheckedIOException uncheckedIOException) {
                throw uncheckedIOException.ioException();
            }
            Charset charset = charsetName.equals(defaultCharsetName) ? UTF_8 : Charset.forName(charsetName);
            doc.outputSettings().charset(charset);
            if (!charset.canEncode()) {
                doc.charset(UTF_8);
            }
        }
        return doc;
    }

    @Nullable
    private static String validateCharset(@Nullable String cs) {
        if (cs != null && !cs.isEmpty()) {
            cs = cs.trim().replaceAll("[\"']", "");
            try {
                if (Charset.isSupported(cs)) {
                    return cs;
                }
                if (Charset.isSupported(cs = cs.toUpperCase(Locale.ENGLISH))) {
                    return cs;
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
            return null;
        }
        return null;
    }

    @Nullable
    static String getCharsetFromContentType(@Nullable String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = charsetPattern.matcher(contentType);
        if (m.find()) {
            String charset = m.group(1).trim();
            charset = charset.replace("charset=", "");
            return DataUtil.validateCharset(charset);
        }
        return null;
    }
}

