/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.File;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.gptas.milvus.Chunk;
import kd.bos.gptas.milvus.MilvusDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInfoHandle {
    private static final Logger log = LoggerFactory.getLogger(FileInfoHandle.class);

    public static boolean getAssistantInfo(Map<String, Object> paramMap) {
        Map result;
        Optional optional;
        String assistantNumber = (String)paramMap.get("type");
        if (StringUtils.isBlank((CharSequence)assistantNumber)) {
            assistantNumber = "cosmic_qa";
        }
        if ((optional = (result = BusinessDataReader.loadFromCache((String)"corpus_libs", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)assistantNumber)})).values().stream().findFirst()).isPresent()) {
            String productline;
            DynamicObject dynamicObject = (DynamicObject)optional.get();
            String indexmethod = dynamicObject.getString("indexmethod");
            long assistantId = dynamicObject.getLong("id");
            if (!StringUtils.isNotBlank((CharSequence)indexmethod)) {
                return false;
            }
            paramMap.put("indexmethod", indexmethod);
            paramMap.put("assistant_id", assistantId);
            DynamicObject updateTimeDyo = BusinessDataReader.loadSingle((Object)assistantId, (String)"corpus_libs", (String)"updatetime");
            long updatetime = updateTimeDyo.getLong("updatetime");
            if (updatetime != 0L) {
                paramMap.put("updatetime", updatetime);
            }
            if (StringUtils.isNotBlank((CharSequence)(productline = dynamicObject.getString("productline")))) {
                paramMap.put("productline", productline);
                return true;
            }
            return false;
        }
        return false;
    }

    public static void batchInsertMilvus(MilvusDao milvusDao, String assistantNum, List<Chunk> chunks) {
        milvusDao.batchInsertAsync(assistantNum, chunks, insertResults -> {
            HashMap<Long, List> knlCorpus = new HashMap<Long, List>();
            for (Chunk ch : insertResults) {
                Long knlId = ch.getKNLId();
                List sementChunks = knlCorpus.computeIfAbsent(knlId, k -> new ArrayList());
                sementChunks.add(ch);
            }
            Set ids = knlCorpus.keySet();
            Map callbackDyObjs = BusinessDataReader.loadFromCache((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"knl_corpus"));
            for (Map.Entry entry : callbackDyObjs.entrySet()) {
                long knlId = (Long)entry.getKey();
                DynamicObject callbackdy = (DynamicObject)entry.getValue();
                if ("A".equals(callbackdy.getString("status"))) {
                    callbackDyObjs.remove(knlId);
                    continue;
                }
                String dyFailMsg = "";
                for (Chunk ch : (List)knlCorpus.get(knlId)) {
                    if (!StringUtils.isNotBlank((CharSequence)ch.getFailMsg())) continue;
                    log.warn(String.format("FileInfoHandle.batchInsertMilvus fail, chunkid is %1$d, failmsg is %2$s", ch.getId(), ch.getFailMsg()));
                    dyFailMsg = ch.getFailMsg();
                }
                if (StringUtils.isNotBlank((CharSequence)dyFailMsg)) {
                    callbackdy.set("failmsg_tag", (Object)dyFailMsg);
                    callbackdy.set("uploadstatus", (Object)"F");
                    continue;
                }
                callbackdy.set("uploadstatus", (Object)"S");
            }
            DynamicObject[] dynamicObjArrays = new DynamicObject[]{};
            OperationResult opResult = OperationServiceHelper.executeOperate((String)"save", (String)"knl_corpus", (DynamicObject[])callbackDyObjs.values().toArray(dynamicObjArrays), (OperateOption)OperateOption.create());
            List operateInfos = opResult.getAllErrorOrValidateInfo();
            if (!operateInfos.isEmpty()) {
                log.error(String.format("\u672c\u6b21\u64cd\u4f5c\u5931\u8d25\u4fe1\u606f%s", SerializationUtils.toJsonString((Object)operateInfos)));
            }
        });
    }
}

