/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km;

import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import kd.bos.session.SessionKeys;
import kd.bos.url.UrlService;

public class IFrameUtil {
    public static String buildUrl(int height, FormShowParameter formShowParameter) {
        int width = 350;
        HashMap<String, Integer> mapSize = new HashMap<String, Integer>();
        mapSize.put("width", width);
        mapSize.put("height", height);
        mapSize.put("padding", 0);
        try {
            String domainContextUrl = UrlService.getDomainContextUrl();
            if (!domainContextUrl.endsWith("/")) {
                domainContextUrl = domainContextUrl + "/";
            }
            formShowParameter.getOpenStyle().setShowType(ShowType.IFrame);
            PageCache pageCache = new PageCache(formShowParameter.getPageId());
            Map formConfig = FormConfigFactory.createConfig((FormShowParameter)formShowParameter);
            pageCache.put("formconfig", SerializationUtils.toJsonString((Object)formConfig));
            String url = "byPageId=" + formShowParameter.getPageId();
            Boolean svcLoginAccountSession = SessionKeys.isAccountSession((String)RequestContext.get().getTenantId());
            if (svcLoginAccountSession.booleanValue()) {
                url = url + "&kdcdc=" + RequestContext.get().getAccountId();
            }
            url = url + "&isCosmicUI=true&gaiIframeSize=" + SerializationUtils.toJsonString(mapSize);
            return domainContextUrl + "?" + URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String buildImageUrl(String relativeUrl, boolean isLoadCache) {
        String domainContextUrl = UrlService.getDomainContextUrl();
        if (domainContextUrl.endsWith("/")) {
            domainContextUrl = domainContextUrl.substring(0, domainContextUrl.lastIndexOf("/") - 1);
        }
        if (!relativeUrl.startsWith("/")) {
            relativeUrl = "/" + relativeUrl;
        }
        if (isLoadCache) {
            return domainContextUrl + relativeUrl;
        }
        long timestamp = new Date().getTime();
        return domainContextUrl + relativeUrl + "?" + timestamp;
    }

    public static void sendFormActionByWS(String pageId, List<Object> acts) {
        PushMessage message = new PushMessage(PushMessageRange.RootPage, pageId, (Object)JSON.toJSONString(acts));
        PushServiceHelper.push((PushMessage)message);
    }

    public static void sendFormActionByWS(IFormView rootView, IFormView formView) {
        rootView.sendFormAction(formView);
        PushMessage message = new PushMessage(PushMessageRange.RootPage, rootView.getPageId(), (Object)JSON.toJSONString((Object)rootView.getActionResult()));
        PushServiceHelper.push((PushMessage)message);
    }

    public static String toBase64(Object o) {
        return Base64.getUrlEncoder().encodeToString(SerializationUtils.toJsonString((Object)o).getBytes(StandardCharsets.UTF_8));
    }

    public static String fromBase64(String o) {
        return new String(Base64.getUrlDecoder().decode(o.getBytes(StandardCharsets.UTF_8)));
    }
}

