/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.knowledage;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.gptas.km.File.FileInfoHandle;
import kd.bos.gptas.km.article.Child;
import kd.bos.gptas.km.article.Classifies;
import kd.bos.gptas.km.article.Content;
import kd.bos.gptas.km.article.SearchResult;
import kd.bos.gptas.km.knowledage.CloudAPIHelper;
import kd.bos.gptas.km.splitter.TextSplitter;
import kd.bos.gptas.km.splitter.TextSplitterProvider;
import kd.bos.gptas.milvus.Chunk;
import kd.bos.gptas.milvus.MilvusDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.HttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArticleHandler {
    private static final Logger log = LoggerFactory.getLogger(ArticleHandler.class);
    private static final String BOS_DEVPORTAL_GPTAS = "bos-devportal-gptas";

    public static void importArticle(List<String> domains, Map<String, Object> paramMap) {
        boolean result = FileInfoHandle.getAssistantInfo(paramMap);
        if (!result) {
            log.warn(ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u7d22\u5f15\u6216\u8005\u95ee\u7b54\u4ea7\u54c1\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u7f6e\u5e94\u7528\u52a9\u624b\u7684\u77e5\u8bc6\u5e93\u7d22\u5f15\u6216\u8005\u95ee\u7b54\u4ea7\u54c1\u5b57\u6bb5\u3002", (String)"ArticleHandler_3", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]));
            return;
        }
        CloudAPIHelper cloudAPIHelper = new CloudAPIHelper();
        String productline = (String)paramMap.get("productline");
        if (StringUtils.isNotBlank((CharSequence)productline)) {
            long current = System.currentTimeMillis();
            paramMap.put("auditedAtEnd", current);
            String[] productArray = productline.split(",");
            for (String domain : domains) {
                ThreadPools.executeOnce((String)"knowledage-import", () -> {
                    for (String product : productArray) {
                        int count = ArticleHandler.downloadArticles(domain, cloudAPIHelper, paramMap, product);
                        log.info(domain + " \u5df2\u83b7\u53d6" + count + "\u7bc7\u6587\u7ae0");
                    }
                });
            }
            ArticleHandler.updateTime(paramMap);
        }
    }

    private static int downloadArticles(String domain, CloudAPIHelper cloudAPIHelper, Map<String, Object> paramMap, String seriesCode) {
        int page = 1;
        int count = 0;
        while (true) {
            SearchResult searchResult;
            String queryString = "category_code=developer01&series_code=" + seriesCode + "&page=" + (page + 1) + "&pageSize=50&domain=" + domain;
            Object updateTime = paramMap.get("updatetime");
            if (updateTime != null) {
                queryString = queryString + "&auditedAtStart=" + (Long)updateTime + "&auditedAtEnd=" + (Long)paramMap.get("auditedAtEnd") + "&needDetail=true";
            }
            List<Content> contentList = Collections.EMPTY_LIST;
            try {
                String url = "https://api.kingdee.com/knowledge/productKnowledge";
                Map<String, String> header = cloudAPIHelper.getGetRequestHeader(seriesCode, page, domain, "/knowledge/productKnowledge", queryString);
                String result = HttpClientUtils.get((String)(url + "?" + queryString), header, null);
                searchResult = (SearchResult)JSONObject.parseObject((String)result, SearchResult.class);
                contentList = searchResult.getContent();
            }
            catch (Exception e) {
                log.error("downloadArticles error {}", (Object)e.getMessage());
                break;
            }
            if (contentList.isEmpty()) {
                log.info("\u83b7\u53d6\u6587\u7ae0\u6570\u91cf\u4e3a0,\u7ed3\u675f.");
                break;
            }
            if (searchResult.getTotalPages() >= 50) {
                log.warn("\u53d6\u6570\u8d85\u8fc750\u9875,\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u8fc7\u6ee4\u6761\u4ef6" + queryString);
            }
            if (searchResult.getNumber() < page) {
                log.info("\u65e0\u6cd5\u83b7\u53d6\u65b0\u7684\u9875\u7801.\u5df2\u83b7\u53d6" + page + " \u9875\u6570\u636e");
                break;
            }
            try {
                count += ArticleHandler.saveContentByList(contentList, paramMap);
                if (searchResult.isLast()) {
                    log.info("\u83b7\u53d6\u7ed3\u675f.\u5df2\u83b7\u53d6" + page + " \u9875\u6570\u636e");
                    break;
                }
                ++page;
            }
            catch (Exception e) {
                log.error("downloadArticles error {}", (Object)e.getMessage());
            }
        }
        return count;
    }

    private static String normalizeFileName(String fileName) {
        return fileName.replaceAll("[/\\\\:*?\"<>|]", "").replace("\r", "").replace("\n", "");
    }

    private static int saveContentByList(List<Content> contentList, Map<String, Object> paramMap) {
        return ArticleHandler.saveContentByList(contentList, 0, paramMap);
    }

    private static int saveContentByList(List<Content> contentList, int retryCount, Map<String, Object> paramMap) {
        int count = 0;
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
        for (Content content : contentList) {
            String articleContent;
            String knowledgeContentType;
            if (content.getTitle() == null) {
                ++count;
                continue;
            }
            boolean found = false;
            if (content.getEntity_type().equals("Knowledge") && ("Article".equals(knowledgeContentType = content.getKnowledgeContentType()) || "Answer".equals(knowledgeContentType)) && (articleContent = content.getContent()) != null) {
                ArticleHandler.saveToFile(content, articleContent, paramMap, dynamicObjects);
                ++count;
                found = true;
            }
            if (found) continue;
            log.warn("\u6587\u7ae0\u4e0d\u5bf9" + content.getId() + content.getTitle() + "\u662f\u89c6\u9891\uff0c\u5ffd\u7565\u3002");
            ++count;
        }
        if (count != contentList.size()) {
            log.info("\u6587\u7ae0\u6570\u91cf\u4e0d\u5bf9:" + contentList.size() + " " + count);
        }
        if (!dynamicObjects.isEmpty()) {
            List<Object> fids = ArticleHandler.saveKnowledage(dynamicObjects);
            ArticleHandler.insert2VectorLib(paramMap, fids);
        }
        return count;
    }

    private static void saveToFile(Content content, String fileContent, Map<String, Object> paramMap, List<DynamicObject> dynamicObjects) {
        DynamicObject dynamicObject = ArticleHandler.createKnlInstance(content, fileContent, paramMap);
        if (dynamicObject == null) {
            return;
        }
        dynamicObjects.add(dynamicObject);
        if (dynamicObjects.size() >= 50) {
            List<Object> fids = ArticleHandler.saveKnowledage(dynamicObjects);
            ArticleHandler.insert2VectorLib(paramMap, fids);
        }
    }

    private static DynamicObject createKnlInstance(Content content, String textContent, Map<String, Object> paramMap) {
        DynamicObject dynamicObject;
        DynamicObject exsitCorpus;
        long lastUpdateTime;
        long id = content.getId();
        long updateTime = content.getKnowledgeUpdatedAt();
        Map knowledgeResult = BusinessDataReader.loadFromCache((String)"knl_corpus", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)String.valueOf(id))});
        Optional optional = knowledgeResult.values().stream().findFirst();
        if (optional.isPresent() && updateTime <= (lastUpdateTime = (exsitCorpus = (DynamicObject)optional.get()).getLong("updatetime"))) {
            return null;
        }
        if (knowledgeResult.isEmpty()) {
            dynamicObject = (DynamicObject)EntityMetadataCache.getDataEntityType((String)"knl_corpus").createInstance();
        } else if (knowledgeResult.size() == 1) {
            Optional result = knowledgeResult.values().stream().findFirst();
            dynamicObject = (DynamicObject)result.get();
        } else {
            log.warn("\u5b58\u5728\u591a\u6761\u76f8\u540c\u7f16\u7801\u7684\u77e5\u8bc6");
            return null;
        }
        dynamicObject.set("number", (Object)id);
        dynamicObject.set("updatetime", (Object)updateTime);
        dynamicObject.set("datasource_id", (Object)ArticleHandler.getDataSourceId(content));
        dynamicObject.set("filepath", (Object)String.format("https://vip.kingdee.com/knowledge/%d", id));
        dynamicObject.set("name", (Object)ArticleHandler.getFileName(content));
        dynamicObject.set("status", (Object)"B");
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("uploadstatus", (Object)"I");
        dynamicObject.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        dynamicObject.set("group_id", ArticleHandler.getGroup(content, (String)paramMap.get("type")));
        dynamicObject.set("inputcontent_tag", (Object)textContent);
        DynamicObjectCollection dynamicObjectCollection = ArticleHandler.getEntryDynamicObjectCollection(textContent, dynamicObject, paramMap);
        dynamicObject.set("segmententity", (Object)dynamicObjectCollection);
        return dynamicObject;
    }

    private static String getFileName(Content content) {
        String fileName = content.getTitle();
        if (fileName == null) {
            fileName = String.valueOf(content.getId());
        }
        return ArticleHandler.normalizeFileName(fileName);
    }

    private static long getDataSourceId(Content content) {
        long dataSourceId = 0L;
        String knowledgeContentType = content.getKnowledgeContentType();
        if ("Article".equals(knowledgeContentType)) {
            dataSourceId = 1000L;
        } else if ("Answer".equals(knowledgeContentType)) {
            dataSourceId = 1001L;
        } else {
            log.info("\u7c7b\u578b\u4e0d\u5bf9");
        }
        return dataSourceId;
    }

    private static Object getGroup(Content content, String assistantNumber) {
        Long group = 1865176043442328718L;
        Map result = BusinessDataReader.loadFromCache((String)"knl_group", (QFilter[])new QFilter[]{new QFilter("longnumber", "=", (Object)ArticleHandler.getCode(content.getClassifies())), new QFilter("type", "=", (Object)assistantNumber)});
        if (!result.isEmpty()) {
            Set ids = result.keySet();
            for (Object fid : ids) {
                group = fid;
            }
        }
        return group;
    }

    private static String getCode(List<Classifies> classifies) {
        Classifies clas;
        Child child;
        StringBuilder code = new StringBuilder();
        if (!classifies.isEmpty() && (child = (clas = classifies.get(classifies.size() - 1)).getChild()) != null) {
            Child child_son;
            if ("domain".equalsIgnoreCase(child.getType())) {
                code.append(child.getCode());
            }
            if ((child_son = child.getChild()) != null && "module".equalsIgnoreCase(child_son.getType())) {
                code.append(".").append(child_son.getCode());
            }
        }
        return code.toString();
    }

    private static DynamicObjectCollection getEntryDynamicObjectCollection(String textContent, DynamicObject dynamicObject, Map<String, Object> paramMap) {
        String corpusLibNumber = (String)paramMap.get("type");
        TextSplitter splitter = new TextSplitter(TextSplitterProvider.getRecursiveCharacterTextSplitter(corpusLibNumber));
        List<Object> segments = splitter.split(textContent, 0);
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        DynamicObjectType dynamicObjectType = (DynamicObjectType)((BasedataEntityType)dynamicObject.getDynamicObjectType()).getAllEntities().get("segmententity");
        for (Object seg : segments) {
            DynamicObject segDynamicObj = new DynamicObject(dynamicObjectType);
            segDynamicObj.set("segment_tag", seg);
            segDynamicObj.set("segenable", (Object)Character.valueOf('1'));
            dynamicObjectCollection.add((Object)segDynamicObj);
        }
        return dynamicObjectCollection;
    }

    private static List<Object> saveKnowledage(List<DynamicObject> dynamicObjects) {
        DynamicObject[] dynamicObjArrays = new DynamicObject[]{};
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"save", (String)"knl_corpus", (DynamicObject[])dynamicObjects.toArray(dynamicObjArrays), (OperateOption)OperateOption.create());
        List fids = opResult.getSuccessPkIds();
        log.info(String.format("\u672c\u6b21\u64cd\u4f5c\u5171%d\u6761\u6570\u636e\uff0c\u6210\u529f%d\u6761", dynamicObjects.size(), fids.size()));
        dynamicObjects.clear();
        return fids;
    }

    private static void insert2VectorLib(Map<String, Object> paramMap, List<Object> fids) {
        String repoIdStr = (String)paramMap.get("indexmethod");
        if (StringUtils.isNotBlank((CharSequence)repoIdStr)) {
            ArticleHandler.uploadToMilvus(fids, repoIdStr, paramMap);
        }
    }

    private static void uploadToMilvus(List<Object> fids, String indexMethod, Map<String, Object> paramMap) {
        long assistantId = (Long)paramMap.get("assistant_id");
        String assistantNum = (String)paramMap.get("type");
        MilvusDao milvusDao = MilvusDao.create(indexMethod);
        Map result = BusinessDataReader.loadFromCache((Object[])fids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"knl_corpus"));
        Collection dataEntities = result.values();
        for (DynamicObject dynamicObject : dataEntities) {
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            DynamicObjectCollection segmengEntities = dynamicObject.getDynamicObjectCollection("segmententity");
            for (DynamicObject segmentRow : segmengEntities) {
                Chunk chunk = new Chunk();
                chunk.setId(segmentRow.getLong("id"));
                chunk.setKNLId(dynamicObject.getLong("id"));
                chunk.setRepositoryId(assistantId);
                chunk.setChunk(segmentRow.getString("segment_tag"));
                chunks.add(chunk);
            }
            if (chunks.isEmpty()) continue;
            FileInfoHandle.batchInsertMilvus(milvusDao, assistantNum, chunks);
        }
    }

    private static void updateTime(Map<String, Object> paramMap) {
        Object auditedAtEnd = paramMap.get("auditedAtEnd");
        Object assistantNumber = paramMap.get("type");
        if (auditedAtEnd != null && assistantNumber != null) {
            String sql = "update t_corpus_libs set fupdatetime = ? where fnumber = ?";
            Object[] params = new Object[]{new SqlParameter("fupdatetime", 93, auditedAtEnd), new SqlParameter("fnumber", 12, assistantNumber)};
            DB.update((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params);
        }
    }
}

