/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.knowledage;

import java.sql.ResultSet;
import java.util.EventObject;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.km.IFrameUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorpusLibsFormPlugin
extends AbstractFormPlugin
implements TabSelectListener,
RowClickEventListener {
    private static final String SYSTEM_TYPE = "bos-devportal-gptas";
    private static final String OP_SAVE = "save";
    private static final String BTN_CANCEL = "btncancel";
    private static final String BTN_LAST_STEP = "btnlaststep";
    private static final String BTN_NEXT_STEP = "btnnextstep";
    private static final String BTN_OK = "btnok";
    private static final String CONTROL_STEP_TAB = "steptab";
    private static final String ENTRY_CHUNK_STRATEGY = "strategyentry";
    private static final String TAB_BASE_INFO = "tabbaseinfo";
    private static final String TAB_DATA_SOURCE = "tabdatasource";
    private static final String TAB_STRATEGY = "tabstrategy";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_TYPE = "type";
    private static final String PROP_INDEX = "indexmethod";
    private static final String PROP_STRATEGY_TITLE = "strategytitle";
    private static final String PROP_STRATEGY_IMAGE = "strategyimage";
    private static final String PROP_STRATEGY_VALUE = "strategyvalue";
    private static final String PROP_CHUNK_STRATEGY = "chunkstrategy";
    private static final String PROP_CHUNK_SIZE = "chunksize";
    private static final String PROP_CHUNK_OVERLAP = "chunkoverlap";
    private static final String PROP_SEPARATORS = "separators";
    private static final String PROP_DATA_SOURCE = "datasource";
    private static final String PROP_UPDATE_STRATEGY = "updatestrategy";
    private static final String IMAGE_URL_AUTO_CHUNK = "/images/pc/other/auto_chunk.png";
    private static final String IMAGE_URL_CUSTOM_CHUNK = "/images/pc/other/custom_chunk.png";
    private static final String CHUNK_STRATEGY_AUTO = "auto";
    private static final String CHUNK_STRATEGY_CUSTOM = "custom";
    private static final String CHUNK_DEFAULT_SEPARATORS = ",.,\u3002,";
    private static final String CACHE_HAS_KNL = "hasKnowledge";
    static String[] lockFields = new String[]{"number", "type", "indexmethod", "tabdatasource", "tabstrategy"};
    private static final Logger log = LoggerFactory.getLogger(CorpusLibsFormPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        e.getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_LAST_STEP, BTN_NEXT_STEP, BTN_OK});
        Tab tab = (Tab)this.getControl(CONTROL_STEP_TAB);
        tab.addTabSelectListener((TabSelectListener)this);
        EntryGrid strategyEntry = (EntryGrid)this.getControl(ENTRY_CHUNK_STRATEGY);
        strategyEntry.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_CANCEL, BTN_NEXT_STEP});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_OK, BTN_LAST_STEP});
        this.setBillStatus();
        this.loadEmptyField();
        boolean hasKnowledge = this.hasKnowledge();
        this.getPageCache().put(CACHE_HAS_KNL, Boolean.toString(hasKnowledge));
        if (hasKnowledge) {
            this.setLock();
        }
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button) {
            String key;
            Button btn = (Button)source;
            switch (key = btn.getKey()) {
                case "btnnextstep": 
                case "btnlaststep": {
                    this.switchTab(key);
                    break;
                }
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String strategy = (String)this.getModel().getValue(PROP_STRATEGY_VALUE, evt.getRow());
        if (CHUNK_STRATEGY_AUTO.equals(strategy)) {
            this.getModel().setValue(PROP_CHUNK_STRATEGY, (Object)CHUNK_STRATEGY_AUTO);
        } else if (CHUNK_STRATEGY_CUSTOM.equals(strategy)) {
            this.getModel().setValue(PROP_CHUNK_STRATEGY, (Object)CHUNK_STRATEGY_CUSTOM);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (PROP_TYPE.equals(name)) {
            Object newType = e.getChangeSet()[0].getNewValue();
            if (null == newType) {
                return;
            }
            String type = ((DynamicObject)newType).getString(PROP_NUMBER);
            if ("code_gen_kingscript".equals(type) || "code_gen_java".equals(type)) {
                this.getModel().setValue(PROP_DATA_SOURCE, (Object)"local");
                this.getView().setEnable(Boolean.valueOf(false), new String[]{PROP_DATA_SOURCE});
            } else if ("knowledge_qa".equals(type)) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{PROP_DATA_SOURCE});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (OP_SAVE.equals(opKey)) {
            Object strategy = this.getModel().getValue(PROP_CHUNK_STRATEGY);
            if (CHUNK_STRATEGY_CUSTOM.equals(strategy)) {
                String separators = (String)this.getModel().getValue(PROP_SEPARATORS);
                if (StringUtils.isBlank((CharSequence)separators)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u9694\u7b26\u3002", (String)"CorpusLibsFormPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    args.setCancel(true);
                }
            } else if (CHUNK_STRATEGY_AUTO.equals(strategy)) {
                String index;
                int defaultChunkSize = 0;
                switch (index = (String)this.getModel().getValue(PROP_INDEX)) {
                    case "AZURE_EMBEDDING_ADA_002": {
                        defaultChunkSize = 1400;
                        break;
                    }
                    case "BAIDU_EMBEDDING_V1": {
                        defaultChunkSize = 350;
                        break;
                    }
                    case "KINGDEE_EMBEDDING": {
                        defaultChunkSize = 650;
                        break;
                    }
                }
                this.getModel().setValue(PROP_CHUNK_SIZE, (Object)defaultChunkSize);
                this.getModel().setValue(PROP_CHUNK_OVERLAP, (Object)0);
                this.getModel().setValue(PROP_SEPARATORS, (Object)CHUNK_DEFAULT_SEPARATORS);
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        if (TAB_BASE_INFO.equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_CANCEL, BTN_NEXT_STEP});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_OK, BTN_LAST_STEP});
        } else if (TAB_DATA_SOURCE.equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_LAST_STEP, BTN_NEXT_STEP});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_CANCEL, BTN_OK});
        } else if (TAB_STRATEGY.equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_LAST_STEP, BTN_OK});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_NEXT_STEP, BTN_CANCEL});
            boolean hasKnl = false;
            String hasKnlStr = this.getPageCache().get(CACHE_HAS_KNL);
            hasKnl = StringUtils.isBlank((Object)hasKnl) ? this.hasKnowledge() : Boolean.parseBoolean(hasKnlStr);
            this.loadStrategyConf(hasKnl);
        }
    }

    private void setBillStatus() {
        IDataEntityProperty property = this.getModel().getProperty("status");
        if (property != null && this.getView() instanceof IBillView) {
            if ("VIEW".equals(this.getView().getFormShowParameter().getStatus())) {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            } else {
                Object value = this.getModel().getValue("status");
                if ("A".equals(value)) {
                    boolean bFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                    if (bFromDb) {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                    } else {
                        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
                    }
                } else if ("B" == value) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.SUBMIT);
                } else if ("C" == value) {
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.AUDIT);
                }
            }
        }
    }

    private void switchTab(String operation) {
        String currentTab;
        Tab tabControl = (Tab)this.getControl(CONTROL_STEP_TAB);
        switch (currentTab = tabControl.getCurrentTab()) {
            case "tabbaseinfo": {
                if (!BTN_NEXT_STEP.equals(operation)) break;
                tabControl.activeTab(TAB_DATA_SOURCE);
                break;
            }
            case "tabdatasource": {
                if (BTN_LAST_STEP.equals(operation)) {
                    tabControl.activeTab(TAB_BASE_INFO);
                    break;
                }
                if (!BTN_NEXT_STEP.equals(operation)) break;
                tabControl.activeTab(TAB_STRATEGY);
                break;
            }
            case "tabstrategy": {
                if (!BTN_LAST_STEP.equals(operation)) break;
                tabControl.activeTab(TAB_DATA_SOURCE);
                break;
            }
        }
    }

    private void loadStrategyConf(boolean hasKnowledge) {
        DynamicObjectCollection chunkStrategyEntry = this.getModel().getEntryEntity(ENTRY_CHUNK_STRATEGY);
        if (!chunkStrategyEntry.isEmpty()) {
            return;
        }
        String strategy = (String)this.getModel().getValue(PROP_CHUNK_STRATEGY);
        String autoCardName = ResManager.loadKDString((String)"\u81ea\u52a8\u5206\u5757", (String)"CorpusLibsFormPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        String customCardName = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5206\u5757", (String)"CorpusLibsFormPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        String autoCardImg = IFrameUtil.buildImageUrl(IMAGE_URL_AUTO_CHUNK, true);
        String customCardImg = IFrameUtil.buildImageUrl(IMAGE_URL_CUSTOM_CHUNK, true);
        CardEntry chunkStrategyCard = (CardEntry)this.getControl(ENTRY_CHUNK_STRATEGY);
        BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
        if (hasKnowledge || BillOperationStatus.AUDIT.equals((Object)billStatus)) {
            this.getModel().createNewEntryRow(ENTRY_CHUNK_STRATEGY);
            if (CHUNK_STRATEGY_AUTO.equals(strategy)) {
                this.getModel().setValue(PROP_STRATEGY_TITLE, (Object)autoCardName, 0);
                this.getModel().setValue(PROP_STRATEGY_IMAGE, (Object)autoCardImg, 0);
                this.getModel().setValue(PROP_STRATEGY_VALUE, (Object)CHUNK_STRATEGY_AUTO, 0);
            } else if (CHUNK_STRATEGY_CUSTOM.equals(strategy)) {
                this.getModel().setValue(PROP_STRATEGY_TITLE, (Object)customCardName, 0);
                this.getModel().setValue(PROP_STRATEGY_IMAGE, (Object)customCardImg, 0);
                this.getModel().setValue(PROP_STRATEGY_VALUE, (Object)CHUNK_STRATEGY_CUSTOM, 0);
            }
            chunkStrategyCard.selectRows(0);
        } else {
            this.getModel().batchCreateNewEntryRow(ENTRY_CHUNK_STRATEGY, 2);
            this.getModel().setValue(PROP_STRATEGY_TITLE, (Object)autoCardName, 0);
            this.getModel().setValue(PROP_STRATEGY_TITLE, (Object)customCardName, 1);
            this.getModel().setValue(PROP_STRATEGY_IMAGE, (Object)autoCardImg, 0);
            this.getModel().setValue(PROP_STRATEGY_IMAGE, (Object)customCardImg, 1);
            this.getModel().setValue(PROP_STRATEGY_VALUE, (Object)CHUNK_STRATEGY_AUTO, 0);
            this.getModel().setValue(PROP_STRATEGY_VALUE, (Object)CHUNK_STRATEGY_CUSTOM, 1);
            if (CHUNK_STRATEGY_AUTO.equals(strategy)) {
                chunkStrategyCard.selectRows(0);
            } else if (CHUNK_STRATEGY_CUSTOM.equals(strategy)) {
                chunkStrategyCard.selectRows(1);
            }
        }
    }

    private void setLock() {
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(false), lockFields);
    }

    private void loadEmptyField() {
        String chunkStrategy;
        String updateStrategy;
        String dataSource = (String)this.getModel().getValue(PROP_DATA_SOURCE);
        if (StringUtils.isEmpty((CharSequence)dataSource)) {
            this.getModel().setValue(PROP_DATA_SOURCE, (Object)"community");
        }
        if (StringUtils.isEmpty((CharSequence)(updateStrategy = (String)this.getModel().getValue(PROP_UPDATE_STRATEGY)))) {
            this.getModel().setValue(PROP_UPDATE_STRATEGY, (Object)"week");
        }
        if (StringUtils.isEmpty((CharSequence)(chunkStrategy = (String)this.getModel().getValue(PROP_CHUNK_STRATEGY)))) {
            this.getModel().setValue(PROP_CHUNK_STRATEGY, (Object)CHUNK_STRATEGY_CUSTOM);
        }
    }

    private boolean hasKnowledge() {
        String number = (String)this.getModel().getValue(PROP_NUMBER);
        String sql = String.format("select count(1)  from t_knl_corpus where fgroupid in (select fid from t_knl_group where ftype = '%s')", number);
        Long count = (Long)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return rs.getLong(1);
                }
                return 0L;
            }
        });
        return count > 0L;
    }
}

