/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.knowledage;

import java.io.IOException;
import kd.bos.gptas.km.DataUtil;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Parser;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class HtmlHandler {
    public String extract(String html) throws IOException {
        Document doc = DataUtil.parseHtml(html, "UTF-8", "", Parser.htmlParser());
        return this.getPlainText((Element)doc);
    }

    public String getPlainText(Element element) {
        FormattingVisitor formatter = new FormattingVisitor();
        NodeTraversor.traverse((NodeVisitor)formatter, (Node)element);
        return formatter.toString();
    }

    private class FormattingVisitor
    implements NodeVisitor {
        private static final int maxWidth = 80;
        private int width = 0;
        private StringBuilder accum = new StringBuilder();

        private FormattingVisitor() {
        }

        public void head(Node node, int depth) {
            String name = node.nodeName();
            if (node instanceof TextNode) {
                this.append(((TextNode)node).text());
            } else if (name.equals("li")) {
                this.append("\n * ");
            } else if (name.equals("dt")) {
                this.append("  ");
            } else if (StringUtil.in((String)name, (String[])new String[]{"p", "h1", "h2", "h3", "h4", "h5", "tr"})) {
                // empty if block
            }
        }

        public void tail(Node node, int depth) {
            String name = node.nodeName();
            if (!StringUtil.in((String)name, (String[])new String[]{"br", "dd", "dt", "p", "h1", "h2", "h3", "h4", "h5"}) && name.equals("a")) {
                String href = node.absUrl("href");
                if (href.equals("")) {
                    if (node.hasAttr("href") && node.attr("href").startsWith("/download")) {
                        href = StringUtil.resolve((String)"https://vip.kingdee.com/", (String)node.attr("href"));
                        this.append(String.format(" <%s>", href));
                    }
                } else {
                    this.append(String.format(" <%s>", href));
                }
            }
        }

        private void append(String text) {
            if (text.startsWith("\n")) {
                this.width = 0;
            }
            if (text.equals(" ") && (this.accum.length() == 0 || StringUtil.in((String)this.accum.substring(this.accum.length() - 1), (String[])new String[]{" ", "\n"}))) {
                return;
            }
            if ((text = text.replaceAll("\\u00A0+", "").replaceAll("\\u3000+", "")).length() + this.width > 80) {
                String[] words = text.split("\\s+");
                for (int i = 0; i < words.length; ++i) {
                    boolean last;
                    String word = words[i];
                    boolean bl = last = i == words.length - 1;
                    if (!last) {
                        word = word + " ";
                    }
                    if (word.length() + this.width > 80) {
                        this.accum.append("\n").append(word);
                        this.width = word.length();
                        continue;
                    }
                    this.accum.append(word);
                    this.width += word.length();
                }
            } else {
                this.accum.append(text);
                this.width += text.length();
            }
        }

        public String toString() {
            return this.accum.toString();
        }
    }
}

