/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.knowledage;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.upgrade.entity.DeployResultEnum;
import kd.bos.devportal.upgrade.entity.DeployResultInfo;
import kd.bos.devportal.util.AppPackageUtil;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.km.File.FileInfoHandle;
import kd.bos.gptas.km.splitter.ISplitter;
import kd.bos.gptas.km.splitter.JavaCodeSplitter;
import kd.bos.gptas.km.splitter.KingScriptSplitter;
import kd.bos.gptas.milvus.Chunk;
import kd.bos.gptas.milvus.MilvusDao;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.ExceptionUtils;

public class ImportCodeFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String BOS_DEVPORTAL_GPTAS = "bos-devportal-gptas";
    private static final Log log = LogFactory.getLog(ImportCodeFormPlugin.class);
    private static final String URLARR = "urlarr";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        AttachmentPanel dbspanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        dbspanel.addUploadListener((UploadListener)this);
    }

    public void initialize() {
        Object type = this.getView().getFormShowParameter().getCustomParam("type");
        if (type != null) {
            Map result = BusinessDataReader.loadFromCache((String)"corpus_libs", (QFilter[])new QFilter[]{new QFilter("number", "=", type)});
            if (result.size() != 1) {
                log.warn("corpus_libs has the same number");
            } else {
                Optional optional = result.values().stream().findFirst();
                DynamicObject dynamicObject = (DynamicObject)optional.get();
                String repoIdStr = dynamicObject.getString("indexmethod");
                this.getPageCache().put("repoid", repoIdStr);
                DynamicObject assistantType = dynamicObject.getDynamicObject("type");
                String assistantTypeNum = assistantType.getString("number");
                this.getPageCache().put("assistanttype.number", assistantTypeNum);
            }
        }
    }

    public void upload(UploadEvent arg0) {
        if (arg0 == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImportCodeFormPlugin_1", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]));
            return;
        }
        Object[] args = arg0.getUrls();
        if (args == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImportCodeFormPlugin_1", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]));
            return;
        }
        for (int n = 0; n < args.length; ++n) {
            Map urlMsg = (Map)args[n];
            String urlName = (String)urlMsg.get("name");
            String url = (String)urlMsg.get("url");
            JSONArray jsonArr = new JSONArray();
            JSONObject jsonObj = new JSONObject();
            jsonObj.put(urlName, (Object)url);
            jsonArr.add((Object)jsonObj);
            JSONArray urlArr = JSONArray.parseArray((String)this.getPageCache().get(URLARR));
            if (urlArr != null && !urlArr.isEmpty()) {
                for (int i = 0; i < urlArr.size(); ++i) {
                    JSONObject urlObjCatch = (JSONObject)urlArr.get(i);
                    if (!urlObjCatch.containsKey((Object)urlName)) continue;
                    urlArr.remove((Object)urlObjCatch);
                }
                urlArr.addAll((Collection)jsonArr);
                this.getPageCache().put(URLARR, urlArr.toJSONString());
                continue;
            }
            this.getPageCache().put(URLARR, jsonArr.toJSONString());
        }
    }

    public void remove(UploadEvent arg0) {
        Map urlMsg = (Map)arg0.getUrls()[0];
        String urlName = (String)urlMsg.get("name");
        JSONArray urlArr = JSONArray.parseArray((String)this.getPageCache().get(URLARR));
        if (urlArr != null && !urlArr.isEmpty()) {
            for (int i = 0; i < urlArr.size(); ++i) {
                JSONObject urlCatch = (JSONObject)urlArr.get(i);
                if (!urlCatch.containsKey((Object)urlName)) continue;
                urlArr.remove((Object)urlCatch);
            }
            this.getPageCache().put(URLARR, urlArr.toJSONString());
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnok": {
                this.confirmToInstall();
            }
        }
    }

    private void confirmToInstall() {
        if (this.isHaveAttachment()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u9644\u4ef6\u3002", (String)"ImportCodeFormPlugin_2", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]));
            return;
        }
        if (this.hasAttachmentUploading()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ImportCodeFormPlugin_3", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]));
            return;
        }
        JSONArray urlArr = JSONArray.parseArray((String)this.getPageCache().get(URLARR));
        try {
            this.getView().returnDataToParent((Object)this.install(urlArr));
            this.getView().close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isHaveAttachment() {
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        List attachmentData = panel.getAttachmentData();
        return attachmentData.isEmpty();
    }

    private boolean hasAttachmentUploading() {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String uploadingAttJson = cache.get("UploadingAtt" + this.getView().getPageId());
        return StringUtils.isNotBlank((CharSequence)uploadingAttJson);
    }

    public JSONObject install(JSONArray patchUrlArr) {
        JSONObject result = new JSONObject();
        result.put("success", (Object)"true");
        for (Object obj : patchUrlArr) {
            JSONObject patchUrlObj = (JSONObject)obj;
            String patchName = (String)patchUrlObj.keySet().stream().findFirst().get();
            String patchUrl = patchUrlObj.getString(patchName);
            ImportCodeFormPlugin.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u8bfb\u53d6\u538b\u7f29\u5305 %s \u7684\u6587\u4ef6\u5185\u5bb9\u3002", (String)"ImportCodeFormPlugin_0", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), patchName));
            DeployResultInfo patchDeployInfo = this.getDeployFileContent(patchName, patchUrl);
            if (!StringUtils.equalsIgnoreCase((CharSequence)patchDeployInfo.getResult(), (CharSequence)DeployResultEnum.FAIL.getCode())) continue;
            ArrayList<String> deployErrList = new ArrayList<String>();
            deployErrList.add(SerializationUtils.toJsonString((Object)patchDeployInfo));
            result.put("detail", deployErrList);
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DeployResultInfo getDeployFileContent(String patchName, String patchUrl) {
        DeployResultInfo patchDeployInfo = new DeployResultInfo(patchName);
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream inputStream = cache.getInputStream(patchUrl);
             ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            if (zipInputStream.getNextEntry() == null) {
                String errMsg = ResManager.loadKDString((String)"\u538b\u7f29\u5305\u6709\u8bef\uff0c\u4e0d\u5305\u542b\u4efb\u4f55\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ImportCodeFormPlugin_4", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
                patchDeployInfo.addErrorMsg(errMsg);
                ImportCodeFormPlugin.setErrorLog(errMsg);
                DeployResultInfo deployResultInfo = patchDeployInfo;
                return deployResultInfo;
            }
        }
        catch (Exception e) {
            String errMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            patchDeployInfo.addErrorMsg(errMsg);
            ImportCodeFormPlugin.setErrorLog(errMsg);
            return patchDeployInfo;
        }
        Object createNode = this.getModel().getValue("createnode");
        ArrayList<DynamicObject> codeDynamicObjects = new ArrayList<DynamicObject>();
        Map<String, Object> group = this.getFocusGroupNode();
        try (InputStream inStream = cache.getInputStream(patchUrl);
             ZipInputStream zipInputStream = new ZipInputStream(inStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                try {
                    if (!zipEntry.isDirectory()) {
                        String zipEntryFileName = zipEntry.getName();
                        zipEntryFileName = zipEntryFileName.replace(File.separator, "/");
                        ImportCodeFormPlugin.setInfoLog(String.format(ResManager.loadKDString((String)"\u5f00\u59cb\u8bfb\u53d6\u538b\u7f29\u5305 %1$s \u4e2d\u6587\u4ef6 %2$s \u7684\u5185\u5bb9\u3002", (String)"ImportCodeFormPlugin_5", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), patchName, zipEntryFileName));
                        if (!zipEntryFileName.endsWith(".ts") && !zipEntryFileName.endsWith(".java")) continue;
                        boolean result = this.validate(zipEntryFileName);
                        if (!result) {
                            String suffix = zipEntryFileName.endsWith(".ts") ? "java" : "ts";
                            String errMsg = String.format(ResManager.loadKDString((String)"\u672c\u52a9\u624b\u53ea\u80fd\u5f15\u5165%s\u6587\u4ef6\u3002", (String)"ImportCodeFormPlugin_7", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), suffix);
                            patchDeployInfo.addErrorMsg(errMsg);
                            ImportCodeFormPlugin.setErrorLog(errMsg);
                            DeployResultInfo deployResultInfo = patchDeployInfo;
                            return deployResultInfo;
                        }
                        String content = AppPackageUtil.readFileContent((ZipInputStream)zipInputStream);
                        DynamicObject dynamicObject = this.createKnlInstance(content, zipEntryFileName, group);
                        codeDynamicObjects.add(dynamicObject);
                        if (codeDynamicObjects.size() < 50) continue;
                        this.saveKnowledage(codeDynamicObjects);
                        continue;
                    }
                    if (!((Boolean)createNode).booleanValue()) continue;
                    this.handleGroup(zipEntry, group);
                }
                catch (Exception e) {
                    String errMsg = String.format(ResManager.loadKDString((String)"\u538b\u7f29\u5305\u8bfb\u53d6\u5931\u8d25\uff0c\u8be6\u60c5\u5982\u4e0b\uff1a%s\u3002", (String)"ImportCodeFormPlugin_6", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    ImportCodeFormPlugin.setErrorLog(errMsg);
                }
            }
            return patchDeployInfo;
        }
        catch (IOException ioException) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u538b\u7f29\u5305\u8bfb\u53d6\u5931\u8d25\uff0c\u8be6\u60c5\u5982\u4e0b\uff1a%s\u3002", (String)"ImportCodeFormPlugin_6", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ExceptionUtils.getExceptionStackTraceMessage((Exception)ioException));
            ImportCodeFormPlugin.setErrorLog(errMsg);
            patchDeployInfo.addErrorMsg(errMsg);
            return patchDeployInfo;
        }
        finally {
            if (!codeDynamicObjects.isEmpty()) {
                this.saveKnowledage(codeDynamicObjects);
            }
        }
    }

    private boolean validate(String zipEntryFileName) {
        String assistantTypeNumber = this.getPageCache().get("assistanttype.number");
        boolean result = true;
        if (StringUtils.isNotBlank((CharSequence)assistantTypeNumber)) {
            switch (assistantTypeNumber) {
                case "code_gen_java": {
                    result = zipEntryFileName.endsWith(".java");
                    break;
                }
                case "code_gen_kingscript": {
                    result = zipEntryFileName.endsWith(".ts");
                }
            }
        }
        return result;
    }

    private void handleGroup(ZipEntry zipEntry, Map<String, Object> group) {
        String dirName;
        String zipEntryDirName = zipEntry.getName();
        if (zipEntryDirName.contains(".")) {
            throw new KDException("directory can not contains period.");
        }
        zipEntryDirName = (String)group.get("longNumber") + "." + zipEntryDirName.replace(File.separator, ".").replace("/", ".").replace("\\", ".");
        if (zipEntryDirName.length() > 250) {
            throw new KDException("dir length exceeds 250");
        }
        String lastDir = dirName = zipEntryDirName.substring(0, zipEntryDirName.length() - 1);
        String prefixDir = "";
        if (dirName.contains(".")) {
            int index = dirName.lastIndexOf(".");
            prefixDir = dirName.substring(0, index);
            lastDir = dirName.substring(index + 1);
        }
        String assistantNumber = (String)this.getView().getFormShowParameter().getCustomParam("type");
        QFilter[] qFilters = new QFilter[]{new QFilter("longnumber", "=", (Object)dirName), new QFilter("type", "=", (Object)assistantNumber)};
        Map groupMap = BusinessDataReader.loadFromCache((String)"knl_group", (QFilter[])qFilters);
        if (groupMap.isEmpty()) {
            this.createKnlGroup(assistantNumber, dirName, prefixDir, lastDir);
        }
    }

    private OperationResult createKnlGroup(String assistantNumber, String dir, String prefixDir, String number) {
        DynamicObject dynamicObject = (DynamicObject)EntityMetadataCache.getDataEntityType((String)"knl_group").createInstance();
        dynamicObject.set("number", (Object)number);
        dynamicObject.set("name", (Object)number);
        dynamicObject.set("status", (Object)"C");
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("longnumber", (Object)dir);
        dynamicObject.set("parent_id", (Object)this.getCurrentGroupOfParentId(prefixDir, assistantNumber));
        dynamicObject.set("type", (Object)assistantNumber);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"knl_group", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
        return operationResult;
    }

    private long getCurrentGroupOfParentId(String prefixDir, String assistantNumber) {
        long parentId = 0L;
        if (StringUtils.isNotBlank((CharSequence)prefixDir)) {
            QFilter[] qFilters = new QFilter[]{new QFilter("longnumber", "=", (Object)prefixDir), new QFilter("type", "=", (Object)assistantNumber)};
            Map groupMap = BusinessDataReader.loadFromCache((String)"knl_group", (QFilter[])qFilters);
            for (Map.Entry entry : groupMap.entrySet()) {
                DynamicObject parentGroup = (DynamicObject)entry.getValue();
                String parentLongNumber = parentGroup.getString("longnumber");
                if (!prefixDir.equals(parentLongNumber)) continue;
                parentId = (Long)parentGroup.get("id");
            }
        }
        return parentId;
    }

    private static void setErrorLog(String errorMes) {
        log.error(errorMes);
    }

    private static void setInfoLog(String infoMes) {
        log.info(infoMes);
    }

    private DynamicObject createKnlInstance(String fileContent, String zipEntryFileName, Map<String, Object> group) {
        DynamicObject dynamicObject = (DynamicObject)EntityMetadataCache.getDataEntityType((String)"knl_corpus").createInstance();
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        dynamicObject.set("inputcontent_tag", (Object)fileContent.replaceAll("####################", ""));
        dynamicObject.set("filepath", (Object)zipEntryFileName);
        dynamicObject.set("datasource_id", (Object)1002L);
        int index = zipEntryFileName.lastIndexOf("/");
        String fileName = zipEntryFileName.substring(index + 1);
        String dir = "";
        if (index > 1) {
            dir = zipEntryFileName.substring(0, index).replace(File.separator, ".").replace("/", ".").replace("\\", ".");
        }
        dynamicObject.set("name", (Object)fileName);
        dynamicObject.set("status", (Object)"B");
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
        dynamicObject.set("group_id", this.getCurrentGroup(group, dir, type));
        dynamicObject.set("uploadstatus", (Object)"I");
        Map result = BusinessDataReader.loadFromCache((String)"corpus_libs", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)type)});
        String assistantTypeNum = "";
        int chunkSize = 500;
        if (result.size() != 1) {
            log.warn("corpus_libs has the same number");
        } else {
            Optional optional = result.values().stream().findFirst();
            DynamicObject corpusLib = (DynamicObject)optional.get();
            DynamicObject assistantType = corpusLib.getDynamicObject("type");
            assistantTypeNum = assistantType.getString("number");
            int chunkLen = corpusLib.getInt("chunksize");
            if (chunkLen != 0) {
                chunkSize = chunkLen;
            }
        }
        String number = this.createKnlNumber(assistantTypeNum);
        dynamicObject.set("number", (Object)number);
        dynamicObject.set("segmententity", (Object)this.assemblyDynamicObjectCollection(dynamicObject, assistantTypeNum, fileContent, chunkSize));
        return dynamicObject;
    }

    private Object getCurrentGroup(Map<String, Object> focusGroupNode, String dir, String assistantNumber) {
        String currentLongNumber;
        QFilter[] qFilters;
        Map result;
        Object createNode = this.getModel().getValue("createnode");
        Object currentGroup = null;
        if (((Boolean)createNode).booleanValue() && !(result = BusinessDataReader.loadFromCache((String)"knl_group", (QFilter[])(qFilters = new QFilter[]{new QFilter("longnumber", "=", (Object)(currentLongNumber = StringUtils.isNotBlank((CharSequence)dir) ? focusGroupNode.get("longNumber") + "." + dir : (String)focusGroupNode.get("longNumber"))), new QFilter("type", "=", (Object)assistantNumber)}))).isEmpty()) {
            Optional groupDyObj = result.values().stream().findFirst();
            currentGroup = ((DynamicObject)groupDyObj.get()).get("id");
        }
        if (currentGroup == null) {
            currentGroup = focusGroupNode.get("id");
        }
        return currentGroup;
    }

    private DynamicObjectCollection assemblyDynamicObjectCollection(DynamicObject codedynamicObj, String assistantTypeNum, String fileContent, int chunkSize) {
        ISplitter splitter;
        DynamicObjectType dynamicObjectType = (DynamicObjectType)((BasedataEntityType)codedynamicObj.getDynamicObjectType()).getAllEntities().get("segmententity");
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        switch (assistantTypeNum) {
            case "code_gen_java": {
                splitter = new JavaCodeSplitter();
                break;
            }
            case "code_gen_kingscript": {
                splitter = new KingScriptSplitter();
                break;
            }
            default: {
                log.error("\u5bfc\u5165\u4ee3\u7801\u4f7f\u7528\u4e86\u6587\u7ae0\u5206\u5757");
                return dynamicObjectCollection;
            }
        }
        List<Object> splittedList = splitter.split(fileContent, chunkSize);
        if (splitter instanceof JavaCodeSplitter) {
            Object classDes = splittedList.remove(0);
            codedynamicObj.set("codedes", classDes);
        }
        for (Object splitStr : splittedList) {
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
            dynamicObject.set("segment_tag", splitStr);
            dynamicObject.set("segenable", (Object)Character.valueOf('1'));
            dynamicObjectCollection.add((Object)dynamicObject);
        }
        return dynamicObjectCollection;
    }

    private Map<String, Object> getFocusGroupNode() {
        Object focusNode = this.getView().getFormShowParameter().getCustomParam("focusnode");
        if (focusNode != null) {
            return (Map)SerializationUtils.fromJsonString((String)((String)focusNode), Map.class);
        }
        return new HashMap<String, Object>();
    }

    private String createKnlNumber(String type) {
        StringBuilder preffix = new StringBuilder();
        if (type.equals("code_gen_java")) {
            preffix.append("jv-");
        } else if (type.equals("code_gen_kingscript")) {
            preffix.append("ks-");
        } else {
            preffix.append("other-");
        }
        preffix.append(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append("-").append(String.format("%07d", new SecureRandom().nextInt(10000000)));
        return preffix.toString();
    }

    private void saveKnowledage(List<DynamicObject> dynamicObjects) {
        DynamicObject[] dynamicObjArrays = new DynamicObject[]{};
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"save", (String)"knl_corpus", (DynamicObject[])dynamicObjects.toArray(dynamicObjArrays), (OperateOption)OperateOption.create());
        List fids = opResult.getSuccessPkIds();
        log.info(String.format("\u672c\u6b21\u64cd\u4f5c\u5171%d\u6761\u6570\u636e\uff0c\u6210\u529f%d\u6761", dynamicObjects.size(), fids.size()));
        dynamicObjects.clear();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("type", this.getView().getFormShowParameter().getCustomParam("type"));
        paramMap.put("appid", this.getView().getFormShowParameter().getAppId());
        paramMap.put("entityid", "knl_corpus");
        FileInfoHandle.getAssistantInfo(paramMap);
        ImportCodeFormPlugin.insert2VectorLib(paramMap, fids);
    }

    private static void insert2VectorLib(Map<String, Object> paramMap, List<Object> fids) {
        String repoIdStr = (String)paramMap.get("indexmethod");
        if (StringUtils.isNotBlank((CharSequence)repoIdStr)) {
            ImportCodeFormPlugin.uploadToMilvus(fids, repoIdStr, paramMap);
        }
    }

    private static void uploadToMilvus(List<Object> fids, String indexMethod, Map<String, Object> paramMap) {
        long assistantId = (Long)paramMap.get("assistant_id");
        String assistantNum = (String)paramMap.get("type");
        MilvusDao milvusDao = MilvusDao.create(indexMethod);
        Map result = BusinessDataReader.loadFromCache((Object[])fids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"knl_corpus"));
        Collection dataEntities = result.values();
        for (DynamicObject dynamicObject : dataEntities) {
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            DynamicObjectCollection segmengEntities = dynamicObject.getDynamicObjectCollection("segmententity");
            for (DynamicObject segmentRow : segmengEntities) {
                Chunk chunk = new Chunk();
                chunk.setId(segmentRow.getLong("id"));
                chunk.setKNLId(dynamicObject.getLong("id"));
                chunk.setRepositoryId(assistantId);
                chunk.setChunk(segmentRow.getString("segment_tag"));
                chunks.add(chunk);
            }
            if (chunks.isEmpty()) continue;
            FileInfoHandle.batchInsertMilvus(milvusDao, assistantNum, chunks);
        }
    }
}

