/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.knowledage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.km.parser.AbstractParser;
import kd.bos.gptas.km.parser.FileParseFactory;
import kd.bos.gptas.km.splitter.TextSplitter;
import kd.bos.gptas.km.splitter.TextSplitterProvider;
import kd.bos.gptas.km.splitter.utils.RecursiveCharacterTextSplitter;
import kd.bos.id.ID;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportKnowledgeFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Logger log = LoggerFactory.getLogger(ImportKnowledgeFormPlugin.class);
    private static final String SYSTEM_TYPE = "bos-devportal-gptas";
    private static final String ENTITY_KNL = "knl_corpus";
    private static final String BTN_OK = "btnok";
    private static final String CACHE_FILE_URL = "fileUrl";
    private static final String URL_LOCAL_KNL = "filerserver/gptas/local_knl/";
    private static final String CALLBACK_UPLOAD = "callBackUpload";
    static List<String> fileTypeList = Arrays.asList("pdf", "txt", "docx", "xls", "xlsx");

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
        Button btnUpload = (Button)this.getControl("btn_upload");
        btnUpload.addUploadListener((UploadListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.getModel().setValue("uploadtips", (Object)ResManager.loadKDString((String)"\u652f\u6301\u4e0a\u4f20zip\u6587\u4ef6\uff0c\u652f\u6301\u8bfb\u53d6pdf\u3001txt\u3001docx\u3001xls\u3001xlsx\u6587\u4ef6\u7c7b\u578b", (String)"ImprotKnowleddgeFormPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
    }

    public void beforeClick(BeforeClickEvent evt) {
        Button button;
        String key;
        Object source = evt.getSource();
        if (source instanceof Button && BTN_OK.equals(key = (button = (Button)source).getKey())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            String url = this.getPageCache().get(CACHE_FILE_URL);
            if (entryEntity.isEmpty() || StringUtils.isBlank((CharSequence)url)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"ImprotKnowleddgeFormPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        Button button;
        String key;
        Object source = evt.getSource();
        if (source instanceof Button && BTN_OK.equals(key = (button = (Button)source).getKey())) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u4e0a\u4f20\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"ImprotKnowleddgeFormPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0])));
            this.getView().addClientCallBack(CALLBACK_UPLOAD);
        }
    }

    public void afterUpload(UploadEvent evt) {
        if (evt == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImprotKnowleddgeFormPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        Object[] urls = evt.getUrls();
        if (urls == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImprotKnowleddgeFormPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        String url = urls[0].toString();
        this.batchFillFileInfoEntry(url);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"ImprotKnowleddgeFormPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        this.getPageCache().put(CACHE_FILE_URL, url);
    }

    public void clientCallBack(ClientCallBackEvent evt) {
        String callBackId = evt.getName();
        if (CALLBACK_UPLOAD.equals(callBackId)) {
            this.batchUploadKnlFiles();
            boolean success = this.batchCreateKnlObjs();
            if (!success) {
                return;
            }
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"ImprotKnowleddgeFormPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
            this.getView().hideLoading();
            this.getView().close();
        }
    }

    private void batchFillFileInfoEntry(String url) {
        this.getModel().deleteEntryData("entryentity");
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream inputStream = cache.getInputStream(url);
             ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(inputStream);){
            ZipArchiveEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String fileType;
                String fileName;
                int suffixIndex;
                String relativePath;
                if (zipEntry.isDirectory() || (relativePath = zipEntry.getName()).startsWith("__MACOSX") || (suffixIndex = (fileName = zipEntry.getName().replace("/", File.separator).replace("\\", File.separator)).lastIndexOf(".")) < 0 || !fileTypeList.contains(fileType = fileName.substring(suffixIndex + 1))) continue;
                if (fileName.contains(File.separator)) {
                    fileName = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
                }
                long knlId = ID.genLongId();
                int entryIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("knlid", (Object)knlId, entryIndex);
                this.getModel().setValue("relativepath", (Object)relativePath, entryIndex);
                this.getModel().setValue("filename", (Object)fileName.substring(0, fileName.lastIndexOf(".")), entryIndex);
                this.getModel().setValue("filetype", (Object)fileType, entryIndex);
                this.getModel().setValue("filesize", (Object)this.getFileSizeFormat(zipEntry.getSize()), entryIndex);
                this.getModel().setValue("uploaddate", (Object)new Date(), entryIndex);
            }
        }
        catch (IOException exception) {
            log.error("get file info failed:", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u538b\u7f29\u5305\u6587\u4ef6\u3002", (String)"ImprotKnowleddgeFormPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private void batchUploadKnlFiles() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.isEmpty()) {
            return;
        }
        Map<String, Integer> pathIndexMap = entryEntity.stream().collect(Collectors.toMap(v -> v.getString("relativepath"), v -> v.getInt("seq") - 1));
        String url = this.getPageCache().get(CACHE_FILE_URL);
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        try (InputStream inputStream = cache.getInputStream(url);
             ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(inputStream);){
            ZipArchiveEntry zipEntry;
            ArrayList<FileItem> fileItems = new ArrayList<FileItem>(10);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String relativePath = zipEntry.getName();
                if (!pathIndexMap.containsKey(relativePath)) continue;
                int entryIndex = pathIndexMap.get(relativePath);
                InputStream in = this.copyInputStream((InputStream)zipInputStream);
                Long knlId = (Long)this.getModel().getValue("knlid", entryIndex);
                String fileType = (String)this.getModel().getValue("filetype", entryIndex);
                String fileName = this.getModel().getValue("filename", entryIndex) + "." + fileType;
                String content = this.parseFileContent(fileType, in);
                in.reset();
                FileItem fileItem = new FileItem(fileName, this.getKnlFileUploadPrefix() + fileName, in);
                fileItems.add(fileItem);
                this.getModel().setValue("content_tag", (Object)content, entryIndex);
                this.saveAttachmentInfo(fileName, knlId, fileItem.getPath(), zipEntry.getSize());
            }
            fileService.upload(fileItems.toArray(new FileItem[0]));
        }
        catch (IOException e) {
            log.error("import error:", (Throwable)e);
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"ImprotKnowleddgeFormPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        catch (IllegalArgumentException e) {
            log.error("parse file error:", (Throwable)e);
            this.getView().hideLoading();
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u89e3\u6790\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f\u3002", (String)"ImprotKnowleddgeFormPlugin_13", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private boolean batchCreateKnlObjs() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"ImprotKnowleddgeFormPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return false;
        }
        ArrayList<DynamicObject> knlObjList = new ArrayList<DynamicObject>(entryEntity.size());
        String group = (String)this.getView().getFormShowParameter().getCustomParam("group");
        String libNumber = (String)this.getView().getFormShowParameter().getCustomParam("libNumber");
        RecursiveCharacterTextSplitter recursiveCharacterTextSplitter = TextSplitterProvider.getRecursiveCharacterTextSplitter(libNumber);
        TextSplitter textSplitter = new TextSplitter(recursiveCharacterTextSplitter);
        HashMap<Long, String> knlIdNameMap = new HashMap<Long, String>(entryEntity.size());
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject knlObj = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_KNL);
            Long knlId = (Long)this.getModel().getValue("knlid", i);
            String knlName = (String)this.getModel().getValue("fileName", i);
            String fileType = (String)this.getModel().getValue("fileType", i);
            String filePath = URL_LOCAL_KNL + knlName + "." + fileType;
            knlObj.set("id", (Object)knlId);
            knlObj.set("name", (Object)knlName);
            knlObj.set("number", (Object)("local_" + knlId));
            knlObj.set("group_id", (Object)Long.valueOf(group));
            knlObj.set("datasource_id", (Object)1004);
            knlObj.set("filepath", (Object)filePath);
            knlObj.set("status", (Object)"B");
            String content = (String)this.getModel().getValue("content_tag", i);
            if (StringUtils.isNotBlank((CharSequence)content)) {
                knlObj.set("inputcontent_tag", (Object)content);
            }
            List<Object> segments = textSplitter.split(content, 0);
            this.batchCreateChunkRows(segments, knlObj);
            knlObjList.add(knlObj);
            knlIdNameMap.put(knlId, knlName);
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)ENTITY_KNL, (DynamicObject[])knlObjList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            return true;
        }
        String failedMessageTitle = "";
        List successPkIds = result.getSuccessPkIds();
        failedMessageTitle = successPkIds.isEmpty() ? ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"ImprotKnowleddgeFormPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u90e8\u5206\u77e5\u8bc6\u5bfc\u5165\u5931\u8d25", (String)"ImprotKnowleddgeFormPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        List errorInfos = result.getAllErrorInfo();
        StringBuilder builder = new StringBuilder();
        for (OperateErrorInfo errorInfo : errorInfos) {
            Long pkValue = (Long)errorInfo.getPkValue();
            if (!knlIdNameMap.containsKey(pkValue)) continue;
            builder.append((String)knlIdNameMap.get(pkValue)).append(errorInfo.getMessage()).append("\n");
        }
        this.getView().showMessage(failedMessageTitle, builder.toString(), MessageTypes.Default);
        return false;
    }

    private void batchCreateChunkRows(List<Object> segments, DynamicObject knl) {
        if (segments.isEmpty()) {
            return;
        }
        DynamicObjectCollection segmentEntities = knl.getDynamicObjectCollection("segmententity");
        for (Object seg : segments) {
            DynamicObject segObj = segmentEntities.addNew();
            segObj.set("segment_tag", seg);
            segObj.set("segenable", (Object)Character.valueOf('1'));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream copyInputStream(InputStream in) {
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int len;
            while ((len = in.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String parseFileContent(String fileType, InputStream in) throws IOException {
        if (StringUtils.isBlank((CharSequence)fileType)) {
            return "";
        }
        AbstractParser parser = FileParseFactory.getParser(fileType);
        return parser.getContent(in);
    }

    private void saveAttachmentInfo(String fileName, Object knlPkId, String filePath, long size) {
        HashMap<String, Object> attachmentMap = new HashMap<String, Object>();
        attachmentMap.put("name", fileName);
        attachmentMap.put("entityNum", ENTITY_KNL);
        attachmentMap.put("billPkId", knlPkId);
        attachmentMap.put("size", size);
        attachmentMap.put("status", "success");
        attachmentMap.put("lastModified", new Date().getTime());
        attachmentMap.put("url", filePath);
        AttachmentServiceHelper.upload((String)ENTITY_KNL, (Object)knlPkId, (String)"attachmentpanelap", Collections.singletonList(attachmentMap));
    }

    private String getFileSizeFormat(Long size) {
        DecimalFormat df = new DecimalFormat("0.0");
        if (size < 1024L) {
            return size + "B";
        }
        if (size < 0x100000L) {
            return df.format((double)size.longValue() / 1024.0) + "KB";
        }
        return df.format((double)size.longValue() / 1048576.0) + "MB";
    }

    private String getKnlFileUploadPrefix() {
        RequestContext rc;
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        if (null == (rc = RequestContext.get())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u83b7\u53d6\u4e0a\u4e0b\u6587\u5931\u8d25\u3002", (String)"ImprotKnowleddgeFormPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String tenantId = rc.getTenantId();
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u5230\u79df\u6237ID\u3002", (String)"ImprotKnowleddgeFormPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String accountId = rc.getAccountId();
        if (StringUtils.isBlank((CharSequence)accountId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u5230\u6570\u636e\u4e2d\u5fc3ID\u3002", (String)"ImprotKnowleddgeFormPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String formatDate = sdf.format(new Date());
        return rootPath + String.format("/%s/%s/%s/", tenantId, accountId, formatDate);
    }
}

