/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.knowledage;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;

public class ImportOptionFormPlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener {
    private static final String BOS_DEVPORTAL_GPTAS = "bos-devportal-gptas";
    private static final String CLOUD_TREEVIEWAP = "cloudtreeviewap";
    private static final String SELECTED_TREEVIEWAP = "selectedtreeviewap";

    public void registerListener(EventObject e) {
        TreeView treeView = (TreeView)this.getControl(CLOUD_TREEVIEWAP);
        treeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.addClickListeners(new String[]{"btnadd", "btndel", "btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode cloudTreeRoot = this.renderNewTreeRoot("left");
        List<TreeNode> nodeList = this.getTreeNodes();
        cloudTreeRoot.addChildren(nodeList);
        TreeView treeView = (TreeView)this.getView().getControl(CLOUD_TREEVIEWAP);
        treeView.setMulti(true);
        treeView.addNode(cloudTreeRoot);
        this.getPageCache().put(CLOUD_TREEVIEWAP, SerializationUtils.toJsonString((Object)cloudTreeRoot));
        TreeNode selectedTreeRoot = this.renderNewTreeRoot("right");
        TreeView selectedTreeView = (TreeView)this.getView().getControl(SELECTED_TREEVIEWAP);
        selectedTreeView.setMulti(true);
        selectedTreeView.addNode(selectedTreeRoot);
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
    }

    private TreeNode renderNewTreeRoot(String type) {
        String name = ResManager.loadKDString((String)"\u77e5\u8bc6\u4e91", (String)"ImportOptionFormPlugin_1", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]);
        String text = "";
        if ("left".equals(type)) {
            text = name;
        } else if ("right".equals(type)) {
            text = String.format(ResManager.loadKDString((String)"\u5df2\u9009%s", (String)"ImportOptionFormPlugin_2", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), name);
        }
        TreeNode root = new TreeNode("", "rootnode", text);
        root.setIsOpened(true);
        return root;
    }

    private List<TreeNode> getTreeNodes() {
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(10);
        QFilter[] qFilters = new QFilter[4];
        qFilters[0] = new QFilter("status", "=", (Object)"C");
        qFilters[1] = new QFilter("level", "=", (Object)1);
        qFilters[2] = new QFilter("enable", "=", (Object)"1");
        String type = this.getView().getParentView().getPageCache().get("type");
        if (StringUtils.isNotBlank((CharSequence)type)) {
            qFilters[3] = new QFilter("type", "=", (Object)type);
        }
        Map result = BusinessDataReader.loadFromCache((String)"knl_group", (String)"number, name", (QFilter[])qFilters);
        for (Map.Entry entry : result.entrySet()) {
            DynamicObject cloudDy = (DynamicObject)entry.getValue();
            String number = cloudDy.getString("number");
            String name = (String)((ILocaleString)cloudDy.get("name")).getDefaultItem();
            TreeNode treeNode = new TreeNode("rootnode", number, name);
            treeNodeList.add(treeNode);
        }
        return treeNodeList;
    }

    public void click(EventObject evt) {
        String btnKey;
        Button button = (Button)evt.getSource();
        switch (btnKey = button.getKey()) {
            case "btnadd": {
                TreeView tree = (TreeView)this.getView().getControl(CLOUD_TREEVIEWAP);
                List selectedNodes = tree.getTreeState().getSelectedNodes();
                if (!selectedNodes.isEmpty()) {
                    ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(10);
                    for (Map node : selectedNodes) {
                        if ("rootnode".equals(node.get("id"))) continue;
                        TreeNode treeNode = new TreeNode("rootnode", (String)node.get("id"), (String)node.get("text"));
                        treeNodeList.add(treeNode);
                    }
                    TreeView selectedTreeView = (TreeView)this.getView().getControl(SELECTED_TREEVIEWAP);
                    selectedTreeView.addNodes(treeNodeList);
                    selectedTreeView.checkNodes(treeNodeList);
                    break;
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s\u6570\u636e\u3002", (String)"ImportOptionFormPlugin_3", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ResManager.loadKDString((String)"\u77e5\u8bc6\u4e91", (String)"ImportOptionFormPlugin_1", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
                break;
            }
            case "btndel": {
                TreeView selectedTreeView = (TreeView)this.getView().getControl(SELECTED_TREEVIEWAP);
                List selectedNodes = selectedTreeView.getTreeState().getSelectedNodes();
                if (!selectedNodes.isEmpty()) {
                    ArrayList<String> treeNodeList = new ArrayList<String>(10);
                    for (Map node : selectedNodes) {
                        if ("rootnode".equals(node.get("id"))) continue;
                        treeNodeList.add((String)node.get("id"));
                    }
                    selectedTreeView.deleteNodes(treeNodeList);
                    break;
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s\u6570\u636e\u3002", (String)"ImportOptionFormPlugin_3", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ResManager.loadKDString((String)"\u77e5\u8bc6\u4e91", (String)"ImportOptionFormPlugin_1", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])));
                break;
            }
            case "btnok": {
                this.closeAndreturnData();
            }
        }
    }

    private void closeAndreturnData() {
        TreeView selectedTreeView = (TreeView)this.getView().getControl(SELECTED_TREEVIEWAP);
        List selectedIds = selectedTreeView.getTreeState().getCheckedNodeIds();
        selectedIds.remove("rootnode");
        if (selectedIds.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"ImportOptionFormPlugin_4", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent((Object)selectedIds);
        this.getView().close();
    }
}

