/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.knowledage;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.gptas.km.knowledage.ArticleHandler;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;

public class KnowledageCorpusListPlugin
extends AbstractTreeListPlugin {
    public void initialize() {
        super.initialize();
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (formShowParameter != null) {
            String repoId;
            String type = (String)formShowParameter.getCustomParam("type");
            if (StringUtils.isNotBlank((CharSequence)type)) {
                this.getView().getPageCache().put("type", type);
            }
            if ((repoId = (String)formShowParameter.getCustomParam("repoid")) != null) {
                this.getView().getPageCache().put("repoid", repoId);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterBindData(EventObject e) {
        ListShowParameter formShowParameter;
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        Object dataSource = lsp.getCustomParam("datasource");
        boolean isUpdateKnlVisible = false;
        boolean isImportKnlVisible = false;
        boolean isImportCodeVisible = false;
        if (null == dataSource || "community".equals(dataSource)) {
            isUpdateKnlVisible = true;
            isImportKnlVisible = true;
        } else if ("local".equals(dataSource) && null != (formShowParameter = (ListShowParameter)this.getView().getFormShowParameter())) {
            String assistantType = (String)formShowParameter.getCustomParam("assistanttype");
            if ("code_gen_kingscript".equals(assistantType) || "code_gen_java".equals(assistantType)) {
                isImportCodeVisible = true;
            } else if ("knowledge_qa".equals(assistantType)) {
                isImportKnlVisible = true;
            }
        }
        this.getView().setVisible(Boolean.valueOf(isUpdateKnlVisible), new String[]{"importarticle"});
        this.getView().setVisible(Boolean.valueOf(isImportKnlVisible), new String[]{"importknl"});
        this.getView().setVisible(Boolean.valueOf(isImportCodeVisible), new String[]{"importcode"});
    }

    public void setFilter(SetFilterEvent e) {
        String type;
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (formShowParameter != null && StringUtils.isNotBlank((CharSequence)(type = (String)formShowParameter.getCustomParam("type")))) {
            e.addCustomQFilter(new QFilter("group.type", "=", (Object)type));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "importarticle": {
                this.openImportArticleForm();
                break;
            }
            case "importcode": {
                this.openImportCodeForm();
                break;
            }
            case "importknl": {
                this.openImportKnowledgeForm();
                break;
            }
        }
    }

    public void beforeExportFile(BeforeExportFileEvent e) {
        throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5bfc\u51fa\u77e5\u8bc6\u3002", (String)"KnowledageCorpusListPlugin_1", (String)"bos-devportal-gptas", (Object[])new Object[0]));
    }

    private void openImportArticleForm() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("import_option");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectdomain"));
        this.getView().showForm(showParameter);
    }

    private void openImportCodeForm() {
        Map focusNode = ((TreeView)this.getView().getControl("treeview")).getTreeState().getFocusNode();
        Object parentId = focusNode.get("parentid");
        if (StringUtils.isBlank(parentId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u975e\u6839\u8282\u70b9\u3002", (String)"KnowledageCorpusListPlugin_0", (String)"bos-devportal-gptas", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importcode");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String type = this.getView().getPageCache().get("type");
        if (StringUtils.isNotBlank((CharSequence)type)) {
            showParameter.setCustomParam("type", (Object)type);
        }
        showParameter.setCustomParam("focusnode", (Object)SerializationUtils.toJsonString((Object)focusNode));
        this.getView().showForm(showParameter);
    }

    private void openImportKnowledgeForm() {
        Map focusNode = ((TreeView)this.getView().getControl("treeview")).getTreeState().getFocusNode();
        Object parentId = focusNode.get("parentid");
        if (StringUtils.isBlank(parentId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u975e\u6839\u8282\u70b9\u3002", (String)"KnowledageCorpusListPlugin_0", (String)"bos-devportal-gptas", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("import_knowledge");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("group", focusNode.get("id"));
        String libNumber = this.getPageCache().get("type");
        if (StringUtils.isNotBlank((CharSequence)libNumber)) {
            showParameter.setCustomParam("libNumber", (Object)libNumber);
        }
        this.getView().showForm(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)source;
            String opKey = operate.getOperateKey();
            if ("unsubmit".equals(opKey) || "submit".equals(opKey) || "importarticle".equals(opKey)) {
                operate.getOption().setVariableValue("repoid", this.getView().getPageCache().get("repoid"));
                operate.getOption().setVariableValue("entityid", operate.getEntityId());
                operate.getOption().setVariableValue("appid", this.getView().getFormShowParameter().getAppId());
            }
            String type = this.getView().getPageCache().get("type");
            operate.getOption().setVariableValue("type", type);
            if (type != null) {
                switch (type) {
                    case "cosmic_qa": {
                        operate.getOption().setVariableValue("assistant_type", "cosmic_qa");
                        break;
                    }
                    case "cosmic_codegen_java": 
                    case "cosmic_codegen_kingscript": {
                        operate.getOption().setVariableValue("assistant_type", "cosmic_codegen");
                    }
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvt) {
        String actionId = closedCallBackEvt.getActionId();
        Object returnData = closedCallBackEvt.getReturnData();
        if ("selectdomain".equals(actionId) && returnData != null) {
            String appId = this.getView().getFormShowParameter().getAppId();
            String entityId = ((IListView)this.getView()).getBillFormId();
            this.getPageCache().put("appid", appId);
            this.getPageCache().put("entityid", entityId);
            HashMap<String, Object> paramMap = new HashMap<String, Object>(this.getView().getPageCache().getAll());
            ArticleHandler.importArticle((ArrayList)returnData, paramMap);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("importcode".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

