/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.knowledage;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.gptas.km.splitter.JavaCodeSplitter;
import kd.bos.gptas.km.splitter.KingScriptSplitter;
import kd.bos.gptas.km.splitter.TextSplitter;
import kd.bos.gptas.km.splitter.TextSplitterProvider;
import kd.bos.gptas.km.splitter.VideoSplitter;
import kd.bos.gptas.km.splitter.utils.RecursiveCharacterTextSplitter;
import kd.bos.gptas.km.splitter.utils.VideoTextSplitter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeCorpusFormPlugin
extends AbstractBasePlugIn {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeCorpusFormPlugin.class);
    private static final String PROP_GROUP = "group";
    private static final String PROP_GROUP_ID = "group_id";
    private static final String CACHE_GROUP = "knl_group";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"edit"});
    }

    public void afterBindData(EventObject e) {
        this.setControlVisible();
        String sampleText = (String)this.getModel().getValue("inputcontent_tag");
        Markdown md = (Markdown)this.getView().getControl("markdownap");
        if (!sampleText.trim().startsWith("```")) {
            md.setText("```\n" + sampleText);
        } else {
            md.setText(sampleText);
        }
        this.updateMarkdown();
    }

    public void afterCreateNewData(EventObject e) {
        String group = this.getView().getPageCache().get(CACHE_GROUP);
        if (StringUtils.isNotBlank((CharSequence)group)) {
            this.getModel().setValue(PROP_GROUP, (Object)Long.valueOf(group));
        }
    }

    private void setControlVisible() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String assistantNumber;
            String repoId = parentView.getPageCache().get("repoid");
            if (repoId != null) {
                this.getView().getPageCache().put("repoid", repoId);
            }
            if ((assistantNumber = parentView.getPageCache().get("type")) != null) {
                this.getView().getPageCache().put("type", assistantNumber);
                String assistantTypeNumber = (String)this.getAssistantPropValue(assistantNumber, "assistanttypenum");
                boolean tsTypeVisible = false;
                boolean codeDesVisible = false;
                switch (assistantTypeNumber) {
                    case "code_gen_java": {
                        codeDesVisible = true;
                        break;
                    }
                    case "knowledge_qa": {
                        break;
                    }
                    case "code_gen_kingscript": {
                        tsTypeVisible = true;
                        codeDesVisible = true;
                    }
                }
                this.getView().setVisible(Boolean.valueOf(tsTypeVisible), new String[]{"tstype"});
                this.getView().setVisible(Boolean.valueOf(codeDesVisible), new String[]{"codedes"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "tstype": {
                if (StringUtils.isNotBlank((Object)newValue)) {
                    String templateId = (String)this.getModel().getValue("tstype");
                    DynamicObject scriptObj = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"ide_pluginscript");
                    String content = scriptObj == null ? "" : scriptObj.getString("txt_scriptcontext_tag");
                    String title = "```\n" + content + "\n```";
                    Markdown md = (Markdown)this.getView().getControl("markdownap");
                    md.setText(title);
                }
            }
            case "number": {
                this.updateFilePathValue();
                break;
            }
            case "inputcontent_tag": {
                this.splite2Chunck((String)newValue, true);
            }
        }
    }

    public void click(EventObject evt) {
        Button button;
        String key;
        Object source = evt.getSource();
        if (source instanceof Button && "edit".equals(key = (button = (Button)source).getKey())) {
            this.showSegmentForm();
        }
    }

    private void showSegmentForm() {
        EntryGrid segmentGrid = (EntryGrid)this.getControl("segmententity");
        int[] selRow = segmentGrid.getSelectRows();
        DynamicObject segmentDynamicObj = (DynamicObject)((DynamicObjectCollection)this.getModel().getDataEntity(true).get("segmententity")).get(selRow[0]);
        String segmentContect = segmentDynamicObj.getString("segment_tag");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_segment");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("seq", segmentDynamicObj.get("seq"));
        showParameter.setCustomParam("segment", (Object)segmentContect);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "edit_segment"));
        this.getView().showForm(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operationKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operationKey = operate.getOperateKey()) {
            case "save": 
            case "submit": {
                this.updateValBeforeSave();
                break;
            }
            case "saveandnew": 
            case "new": {
                this.getPageCache().put(CACHE_GROUP, this.getModel().getValue(PROP_GROUP_ID).toString());
                break;
            }
        }
        if ("unsubmit".equals(operationKey) || "submit".equals(operationKey)) {
            operate.getOption().setVariableValue("repoid", this.getView().getPageCache().get("repoid"));
            operate.getOption().setVariableValue("entityid", operate.getEntityId());
            operate.getOption().setVariableValue("appid", this.getView().getFormShowParameter().getAppId());
        }
        String type = this.getView().getPageCache().get("type");
        operate.getOption().setVariableValue("type", type);
        if (type != null) {
            switch (type) {
                case "cosmic_qa": {
                    operate.getOption().setVariableValue("assistant_type", "cosmic_qa");
                    break;
                }
                case "cosmic_codegen_java": 
                case "cosmic_codegen_kingscript": {
                    operate.getOption().setVariableValue("assistant_type", "cosmic_codegen");
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        this.updateMarkdown();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void updateValBeforeSave() {
        this.getModel().getDataEntity(true);
        Markdown md = (Markdown)this.getView().getControl("markdownap");
        String sampleText = md.getText();
        if (StringUtils.isBlank((CharSequence)sampleText)) {
            return;
        }
        String ltrimSample = this.ltrim(sampleText);
        if (ltrimSample.startsWith("```\n")) {
            this.getModel().setValue("inputcontent_tag", (Object)ltrimSample.substring(4));
        } else if (ltrimSample.startsWith("```")) {
            this.getModel().setValue("inputcontent_tag", (Object)ltrimSample.substring(3));
        } else {
            this.getModel().setValue("inputcontent_tag", (Object)sampleText);
        }
        this.updateFilePathValue();
        this.splite2Chunck(sampleText, false);
    }

    private void splite2Chunck(String content, boolean forceSplit) {
        IDataModel model = this.getModel();
        Object dataSource = model.getValue("datasource");
        DynamicObjectCollection segmentEntity = model.getEntryEntity("segmententity");
        if (forceSplit && !segmentEntity.isEmpty()) {
            model.deleteEntryData("segmententity");
            segmentEntity = model.getEntryEntity("segmententity");
        }
        if (segmentEntity.isEmpty()) {
            if (dataSource != null && 1003L == (Long)((DynamicObject)dataSource).get("id")) {
                VideoSplitter splitter = new VideoSplitter();
                List<Object> segments = splitter.split(content, 0);
                this.batchCreateNewEntryRow(segments, true);
            } else {
                List<Object> segments;
                String assistantTypeNum;
                String assistantNum = this.getPageCache().get("type");
                switch (assistantTypeNum = (String)this.getAssistantPropValue(assistantNum, "assistanttypenum")) {
                    case "code_gen_java": {
                        JavaCodeSplitter splitter = new JavaCodeSplitter();
                        segments = splitter.split(content, 0);
                        model.setValue("codedes", segments.remove(0));
                        break;
                    }
                    case "code_gen_kingscript": {
                        KingScriptSplitter splitter = new KingScriptSplitter();
                        int chunckSize = (Integer)this.getAssistantPropValue(assistantNum, "chunksize");
                        segments = splitter.split(content, chunckSize);
                        break;
                    }
                    default: {
                        RecursiveCharacterTextSplitter recursiveCharacterTextSplitter = TextSplitterProvider.getRecursiveCharacterTextSplitter(assistantNum);
                        TextSplitter splitter = new TextSplitter(recursiveCharacterTextSplitter);
                        segments = splitter.split(content, 0);
                        break;
                    }
                }
                this.batchCreateNewEntryRow(segments, false);
            }
        }
    }

    private void batchCreateNewEntryRow(List<Object> segments, boolean isVideo) {
        if (segments.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        int[] rowKeys = model.batchCreateNewEntryRow("segmententity", segments.size());
        int i = 0;
        if (isVideo) {
            for (Object seg : segments) {
                model.setValue("segment_tag", (Object)((VideoTextSplitter.Paragraph)seg).getContent(), rowKeys[i]);
                model.setValue("segtime", (Object)((VideoTextSplitter.Paragraph)seg).getTime(), rowKeys[i]);
                model.setValue("segenable", (Object)Character.valueOf('1'), rowKeys[i]);
                ++i;
            }
        } else {
            for (Object seg : segments) {
                model.setValue("segment_tag", seg, rowKeys[i]);
                model.setValue("segenable", (Object)Character.valueOf('1'), rowKeys[i]);
                ++i;
            }
        }
    }

    private void updateMarkdown() {
        Markdown md = (Markdown)this.getView().getControl("markdownap");
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            md.setModelType(Markdown.Preview);
        } else {
            String value = (String)this.getModel().getValue("status");
            if ("A".equals(value)) {
                md.setModelType(Markdown.Edit);
            } else {
                md.setModelType(Markdown.Preview);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvt) {
        String actionId = closedCallBackEvt.getActionId();
        Object returnData = closedCallBackEvt.getReturnData();
        if ("edit_segment".equals(actionId) && returnData != null) {
            int row = (Integer)((Map)returnData).get("row");
            String segment = (String)((Map)returnData).get("segment_tag");
            this.getModel().setValue("segment_tag", (Object)segment, row - 1);
        }
    }

    private void updateFilePathValue() {
        long datasourceId;
        IDataModel model = this.getModel();
        Object dataSource = model.getValue("datasource");
        if (dataSource != null && (1003L == (datasourceId = ((Long)((DynamicObject)dataSource).get("id")).longValue()) || 1002L == datasourceId)) {
            this.getModel().setValue("filepath", this.getModel().getValue("number"));
        }
    }

    private Object getAssistantPropValue(String assistantNum, String propName) {
        HashMap<String, Object> propValueMap = new HashMap<String, Object>(10);
        Map result = BusinessDataReader.loadFromCache((String)"corpus_libs", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)assistantNum)});
        if (result.size() != 1) {
            log.error(String.format("\u7f16\u7801\u4e3a%s\u7684\u52a9\u624b\u4e0d\u5b58\u5728\u6216\u8005\u5b58\u5728\u591a\u4e2a\u3002", assistantNum));
        }
        int chunckSize = 500;
        String assistantTypeNum = "";
        Optional optional = result.values().stream().findFirst();
        if (optional.isPresent()) {
            DynamicObject dynamicObject = (DynamicObject)optional.get();
            chunckSize = dynamicObject.getInt("chunksize");
            propValueMap.put("chunksize", chunckSize);
            DynamicObject assistantType = dynamicObject.getDynamicObject("type");
            assistantTypeNum = assistantType.getString("number");
            propValueMap.put("assistanttypenum", assistantTypeNum);
        }
        return propValueMap.get(propName);
    }

    public String ltrim(String value) {
        int st;
        int len = value.length();
        for (st = 0; st < len && value.charAt(st) <= ' '; ++st) {
        }
        return st > 0 ? value.substring(st, len) : value;
    }
}

