/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.knowledage;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.gptas.km.File.FileInfoHandle;
import kd.bos.gptas.milvus.Chunk;
import kd.bos.gptas.milvus.MilvusDao;
import kd.bos.orm.query.QFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeCorpusSubmitOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeCorpusSubmitOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("inputcontent_tag");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("codedes");
        e.getFieldKeys().add("datasource");
        e.getFieldKeys().add("segmententity");
        e.getFieldKeys().add("segmententity.id");
        e.getFieldKeys().add("segmententity.segment_tag");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        String assistantNumber = this.getOption().getVariableValue("type");
        this.insert2VectorLib(dynamicObjects, assistantNumber);
    }

    private void insert2VectorLib(DynamicObject[] dynamicObjects, String assistantNumber) {
        DynamicObject assitantDyObj;
        String indexmethod;
        Map result = BusinessDataReader.loadFromCache((String)"corpus_libs", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)assistantNumber)});
        Optional optional = result.values().stream().findFirst();
        if (optional.isPresent() && StringUtils.isNotBlank((CharSequence)(indexmethod = (assitantDyObj = (DynamicObject)optional.get()).getString("indexmethod")))) {
            this.uploadToMilvus(dynamicObjects, indexmethod, assistantNumber, assitantDyObj.getLong("id"));
        }
    }

    private void uploadToMilvus(DynamicObject[] dataEntities, String indexMethod, String assistantNumber, long assistantId) {
        MilvusDao milvusDao = MilvusDao.create(indexMethod);
        for (DynamicObject dynamicObject : dataEntities) {
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            DynamicObjectCollection segmengEntities = dynamicObject.getDynamicObjectCollection("segmententity");
            for (DynamicObject segmentRow : segmengEntities) {
                Chunk chunk = new Chunk();
                chunk.setId(segmentRow.getLong("id"));
                chunk.setRepositoryId(assistantId);
                chunk.setKNLId(dynamicObject.getLong("id"));
                chunk.setChunk(segmentRow.getString("segment_tag"));
                chunks.add(chunk);
            }
            if (chunks.isEmpty()) continue;
            FileInfoHandle.batchInsertMilvus(milvusDao, assistantNumber, chunks);
        }
    }
}

