/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.knowledage;

import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.gptas.milvus.MilvusDao;
import kd.bos.orm.query.QFilter;

public class KnowledgeCorpusUnsubmitOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("failmsg");
        e.getFieldKeys().add("uploadstatus");
        e.getFieldKeys().add("segmententity");
        e.getFieldKeys().add("segmententity.id");
        e.getFieldKeys().add("segmententity.segment_tag");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dyObjs = e.getDataEntities();
        String assistantNum = this.getOption().getVariableValue("type");
        Map result = BusinessDataReader.loadFromCache((String)"corpus_libs", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)assistantNum)});
        Optional corpusLib = result.values().stream().findFirst();
        if (!corpusLib.isPresent()) {
            return;
        }
        this.deleteKnowledge((DynamicObject)corpusLib.get(), dyObjs);
        this.initField(dyObjs);
    }

    private void deleteKnowledge(DynamicObject corpusLib, DynamicObject[] dyObjs) {
        String indexMethod = "";
        if (corpusLib.containsProperty("indexmethod")) {
            indexMethod = corpusLib.getString("indexmethod");
        }
        if (StringUtils.isNotBlank((CharSequence)indexMethod)) {
            this.deleteKnlFromMilvus(indexMethod, dyObjs);
        }
    }

    private void deleteKnlFromMilvus(String indexMethod, DynamicObject[] dyObjs) {
        MilvusDao milvusDao = MilvusDao.create(indexMethod);
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject dy : dyObjs) {
            DynamicObjectCollection segmengEntities = dy.getDynamicObjectCollection("segmententity");
            for (DynamicObject segmentRow : segmengEntities) {
                idList.add(segmentRow.getLong("id"));
            }
            milvusDao.delByIdList(idList);
            idList.clear();
        }
    }

    private void initField(DynamicObject[] dyObjs) {
        for (DynamicObject dynamicObject : dyObjs) {
            dynamicObject.set("failmsg", (Object)"");
            dynamicObject.set("uploadstatus", (Object)"I");
        }
    }
}

