/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.parser;

import java.io.IOException;
import java.io.InputStream;
import kd.bos.gptas.km.parser.AbstractParser;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelParser
extends AbstractParser {
    private String type;

    public ExcelParser(String type) {
        this.type = type;
    }

    @Override
    public String getContent(InputStream in) throws IOException {
        HSSFWorkbook workBook = null;
        if ("xls".equals(this.type)) {
            workBook = new HSSFWorkbook(in);
        } else if ("xlsx".equals(this.type)) {
            workBook = new XSSFWorkbook(in);
        }
        if (null == workBook) {
            return "";
        }
        DataFormatter formatter = new DataFormatter();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < workBook.getNumberOfSheets(); ++i) {
            Sheet sheet = workBook.getSheetAt(i);
            for (Row row : sheet) {
                for (Cell cell : row) {
                    String cellValue = formatter.formatCellValue(cell);
                    builder.append(cellValue).append(" ");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }
}

