/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.splitter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.gptas.km.splitter.utils.RecursiveCharacterTextSplitter;
import kd.bos.orm.query.QFilter;
import kd.bos.session.SystemPropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextSplitterProvider {
    private static final Logger log = LoggerFactory.getLogger(TextSplitterProvider.class);
    private static volatile Map<String, Long> assistantUpdateTimeMap = new HashMap<String, Long>();
    private static volatile Map<String, RecursiveCharacterTextSplitter> assistantMap = new HashMap<String, RecursiveCharacterTextSplitter>();
    private static final int DEFAULT_CHUNCK_SIZE = 450;
    private static final int DEFAULT_CHUNKOVERLAP = 100;

    public static RecursiveCharacterTextSplitter getRecursiveCharacterTextSplitter(String assitantNum) {
        if (StringUtils.isBlank((CharSequence)assitantNum)) {
            return null;
        }
        if (!assistantUpdateTimeMap.containsKey(assitantNum) && !TextSplitterProvider.updateCacheMap(assitantNum)) {
            return null;
        }
        long lastUpdateTime = assistantUpdateTimeMap.get(assitantNum);
        int corpusLibTimeOut = SystemPropertyUtils.getInteger((String)RequestContext.get().getTenantId(), (String)"corpublib.timeout", (Integer)300000);
        if (System.currentTimeMillis() - lastUpdateTime >= (long)corpusLibTimeOut) {
            TextSplitterProvider.deleteCacheMap(assitantNum);
            TextSplitterProvider.updateCacheMap(assitantNum);
        }
        return assistantMap.get(assitantNum);
    }

    private static boolean updateCacheMap(String assitantNum) {
        Map result = BusinessDataReader.loadFromCache((String)"corpus_libs", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)assitantNum)});
        if (result.size() != 1) {
            log.error(String.format("\u7f16\u7801\u4e3a%s\u7684\u52a9\u624b\u4e0d\u5b58\u5728\u6216\u8005\u5b58\u5728\u591a\u4e2a\u3002", assitantNum));
            return false;
        }
        RecursiveCharacterTextSplitter recursiveCharacterTextSplitter = new RecursiveCharacterTextSplitter();
        int chunckSize = 0;
        int chunckOverLap = 0;
        String separators = "";
        boolean keepSeparator = true;
        Set fids = result.keySet();
        Iterator iterator = fids.iterator();
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)result.get(iterator.next());
            chunckSize = dynamicObject.getInt("chunksize");
            chunckOverLap = dynamicObject.getInt("chunkoverlap");
            separators = dynamicObject.getString("separators");
            keepSeparator = dynamicObject.getBoolean("keepseparator");
        }
        recursiveCharacterTextSplitter.setChunkSize(chunckSize != 0 ? chunckSize : 450);
        recursiveCharacterTextSplitter.setChunkOverlap(chunckOverLap != 0 ? chunckOverLap : 100);
        recursiveCharacterTextSplitter.setSeparators(Arrays.asList(separators.split(",")));
        recursiveCharacterTextSplitter.setKeepSeparator(keepSeparator);
        assistantUpdateTimeMap.put(assitantNum, System.currentTimeMillis());
        assistantMap.put(assitantNum, recursiveCharacterTextSplitter);
        return true;
    }

    private static void deleteCacheMap(String assitantNum) {
        assistantUpdateTimeMap.remove(assitantNum);
        assistantMap.remove(assitantNum);
    }
}

