/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.km.splitter.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import kd.bos.gptas.km.splitter.utils.TextSplitter;

public class RecursiveCharacterTextSplitter
extends TextSplitter {
    protected List<String> separators = Arrays.asList("\n\n", "\n", " ", "");

    public List<String> getSeparators() {
        return this.separators;
    }

    public void setSeparators(List<String> separators) {
        this.separators = new ArrayList<String>(16);
        for (String separator : separators) {
            if (separator.equals(".")) {
                separator = "\\.";
            } else if (separator.equals("?")) {
                separator = "\\?";
            }
            if (separator.isEmpty()) continue;
            this.separators.add(separator);
        }
    }

    public List<String> innerSplitText(String text, List<String> separators) {
        String separator = separators.get(separators.size() - 1);
        List<String> newSeparators = new ArrayList<String>();
        boolean foundSeparator = false;
        for (int i = 0; i < separators.size() && !foundSeparator; ++i) {
            String temp = separators.get(i);
            if (temp.isEmpty()) {
                separator = temp;
                foundSeparator = true;
                continue;
            }
            if (!Pattern.compile(temp).matcher(text).find()) continue;
            separator = temp;
            newSeparators = separators.subList(i + 1, separators.size());
            foundSeparator = true;
        }
        return this.recursivelySplitLongerTexts(text, separator, newSeparators);
    }

    private List<String> recursivelySplitLongerTexts(String text, String separator, List<String> newSeparators) {
        ArrayList<String> finalChunks = new ArrayList<String>();
        List<String> splits = RecursiveCharacterTextSplitter.splitTextWithRegex(text, separator, this.keepSeparator);
        ArrayList<String> tempGoodSplits = new ArrayList<String>();
        String tempSeparator = this.keepSeparator ? "" : separator;
        for (String s : splits) {
            if ((Integer)this.lengthFunction.apply(s) < this.chunkSize) {
                tempGoodSplits.add(s);
                continue;
            }
            if (!tempGoodSplits.isEmpty()) {
                List<String> mergedText = this.mergeSplits(tempGoodSplits, tempSeparator);
                finalChunks.addAll(mergedText);
                tempGoodSplits.clear();
            }
            if (newSeparators.isEmpty()) {
                int strLength = s.length();
                int start = 0;
                int end = this.chunkSize;
                while (start < strLength) {
                    if (end > strLength) {
                        end = strLength;
                    }
                    finalChunks.add(s.substring(start, end));
                    start += this.chunkSize;
                    end += this.chunkSize;
                }
                continue;
            }
            List<String> otherInfo = this.innerSplitText(s, newSeparators);
            finalChunks.addAll(otherInfo);
        }
        if (!tempGoodSplits.isEmpty()) {
            List<String> mergedText = this.mergeSplits(tempGoodSplits, tempSeparator);
            finalChunks.addAll(mergedText);
        }
        return finalChunks;
    }

    @Override
    public List<String> splitText(String text) {
        return this.innerSplitText(text, this.separators);
    }
}

